/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxSerializationException;
import org.apache.geode.pdx.WritablePdxInstance;
import org.apache.geode.pdx.internal.ComparableEnum;
import org.apache.geode.pdx.internal.InternalPdxInstance;

public class EnumInfo
implements DataSerializableFixedID {
    private String clazz;
    private String name;
    private int ordinal;
    private volatile transient WeakReference<Enum<?>> enumCache = null;

    public EnumInfo(Enum<?> e) {
        this.clazz = e.getDeclaringClass().getName();
        this.name = e.name();
        this.ordinal = e.ordinal();
        this.enumCache = new WeakReference(e);
    }

    public EnumInfo(String clazz, String name, int enumOrdinal) {
        this.clazz = clazz;
        this.name = name;
        this.ordinal = enumOrdinal;
    }

    public EnumInfo() {
    }

    @Override
    public int getDSFID() {
        return 9;
    }

    public String getClassName() {
        return this.clazz;
    }

    public void setClassName(String v) {
        this.clazz = v;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.clazz, out);
        DataSerializer.writeString(this.name, out);
        DataSerializer.writePrimitiveInt(this.ordinal, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.clazz = DataSerializer.readString(in);
        this.name = DataSerializer.readString(in);
        this.ordinal = DataSerializer.readPrimitiveInt(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache() {
        EnumInfo enumInfo = this;
        synchronized (enumInfo) {
            this.enumCache = null;
        }
    }

    public int compareTo(EnumInfo other) {
        int result = this.clazz.compareTo(other.clazz);
        if (result == 0 && (result = this.name.compareTo(other.name)) == 0) {
            result = other.ordinal - this.ordinal;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enum<?> getEnum() throws ClassNotFoundException {
        Enum<?> result;
        if (InternalDataSerializer.LOAD_CLASS_EACH_TIME) {
            result = this.loadEnum();
        } else {
            result = this.getExistingEnum();
            if (result == null) {
                EnumInfo enumInfo = this;
                synchronized (enumInfo) {
                    result = this.getExistingEnum();
                    if (result == null) {
                        result = this.loadEnum();
                        this.enumCache = new WeakReference(result);
                    }
                }
            }
        }
        return result;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    private Enum<?> getExistingEnum() {
        WeakReference<Enum<?>> wr = this.enumCache;
        if (wr != null) {
            return (Enum)wr.get();
        }
        return null;
    }

    private Enum<?> loadEnum() throws ClassNotFoundException {
        Class<?> c = InternalDataSerializer.getCachedClass(this.clazz);
        try {
            return Enum.valueOf(c, this.name);
        }
        catch (IllegalArgumentException ex) {
            throw new PdxSerializationException("PDX enum field could not be read because \"" + this.name + "\" is not a valid name in enum class " + c, ex);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public String toString() {
        return this.clazz + "." + this.name;
    }

    public String toFormattedString() {
        return this.getClass().getSimpleName() + "[\n        " + this.clazz + "." + this.name + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumInfo other = (EnumInfo)obj;
        if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.ordinal != other.ordinal) {
            throw new PdxSerializationException("The ordinal value for the enum " + this.name + " on class " + this.clazz + " can not be changed. Pdx only allows new enum constants to be added to the end of the enum.");
        }
        return true;
    }

    public PdxInstance getPdxInstance(int enumId) {
        return new PdxInstanceEnumInfo(enumId, this);
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    public void toStream(PrintStream printStream) {
        printStream.print("  ");
        printStream.print(this.clazz);
        printStream.print('.');
        printStream.print(this.name);
        printStream.println();
    }

    public static class PdxInstanceEnumInfo
    implements InternalPdxInstance,
    ComparableEnum {
        private static final long serialVersionUID = 7907582104525106416L;
        private final int enumId;
        private final EnumInfo ei;
        @Immutable
        private static final List<String> fieldNames;

        public PdxInstanceEnumInfo(int enumId, EnumInfo ei) {
            this.enumId = enumId;
            this.ei = ei;
        }

        @Override
        public String getClassName() {
            return this.ei.clazz;
        }

        @Override
        public String getName() {
            return this.ei.name;
        }

        @Override
        public int getOrdinal() {
            return this.ei.ordinal;
        }

        @Override
        public boolean isEnum() {
            return true;
        }

        @Override
        public Object getObject() {
            try {
                return this.ei.getEnum();
            }
            catch (ClassNotFoundException ex) {
                throw new PdxSerializationException(String.format("Could not create an instance of a class %s", this.getClassName()), ex);
            }
        }

        @Override
        public boolean hasField(String fieldName) {
            return this.getFieldNames().contains(fieldName);
        }

        @Override
        public List<String> getFieldNames() {
            return fieldNames;
        }

        @Override
        public boolean isIdentityField(String fieldName) {
            return false;
        }

        @Override
        public Object getField(String fieldName) {
            if ("name".equals(fieldName)) {
                return this.getName();
            }
            if ("ordinal".equals(fieldName)) {
                return this.getOrdinal();
            }
            return null;
        }

        @Override
        public WritablePdxInstance createWriter() {
            throw new IllegalStateException("PdxInstances that are an enum can not be modified.");
        }

        @Override
        public void sendTo(DataOutput out) throws IOException {
            InternalDataSerializer.writePdxEnumId(this.enumId, out);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            String className = this.getClassName();
            String enumName = this.getName();
            result = 31 * result + (className == null ? 0 : className.hashCode());
            result = 31 * result + (enumName == null ? 0 : enumName.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ComparableEnum)) {
                return false;
            }
            ComparableEnum other = (ComparableEnum)obj;
            String className = this.getClassName();
            if (className == null ? other.getClassName() != null : !className.equals(other.getClassName())) {
                return false;
            }
            String enumName = this.getName();
            return !(enumName == null ? other.getName() != null : !enumName.equals(other.getName()));
        }

        @Override
        public String toString() {
            return this.ei.name;
        }

        @Override
        public byte[] toBytes() throws IOException {
            HeapDataOutputStream hdos = new HeapDataOutputStream(16, Version.CURRENT);
            this.sendTo(hdos);
            return hdos.toByteArray();
        }

        public int compareTo(Object o) {
            if (o instanceof ComparableEnum) {
                ComparableEnum other = (ComparableEnum)o;
                if (!this.getClassName().equals(other.getClassName())) {
                    throw new ClassCastException("Can not compare a " + this.getClassName() + " to a " + other.getClassName());
                }
                return this.getOrdinal() - other.getOrdinal();
            }
            throw new ClassCastException("Can not compare an instance of " + o.getClass() + " to a " + this.getClass());
        }

        static {
            ArrayList<String> tmp = new ArrayList<String>(2);
            tmp.add("name");
            tmp.add("ordinal");
            fieldNames = Collections.unmodifiableList(tmp);
        }
    }
}

