/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.validators;

import java.util.List;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.internal.cache.RegionNameValidation;
import org.apache.geode.management.internal.configuration.validators.ConfigurationValidator;

public class RegionConfigValidator
implements ConfigurationValidator<RegionConfig> {
    @Override
    public void validate(RegionConfig config) throws IllegalArgumentException {
        if (config.getName() == null) {
            throw new IllegalArgumentException("Name of the region has to be specified.");
        }
        RegionNameValidation.validate(config.getName());
        if (config.getType() == null) {
            RegionShortcut defaultRegion = RegionShortcut.PARTITION;
            config.setType(defaultRegion);
        }
    }

    @Override
    public boolean exists(RegionConfig config, CacheConfig existing) {
        return CacheElement.exists((List)existing.getRegions(), (String)config.getId());
    }
}

