/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.zip.DataFormatException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.json.GfJsonArray;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.AbstractResultData;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TableBuilder;
import org.apache.logging.log4j.Logger;

public class LegacyCommandResult
implements CommandResult {
    private static final Logger logger = LogService.getLogger();
    private GfJsonObject gfJsonObject;
    private Result.Status status;
    private int index;
    private boolean isDataBuilt;
    private ResultData resultData;
    private List<String> resultLines;
    private boolean failedToPersist = false;
    private transient int numTimesSaved;
    private Path fileToDownload;

    @Override
    public Path getFileToDownload() {
        return this.fileToDownload;
    }

    public LegacyCommandResult(ResultData resultData) {
        this.resultData = resultData;
        this.gfJsonObject = this.resultData.getGfJsonObject();
        this.status = this.resultData.getStatus();
        this.resultLines = new Vector<String>();
    }

    public LegacyCommandResult(Path fileToDownload) {
        this(new InfoResultData(fileToDownload.toString()));
        this.fileToDownload = fileToDownload.toAbsolutePath();
    }

    @Override
    public boolean hasFileToDownload() {
        return this.fileToDownload != null;
    }

    @Override
    public Result.Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Result.Status status) {
        this.status = status;
    }

    @Override
    public ResultData getResultData() {
        return ResultBuilder.getReadOnlyResultData(this.resultData);
    }

    private GfJsonObject getGfJsonObject() {
        return this.gfJsonObject;
    }

    @Override
    public void resetToFirstLine() {
        this.index = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildData() {
        try {
            if ("composite".equals(this.resultData.getType())) {
                this.buildComposite();
            } else {
                GfJsonObject content = this.getContent();
                if (content != null) {
                    TableBuilder.Table resultTable = TableBuilder.newTable();
                    this.addHeaderInTable(resultTable, this.getGfJsonObject());
                    TableBuilder.RowGroup rowGroup = resultTable.newRowGroup();
                    if ("table".equals(this.resultData.getType())) {
                        resultTable.setColumnSeparator("   ");
                        resultTable.setTabularResult(true);
                        this.buildTable(rowGroup, content);
                    } else {
                        this.buildInfoErrorData(rowGroup, content);
                    }
                    this.addFooterInTable(resultTable, this.getGfJsonObject());
                    this.resultLines.addAll(resultTable.buildTableList());
                }
            }
        }
        catch (GfJsonException e) {
            this.resultLines.add("Error occurred while processing Command Result. Internal Error - Invalid Result.");
        }
        finally {
            this.isDataBuilt = true;
        }
    }

    private void addHeaderInTable(TableBuilder.Table resultTable, GfJsonObject fromJsonObject) {
        String header = this.getHeader(fromJsonObject);
        if (header != null && !header.isEmpty()) {
            resultTable.newRow().newLeftCol(header);
        }
    }

    private void addHeaderInRowGroup(TableBuilder.RowGroup rowGroup, GfJsonObject fromJsonObject) {
        String header = this.getHeader(fromJsonObject);
        if (header != null && !header.isEmpty()) {
            rowGroup.newRow().newLeftCol(header);
        }
    }

    private void addFooterInTable(TableBuilder.Table resultTable, GfJsonObject fromJsonObject) {
        String footer = this.getFooter(fromJsonObject);
        if (footer != null && !footer.isEmpty()) {
            resultTable.newRow().newLeftCol(footer);
        }
    }

    private void addFooterInRowGroup(TableBuilder.RowGroup rowGroup, GfJsonObject fromJsonObject) {
        String footer = this.getFooter(fromJsonObject);
        if (footer != null && !footer.isEmpty()) {
            rowGroup.newRow().newLeftCol(footer);
        }
    }

    private void buildInfoErrorData(TableBuilder.RowGroup rowGroup, GfJsonObject content) throws GfJsonException {
        GfJsonArray accumulatedData = content.getJSONArray("message");
        if (accumulatedData != null) {
            this.buildRows(rowGroup, null, accumulatedData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildComposite() {
        try {
            GfJsonObject content = this.getContent();
            if (content != null) {
                TableBuilder.Table resultTable = TableBuilder.newTable();
                resultTable.setColumnSeparator(" : ");
                this.addHeaderInTable(resultTable, this.getGfJsonObject());
                Iterator<String> it = content.keys();
                while (it.hasNext()) {
                    String key = it.next();
                    if (key.startsWith("__sections__")) {
                        GfJsonObject subSection = content.getJSONObject(key);
                        this.buildSection(resultTable, null, subSection, 0);
                        continue;
                    }
                    if (!key.equals("__separator__")) continue;
                    String separatorString = content.getString(key);
                    resultTable.newRowGroup().newRowSeparator(Character.valueOf(separatorString.charAt(0)), true);
                }
                this.addFooterInTable(resultTable, this.getGfJsonObject());
                this.resultLines.addAll(resultTable.buildTableList());
            }
        }
        catch (GfJsonException e) {
            this.resultLines.add("Error occurred while processing Command Result. Internal Error - Invalid Result.");
            logger.info("Error occurred while processing Command Result. Internal Error - Invalid Result.", (Throwable)e);
        }
        finally {
            this.isDataBuilt = true;
        }
    }

    private void buildSection(TableBuilder.Table table, TableBuilder.RowGroup parentRowGroup, GfJsonObject section, int depth) throws GfJsonException {
        Iterator<String> keys = section.keys();
        TableBuilder.RowGroup rowGroup = parentRowGroup != null ? parentRowGroup : table.newRowGroup();
        this.addHeaderInRowGroup(rowGroup, section);
        while (keys.hasNext()) {
            String key = keys.next();
            JsonNode object = section.get(key);
            if (key.startsWith("__tables__")) {
                GfJsonObject tableObject = section.getJSONObject(key);
                this.addHeaderInTable(table, tableObject);
                TableBuilder.RowGroup rowGroupForTable = table.newRowGroup();
                this.buildTable(rowGroupForTable, tableObject.getJSONObject("content"));
                this.addFooterInTable(table, tableObject);
                continue;
            }
            if (key.equals("__separator__")) {
                String separatorString = section.getString(key);
                rowGroup.newRowSeparator(Character.valueOf(separatorString.charAt(0)), true);
                continue;
            }
            if (key.equals("header") || key.equals("footer")) continue;
            TableBuilder.Row newRow = rowGroup.newRow();
            String prefix = "";
            for (int i = 0; i < depth; ++i) {
                prefix = prefix + " . ";
            }
            String[] value = LegacyCommandResult.getValuesSeparatedByLines(object);
            if (value.length == 1) {
                newRow.newLeftCol(prefix + key).newLeftCol(value[0]);
                continue;
            }
            if (value.length != 0) {
                newRow.newLeftCol(prefix + key).newLeftCol(value[0]);
                for (int i = 1; i < value.length; ++i) {
                    newRow = rowGroup.newRow();
                    newRow.setColumnSeparator("   ");
                    newRow.newLeftCol("").newLeftCol(value[i]);
                }
                continue;
            }
            newRow.newLeftCol(prefix + key).newLeftCol("");
        }
        this.addFooterInRowGroup(rowGroup, section);
    }

    private static String[] getValuesSeparatedByLines(Object object) {
        String valueString = "" + object;
        return valueString.split(GfshParser.LINE_SEPARATOR);
    }

    private void buildTable(TableBuilder.RowGroup rowGroup, GfJsonObject content) throws GfJsonException {
        GfJsonArray columnNames = content.names();
        int numOfColumns = columnNames.size();
        TableBuilder.Row headerRow = rowGroup.newRow();
        rowGroup.setColumnSeparator(" | ");
        rowGroup.newRowSeparator(Character.valueOf('-'), false);
        for (int i = 0; i < numOfColumns; ++i) {
            String object = columnNames.getString(i);
            if ("__bytes__".equals(object)) continue;
            headerRow.newCenterCol(object);
        }
        TableBuilder.Row[] dataRows = null;
        for (int i = 0; i < numOfColumns; ++i) {
            String object = columnNames.getString(i);
            if ("__bytes__".equals(object)) continue;
            GfJsonArray accumulatedData = content.getJSONArray(object);
            dataRows = this.buildRows(rowGroup, dataRows, accumulatedData);
        }
    }

    private TableBuilder.Row[] buildRows(TableBuilder.RowGroup rowGroup, TableBuilder.Row[] dataRows, GfJsonArray accumulatedData) throws GfJsonException {
        int j;
        int size = accumulatedData.size();
        if (dataRows == null) {
            dataRows = new TableBuilder.Row[size];
            for (j = 0; j < dataRows.length; ++j) {
                dataRows[j] = rowGroup.newRow();
            }
        }
        for (j = 0; j < size; ++j) {
            dataRows[j].newLeftCol(accumulatedData.getString(j));
        }
        return dataRows;
    }

    @Override
    public boolean hasIncomingFiles() {
        GfJsonArray fileDataArray = null;
        try {
            GfJsonObject content = this.getContent();
            if (content != null) {
                fileDataArray = content.getJSONArray("__bytes__");
            }
        }
        catch (GfJsonException e) {
            e.printStackTrace();
        }
        return fileDataArray != null;
    }

    @Override
    public int getNumTimesSaved() {
        return this.numTimesSaved;
    }

    @Override
    public void saveIncomingFiles(String directory) throws IOException {
        try {
            GfJsonObject content = this.getContent();
            if (content == null) {
                throw new RuntimeException("No associated files to save .. ");
            }
            GfJsonArray bytesArray = content.getJSONArray("__bytes__");
            AbstractResultData.readFileDataAndDump(bytesArray, directory);
            ++this.numTimesSaved;
        }
        catch (DataFormatException | GfJsonException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNextLine() {
        if (!this.isDataBuilt) {
            this.buildData();
        }
        return this.index < this.resultLines.size();
    }

    @Override
    public String nextLine() {
        if (!this.isDataBuilt) {
            this.buildData();
        }
        return this.resultLines.get(this.index++);
    }

    @Override
    public String toJson() {
        return this.gfJsonObject.toString();
    }

    @Override
    public String getType() {
        return this.resultData.getType();
    }

    @Override
    public String getHeader() {
        return this.getHeader(this.gfJsonObject);
    }

    @Override
    public String getHeader(GfJsonObject gfJsonObject) {
        return gfJsonObject.getString("header");
    }

    @Override
    public GfJsonObject getContent() {
        return this.gfJsonObject.getJSONObject("content");
    }

    @Override
    public String getMessageFromContent() {
        List<String> messages;
        try {
            GfJsonArray jsonArray = this.getContent().getJSONArray("message");
            if (jsonArray == null) {
                return "";
            }
            messages = this.toList(jsonArray.getInternalJsonArray());
        }
        catch (GfJsonException jex) {
            return "";
        }
        return messages.stream().collect(Collectors.joining(". "));
    }

    @Override
    public String getValueFromContent(String key) {
        return this.getContent().get(key).toString();
    }

    @Override
    public List<String> getListFromContent(String key) {
        return this.getContent().getArrayValues(key);
    }

    @Override
    public List<String> getColumnFromTableContent(String column, String sectionId, String tableId) {
        return this.toList((ArrayNode)this.getTableContent(sectionId, tableId).get(column));
    }

    @Override
    public Map<String, List<String>> getMapFromTableContent(String sectionId, String tableId) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        JsonNode table = this.getTableContent(sectionId, tableId).getInternalJsonObject();
        Iterator fieldNames = table.fieldNames();
        while (fieldNames.hasNext()) {
            String column = (String)fieldNames.next();
            result.put(column, this.toList((ArrayNode)table.get(column)));
        }
        return result;
    }

    @Override
    public Map<String, String> getMapFromSection(String sectionID) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        GfJsonObject obj = this.getContent().getJSONObject("__sections__-" + sectionID);
        Iterator<String> iter = obj.keys();
        while (iter.hasNext()) {
            String key = iter.next();
            result.put(key, obj.getString(key));
        }
        return result;
    }

    private GfJsonObject getTableContent(String sectionId, String tableId) {
        GfJsonObject topLevelContent;
        GfJsonObject sectionObject = topLevelContent = this.getContent();
        if ((sectionObject = sectionObject.getJSONObject("__sections__-" + sectionId)) == null) {
            return topLevelContent;
        }
        GfJsonObject tableContent = sectionObject.getJSONObject("__tables__-" + tableId);
        if (tableContent == null) {
            return topLevelContent;
        }
        return tableContent.getJSONObject("content");
    }

    @Override
    public String getFooter() {
        return this.getFooter(this.gfJsonObject);
    }

    private String getFooter(GfJsonObject gfJsonObject) {
        return gfJsonObject.getString("footer");
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LegacyCommandResult)) {
            return false;
        }
        LegacyCommandResult other = (LegacyCommandResult)obj;
        return this.gfJsonObject.toString().equals(other.gfJsonObject.toString());
    }

    @Override
    public int hashCode() {
        return this.gfJsonObject.hashCode();
    }

    @Override
    public String toString() {
        return "CommandResult [gfJsonObject=" + this.gfJsonObject + ", status=" + (Object)((Object)this.status) + ", index=" + this.index + ", isDataBuilt=" + this.isDataBuilt + ", resultData=" + this.resultData + ", resultLines=" + this.resultLines + ", failedToPersist=" + this.failedToPersist + "]";
    }

    @Override
    public boolean failedToPersist() {
        return this.failedToPersist;
    }

    @Override
    public void setCommandPersisted(boolean commandPersisted) {
        this.failedToPersist = !commandPersisted;
    }

    @Override
    public void setFileToDownload(Path fileToDownload) {
        this.fileToDownload = fileToDownload;
    }

    @Override
    public List<String> getTableColumnValues(String columnName) {
        return this.getTableContent("0", "0").getArrayValues(columnName);
    }

    private List<String> toList(ArrayNode array) {
        Object[] values = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            values[i] = array.get(i).textValue();
        }
        return Arrays.stream(values).map(Object::toString).collect(Collectors.toList());
    }
}

