/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.util.Iterator;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.AbstractResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultDataException;
import org.apache.geode.management.internal.cli.result.TabularResultData;

public class CompositeResultData
extends AbstractResultData {
    public static final String SEPARATOR = "__separator__";
    private int subsectionCount;

    CompositeResultData() {
    }

    CompositeResultData(GfJsonObject gfJsonObject) {
        super(gfJsonObject);
    }

    @Override
    public String getType() {
        return "composite";
    }

    @Override
    public CompositeResultData setHeader(String headerText) {
        return (CompositeResultData)super.setHeader(headerText);
    }

    @Override
    public CompositeResultData setFooter(String footerText) {
        return (CompositeResultData)super.setFooter(footerText);
    }

    public SectionResultData addSection() {
        return this.addSection(String.valueOf(this.subsectionCount));
    }

    public SectionResultData addSection(String keyToAccess) {
        GfJsonObject sectionData = new GfJsonObject();
        try {
            this.contentObject.putAsJSONObject(SectionResultData.generateSectionKey(keyToAccess), sectionData);
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        ++this.subsectionCount;
        return new SectionResultData(sectionData);
    }

    public SectionResultData addSection(SectionResultData otherSection) {
        String keyToAccess = String.valueOf(this.subsectionCount);
        GfJsonObject sectionData = otherSection.getSectionGfJsonObject();
        try {
            this.contentObject.putAsJSONObject(SectionResultData.generateSectionKey(keyToAccess), sectionData);
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        ++this.subsectionCount;
        return new SectionResultData(sectionData);
    }

    public SectionResultData retrieveSectionByIndex(int index) {
        SectionResultData sectionToRetrieve = null;
        int i = 0;
        Iterator<String> iterator = this.contentObject.keys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!key.startsWith("__sections__")) continue;
            if (i == index) {
                sectionToRetrieve = new SectionResultData(this.contentObject.getJSONObject(key));
                break;
            }
            ++i;
        }
        return sectionToRetrieve;
    }

    public SectionResultData retrieveSection(String keyToRetrieve) {
        SectionResultData sectionToRetrieve = null;
        if (this.contentObject.has(SectionResultData.generateSectionKey(keyToRetrieve))) {
            GfJsonObject sectionData = this.contentObject.getJSONObject(SectionResultData.generateSectionKey(keyToRetrieve));
            sectionToRetrieve = new SectionResultData(sectionData);
        }
        return sectionToRetrieve;
    }

    public static class SectionResultData {
        protected GfJsonObject sectionGfJsonObject;
        private int tablesCount = 0;

        SectionResultData() {
            this.sectionGfJsonObject = new GfJsonObject();
        }

        public SectionResultData(GfJsonObject gfJsonObject) {
            this.sectionGfJsonObject = gfJsonObject;
        }

        public GfJsonObject getSectionGfJsonObject() {
            return this.sectionGfJsonObject;
        }

        public String getHeader() {
            return this.sectionGfJsonObject.getString("header");
        }

        public String getFooter() {
            return this.sectionGfJsonObject.getString("footer");
        }

        public SectionResultData setHeader(String headerText) {
            try {
                this.sectionGfJsonObject.put("header", headerText);
            }
            catch (GfJsonException e) {
                throw new ResultDataException(e.getMessage());
            }
            return this;
        }

        public SectionResultData setFooter(String footerText) {
            try {
                this.sectionGfJsonObject.put("footer", footerText);
            }
            catch (GfJsonException e) {
                throw new ResultDataException(e.getMessage());
            }
            return this;
        }

        public SectionResultData addSeparator(char buildSeparatorFrom) {
            try {
                this.sectionGfJsonObject.put(CompositeResultData.SEPARATOR, Character.valueOf(buildSeparatorFrom));
            }
            catch (GfJsonException e) {
                throw new ResultDataException(e.getMessage());
            }
            return this;
        }

        public SectionResultData addData(String name, Object value) {
            try {
                this.sectionGfJsonObject.put(name, value);
            }
            catch (GfJsonException e) {
                throw new ResultDataException(e.getMessage());
            }
            return this;
        }

        public TabularResultData addTable() {
            return this.addTable(String.valueOf(this.tablesCount));
        }

        public TabularResultData addTable(String keyToAccess) {
            TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
            GfJsonObject tableData = tabularResultData.getGfJsonObject();
            try {
                this.sectionGfJsonObject.putAsJSONObject(SectionResultData.generateTableKey(keyToAccess), tableData);
            }
            catch (GfJsonException e) {
                throw new ResultDataException(e.getMessage());
            }
            ++this.tablesCount;
            return tabularResultData;
        }

        public TabularResultData retrieveTableByIndex(int index) {
            TabularResultData tabularResultData = null;
            int i = 0;
            Iterator<String> iterator = this.sectionGfJsonObject.keys();
            while (iterator.hasNext()) {
                String key = iterator.next();
                if (!key.startsWith("__tables__")) continue;
                if (i == index) {
                    tabularResultData = new TabularResultData(this.sectionGfJsonObject.getJSONObject(key));
                    break;
                }
                ++i;
            }
            return tabularResultData;
        }

        public TabularResultData retrieveTable(String keyToRetrieve) {
            TabularResultData tabularResultData = null;
            if (this.sectionGfJsonObject.has(SectionResultData.generateTableKey(keyToRetrieve))) {
                GfJsonObject tableData = this.sectionGfJsonObject.getJSONObject(SectionResultData.generateTableKey(keyToRetrieve));
                tabularResultData = new TabularResultData(tableData);
            }
            return tabularResultData;
        }

        public static String generateSectionKey(String keyToRetrieve) {
            return "__sections__-" + keyToRetrieve;
        }

        public static String generateTableKey(String keyToRetrieve) {
            return "__tables__-" + keyToRetrieve;
        }
    }
}

