/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.geode.management.internal.cli.json.AbstractJSONFormatter;
import org.apache.geode.management.internal.cli.json.GfJsonArray;
import org.apache.geode.management.internal.cli.json.GfJsonException;

public class GfJsonObject
extends AbstractJSONFormatter {
    public static final Object NULL = new Object(){

        public boolean equals(Object o) {
            if (Objects.isNull(o)) {
                return true;
            }
            return o == this;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "null";
        }
    };
    private ObjectNode rootNode;

    public GfJsonObject() {
        super(-1, -1, false);
        this.rootNode = this.mapper.createObjectNode();
    }

    public GfJsonObject(Map<?, ?> map) {
        super(-1, -1, false);
        this.rootNode = (ObjectNode)this.mapper.valueToTree(map);
    }

    public GfJsonObject(Object bean) {
        super(-1, -1, false);
        this.rootNode = bean instanceof ObjectNode ? (ObjectNode)bean : (ObjectNode)this.mapper.valueToTree(bean);
    }

    public GfJsonObject(String source) throws GfJsonException {
        super(-1, -1, false);
        try {
            this.rootNode = (ObjectNode)this.mapper.readTree(source);
        }
        catch (IOException e) {
            throw new GfJsonException(e.getMessage());
        }
        if (this.rootNode == null) {
            throw new GfJsonException("Unable to parse JSON document");
        }
    }

    @Override
    void postCreateMapper() {
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    public GfJsonObject accumulate(String key, Object value) throws GfJsonException {
        try {
            if (this.rootNode.has(key)) {
                this.append(key, value);
            } else {
                ArrayNode array = this.mapper.createArrayNode();
                array.add(this.mapper.valueToTree(value));
                this.rootNode.set(key, (JsonNode)array);
            }
        }
        catch (RuntimeException e) {
            throw new GfJsonException(e);
        }
        return this;
    }

    public GfJsonObject append(String key, Object value) throws GfJsonException {
        block4: {
            try {
                JsonNode current = this.rootNode.get(key);
                if (current instanceof ArrayNode) {
                    ArrayNode array = (ArrayNode)current;
                    array.add(this.mapper.valueToTree(value));
                    break block4;
                }
                if (current == null) {
                    ArrayNode array = this.mapper.createArrayNode();
                    array.add(this.mapper.valueToTree(value));
                    this.rootNode.set(key, (JsonNode)array);
                    break block4;
                }
                throw new GfJsonException("Cannot append to a non-array field");
            }
            catch (RuntimeException e) {
                throw new GfJsonException(e);
            }
        }
        return this;
    }

    public JsonNode get(String key) {
        return this.rootNode.get(key);
    }

    public String getString(String key) {
        JsonNode node = this.rootNode.get(key);
        if (node == null) {
            return null;
        }
        if (node.textValue() != null) {
            return node.textValue();
        }
        return node.toString();
    }

    public int getInt(String key) {
        return this.rootNode.get(key).asInt();
    }

    public long getLong(String key) {
        return this.rootNode.get(key).asLong();
    }

    public double getDouble(String key) {
        return this.rootNode.get(key).asDouble();
    }

    public boolean getBoolean(String key) {
        return this.rootNode.get(key).asBoolean();
    }

    public GfJsonObject getJSONObject(String key) {
        JsonNode value = this.rootNode.get(key);
        if (value == null) {
            return null;
        }
        return new GfJsonObject(value);
    }

    public JsonNode getInternalJsonObject() {
        return this.rootNode;
    }

    public GfJsonArray getJSONArray(String key) throws GfJsonException {
        JsonNode node = this.rootNode.get(key);
        if (node == null) {
            return null;
        }
        if (!(node instanceof ArrayNode)) {
            ArrayNode newNode = this.mapper.createArrayNode();
            for (int i = 0; i < node.size(); ++i) {
                newNode.add(node.get("" + i));
            }
            this.rootNode.set(key, (JsonNode)newNode);
            return new GfJsonArray(newNode);
        }
        return new GfJsonArray(node);
    }

    public GfJsonArray names() throws GfJsonException {
        int size = this.rootNode.size();
        if (size == 0) {
            return new GfJsonArray();
        }
        String[] fieldNames = new String[this.rootNode.size()];
        Iterator fieldNameIter = this.rootNode.fieldNames();
        int i = 0;
        while (fieldNameIter.hasNext()) {
            fieldNames[i++] = (String)fieldNameIter.next();
        }
        return new GfJsonArray(fieldNames);
    }

    public GfJsonObject put(String key, Object value) throws GfJsonException {
        try {
            this.rootNode.set(key, this.toJsonNode(value));
        }
        catch (IllegalArgumentException e) {
            throw new GfJsonException(e);
        }
        return this;
    }

    public GfJsonObject putAsJSONObject(String key, Object value) throws GfJsonException {
        try {
            JsonNode internalJsonObj = this.toJsonNode(value);
            this.rootNode.set(key, internalJsonObj);
        }
        catch (IllegalArgumentException e) {
            throw new GfJsonException(e);
        }
        return this;
    }

    public GfJsonObject putOpt(String key, Object value) throws GfJsonException {
        if (key == null || value == null) {
            return this;
        }
        try {
            this.rootNode.set(key, this.toJsonNode(value));
        }
        catch (IllegalArgumentException e) {
            throw new GfJsonException(e);
        }
        return this;
    }

    public boolean has(String key) {
        return this.rootNode.has(key);
    }

    public Iterator<String> keys() {
        return this.rootNode.fieldNames();
    }

    public int size() {
        return this.rootNode.size();
    }

    public String toString() {
        return this.rootNode.toString();
    }

    public String toIndentedString() throws GfJsonException {
        try {
            return this.rootNode.toString();
        }
        catch (Exception e) {
            throw new GfJsonException(e);
        }
    }

    public List<String> getArrayValues(String key) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.rootNode.has(key)) {
            JsonNode node = this.rootNode.get(key);
            if (!(node instanceof ArrayNode)) {
                throw new IllegalStateException("requested field is not an array: " + key);
            }
            ArrayNode array = (ArrayNode)node;
            for (int i = 0; i < array.size(); ++i) {
                JsonNode valueNode = array.get(i);
                result.add(valueNode.textValue() == null ? valueNode.toString() : valueNode.asText());
            }
        }
        return result;
    }

    private JsonNode toJsonNode(Object value) {
        if (value instanceof JsonNode) {
            return (JsonNode)value;
        }
        if (value instanceof GfJsonObject) {
            return ((GfJsonObject)value).getInternalJsonObject();
        }
        if (value instanceof GfJsonArray) {
            return ((GfJsonArray)value).getInternalJsonArray();
        }
        if (value == null) {
            return this.mapper.valueToTree(NULL);
        }
        return this.mapper.valueToTree(value);
    }

    public static GfJsonObject getGfJsonErrorObject(String errorMessage) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put("error", errorMessage);
        return new GfJsonObject(errorMap);
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }
}

