/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.json.AbstractJSONFormatter;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.logging.log4j.Logger;

public class GfJsonArray
extends AbstractJSONFormatter {
    private static final Logger logger = LogService.getLogger();
    private final ArrayNode jsonArray;

    public GfJsonArray() {
        super(-1, -1, false);
        this.jsonArray = this.mapper.createArrayNode();
    }

    public GfJsonArray(Object array) throws GfJsonException {
        super(-1, -1, false);
        try {
            this.jsonArray = array instanceof ArrayNode ? (ArrayNode)array : (ArrayNode)this.mapper.valueToTree(array);
            if (this.jsonArray == null) {
                throw new IllegalArgumentException("Array translated into null JSON node: " + array);
            }
        }
        catch (IllegalArgumentException e) {
            throw new GfJsonException(e);
        }
    }

    @Override
    void postCreateMapper() {
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    public String getString(int index) throws GfJsonException {
        try {
            JsonNode node = this.jsonArray.get(index);
            if (node.textValue() != null) {
                return node.asText();
            }
            return node.toString();
        }
        catch (IllegalArgumentException e) {
            throw new GfJsonException(e);
        }
    }

    public GfJsonObject getJsonObject(int index) throws GfJsonException {
        try {
            return new GfJsonObject(this.jsonArray.get(index));
        }
        catch (IllegalArgumentException e) {
            throw new GfJsonException(e);
        }
    }

    public GfJsonArray put(Object value) {
        this.jsonArray.add(this.toJsonNode(value));
        return this;
    }

    public int length() {
        return this.jsonArray.size();
    }

    public GfJsonArray put(int index, Object value) throws GfJsonException {
        JsonNode json = null;
        try {
            json = this.toJsonNode(value);
            this.jsonArray.set(index, json);
        }
        catch (IndexOutOfBoundsException e) {
            while (this.jsonArray.size() < index) {
                this.jsonArray.add((JsonNode)null);
            }
            this.jsonArray.add(json);
        }
        catch (IllegalArgumentException e) {
            throw new GfJsonException(e);
        }
        return this;
    }

    public GfJsonArray put(int index, Map<?, ?> value) throws GfJsonException {
        try {
            this.jsonArray.set(index, this.toJsonNode(value));
        }
        catch (IllegalArgumentException e) {
            throw new GfJsonException(e);
        }
        return this;
    }

    public int size() {
        return this.jsonArray.size();
    }

    public String toString() {
        return this.jsonArray.toString();
    }

    public static byte[] toByteArray(GfJsonArray jsonArray) throws GfJsonException {
        byte[] byteArray = null;
        if (jsonArray != null) {
            int length = jsonArray.size();
            byteArray = new byte[length];
            for (int i = 0; i < length; ++i) {
                try {
                    byteArray[i] = Byte.valueOf(String.valueOf(jsonArray.getString(i)));
                    continue;
                }
                catch (GfJsonException e) {
                    throw new GfJsonException(e.getMessage());
                }
            }
        }
        return byteArray;
    }

    public List<String> toStringList() {
        ArrayList<String> stringArray = null;
        int length = this.jsonArray.size();
        stringArray = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            try {
                stringArray.add(this.getString(i));
                continue;
            }
            catch (GfJsonException e) {
                logger.info("", (Throwable)e);
                stringArray = null;
            }
        }
        return stringArray;
    }

    public ArrayNode getInternalJsonArray() {
        return this.jsonArray;
    }

    private JsonNode toJsonNode(Object value) {
        if (value instanceof GfJsonObject) {
            return ((GfJsonObject)value).getInternalJsonObject();
        }
        if (value instanceof GfJsonArray) {
            return ((GfJsonArray)value).getInternalJsonArray();
        }
        if (value == null) {
            return this.mapper.valueToTree(GfJsonObject.NULL);
        }
        return this.mapper.valueToTree(value);
    }

    public GfJsonArray getJSONArray(int i) throws GfJsonException {
        return new GfJsonArray(this.jsonArray.get(i));
    }
}

