/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.management.internal.cli.domain.ClassName;

public class RegionFunctionArgs
implements Serializable {
    private static final long serialVersionUID = 2204943186081037302L;
    private String regionPath;
    private RegionShortcut regionShortcut;
    private String templateRegion;
    private boolean ifNotExists;
    private String keyConstraint;
    private String valueConstraint;
    private Boolean statisticsEnabled;
    private ExpirationAttrs entryExpirationIdleTime;
    private ExpirationAttrs entryExpirationTTL;
    private ClassName<CustomExpiry> entryIdleTimeCustomExpiry;
    private ClassName<CustomExpiry> entryTTLCustomExpiry;
    private ExpirationAttrs regionExpirationIdleTime;
    private ExpirationAttrs regionExpirationTTL;
    private EvictionAttrs evictionAttributes;
    private String diskStore;
    private Boolean diskSynchronous;
    private Boolean enableAsyncConflation;
    private Boolean enableSubscriptionConflation;
    private Set<ClassName<CacheListener>> cacheListeners = Collections.emptySet();
    private ClassName<CacheLoader> cacheLoader;
    private ClassName<CacheWriter> cacheWriter;
    private Set<String> asyncEventQueueIds = Collections.emptySet();
    private Set<String> gatewaySenderIds = Collections.emptySet();
    private Boolean concurrencyChecksEnabled;
    private Boolean cloningEnabled;
    private Boolean mcastEnabled;
    private Integer concurrencyLevel;
    private PartitionArgs partitionArgs;
    private Integer evictionMax;
    private String compressor;
    private Boolean offHeap;
    private RegionAttributes<?, ?> regionAttributes;

    public void setRegionPath(String regionPath) {
        this.regionPath = regionPath;
    }

    public void setTemplateRegion(String templateRegion) {
        this.templateRegion = templateRegion;
    }

    public void setRegionShortcut(RegionShortcut regionShortcut) {
        this.regionShortcut = regionShortcut;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setKeyConstraint(String keyConstraint) {
        this.keyConstraint = keyConstraint;
    }

    public void setValueConstraint(String valueConstraint) {
        this.valueConstraint = valueConstraint;
    }

    public void setStatisticsEnabled(Boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public void setEntryExpirationIdleTime(Integer timeout, ExpirationAction action) {
        if (timeout == null && action == null) {
            return;
        }
        this.entryExpirationIdleTime = new ExpirationAttrs(timeout, action);
    }

    public void setEntryExpirationTTL(Integer timeout, ExpirationAction action) {
        if (timeout == null && action == null) {
            return;
        }
        this.entryExpirationTTL = new ExpirationAttrs(timeout, action);
    }

    public void setRegionExpirationIdleTime(Integer timeout, ExpirationAction action) {
        if (timeout == null && action == null) {
            return;
        }
        this.regionExpirationIdleTime = new ExpirationAttrs(timeout, action);
    }

    public void setRegionExpirationTTL(Integer timeout, ExpirationAction action) {
        if (timeout == null && action == null) {
            return;
        }
        this.regionExpirationTTL = new ExpirationAttrs(timeout, action);
    }

    public void setEvictionAttributes(String action, Integer maxMemory, Integer maxEntryCount, String objectSizer) {
        if (action == null) {
            return;
        }
        this.evictionAttributes = new EvictionAttrs(action, maxEntryCount, maxMemory, objectSizer);
    }

    public void setDiskStore(String diskStore) {
        this.diskStore = diskStore;
    }

    public void setDiskSynchronous(Boolean diskSynchronous) {
        this.diskSynchronous = diskSynchronous;
    }

    public void setEnableAsyncConflation(Boolean enableAsyncConflation) {
        this.enableAsyncConflation = enableAsyncConflation;
    }

    public void setEnableSubscriptionConflation(Boolean enableSubscriptionConflation) {
        this.enableSubscriptionConflation = enableSubscriptionConflation;
    }

    public void setCacheListeners(ClassName<CacheListener>[] cacheListeners) {
        if (cacheListeners != null) {
            this.cacheListeners = Arrays.stream(cacheListeners).collect(Collectors.toSet());
        }
    }

    public void setCacheLoader(ClassName<CacheLoader> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public void setCacheWriter(ClassName<CacheWriter> cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    public void setAsyncEventQueueIds(String[] asyncEventQueueIds) {
        if (asyncEventQueueIds != null) {
            this.asyncEventQueueIds = Arrays.stream(asyncEventQueueIds).collect(Collectors.toSet());
        }
    }

    public void setGatewaySenderIds(String[] gatewaySenderIds) {
        if (gatewaySenderIds != null) {
            this.gatewaySenderIds = Arrays.stream(gatewaySenderIds).collect(Collectors.toSet());
        }
    }

    public void setConcurrencyChecksEnabled(Boolean concurrencyChecksEnabled) {
        this.concurrencyChecksEnabled = concurrencyChecksEnabled;
    }

    public void setCloningEnabled(Boolean cloningEnabled) {
        this.cloningEnabled = cloningEnabled;
    }

    public void setMcastEnabled(Boolean mcastEnabled) {
        this.mcastEnabled = mcastEnabled;
    }

    public void setConcurrencyLevel(Integer concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
    }

    public void setPartitionArgs(String prColocatedWith, Integer prLocalMaxMemory, Long prRecoveryDelay, Integer prRedundantCopies, Long prStartupRecoveryDelay, Long prTotalMaxMemory, Integer prTotalNumBuckets, String partitionResolver) {
        if (prColocatedWith == null && prLocalMaxMemory == null && prRecoveryDelay == null && prRedundantCopies == null && prStartupRecoveryDelay == null && prTotalMaxMemory == null && prTotalNumBuckets == null && partitionResolver == null) {
            return;
        }
        if (this.partitionArgs == null) {
            this.partitionArgs = new PartitionArgs();
        }
        this.partitionArgs.setPrColocatedWith(prColocatedWith);
        this.partitionArgs.setPrLocalMaxMemory(prLocalMaxMemory);
        this.partitionArgs.setPrRecoveryDelay(prRecoveryDelay);
        this.partitionArgs.setPrRedundantCopies(prRedundantCopies);
        this.partitionArgs.setPrStartupRecoveryDelay(prStartupRecoveryDelay);
        this.partitionArgs.setPrTotalMaxMemory(prTotalMaxMemory);
        this.partitionArgs.setPrTotalNumBuckets(prTotalNumBuckets);
        this.partitionArgs.setPartitionResolver(partitionResolver);
    }

    public void setEvictionMax(Integer evictionMax) {
        this.evictionMax = evictionMax;
    }

    public void setCompressor(String compressor) {
        this.compressor = compressor;
    }

    public void setOffHeap(Boolean offHeap) {
        this.offHeap = offHeap;
    }

    public void setRegionAttributes(RegionAttributes<?, ?> regionAttributes) {
        this.regionAttributes = regionAttributes;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    public RegionShortcut getRegionShortcut() {
        return this.regionShortcut;
    }

    public String getTemplateRegion() {
        return this.templateRegion;
    }

    public Boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public String getKeyConstraint() {
        return this.keyConstraint;
    }

    public String getValueConstraint() {
        return this.valueConstraint;
    }

    public Boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public ExpirationAttrs getEntryExpirationIdleTime() {
        return this.entryExpirationIdleTime;
    }

    public ExpirationAttrs getEntryExpirationTTL() {
        return this.entryExpirationTTL;
    }

    public ExpirationAttrs getRegionExpirationIdleTime() {
        return this.regionExpirationIdleTime;
    }

    public ExpirationAttrs getRegionExpirationTTL() {
        return this.regionExpirationTTL;
    }

    public String getDiskStore() {
        return this.diskStore;
    }

    public Boolean getDiskSynchronous() {
        return this.diskSynchronous;
    }

    public Boolean getOffHeap() {
        return this.offHeap;
    }

    public Boolean getEnableAsyncConflation() {
        return this.enableAsyncConflation;
    }

    public Boolean getEnableSubscriptionConflation() {
        return this.enableSubscriptionConflation;
    }

    public Set<ClassName<CacheListener>> getCacheListeners() {
        if (this.cacheListeners == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.cacheListeners);
    }

    public ClassName<CacheLoader> getCacheLoader() {
        return this.cacheLoader;
    }

    public ClassName<CacheWriter> getCacheWriter() {
        return this.cacheWriter;
    }

    public Set<String> getAsyncEventQueueIds() {
        if (this.asyncEventQueueIds == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.asyncEventQueueIds);
    }

    public Set<String> getGatewaySenderIds() {
        if (this.gatewaySenderIds == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.gatewaySenderIds);
    }

    public Boolean getConcurrencyChecksEnabled() {
        return this.concurrencyChecksEnabled;
    }

    public Boolean getCloningEnabled() {
        return this.cloningEnabled;
    }

    public Boolean getMcastEnabled() {
        return this.mcastEnabled;
    }

    public Integer getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public boolean withPartitioning() {
        return this.hasPartitionAttributes() || this.regionShortcut != null && this.regionShortcut.name().startsWith("PARTITION");
    }

    public boolean hasPartitionAttributes() {
        return this.partitionArgs != null && this.partitionArgs.hasPartitionAttributes() != false;
    }

    public PartitionArgs getPartitionArgs() {
        return this.partitionArgs;
    }

    public Integer getEvictionMax() {
        return this.evictionMax;
    }

    public String getCompressor() {
        return this.compressor;
    }

    public EvictionAttrs getEvictionAttributes() {
        return this.evictionAttributes;
    }

    public <K, V> RegionAttributes<K, V> getRegionAttributes() {
        return this.regionAttributes;
    }

    public ClassName<CustomExpiry> getEntryIdleTimeCustomExpiry() {
        return this.entryIdleTimeCustomExpiry;
    }

    public void setEntryIdleTimeCustomExpiry(ClassName<CustomExpiry> entryIdleTimeCustomExpiry) {
        this.entryIdleTimeCustomExpiry = entryIdleTimeCustomExpiry;
    }

    public ClassName<CustomExpiry> getEntryTTLCustomExpiry() {
        return this.entryTTLCustomExpiry;
    }

    public void setEntryTTLCustomExpiry(ClassName<CustomExpiry> entryTTLCustomExpiry) {
        this.entryTTLCustomExpiry = entryTTLCustomExpiry;
    }

    public static class PartitionArgs
    implements Serializable {
        private static final long serialVersionUID = 5907052187323280919L;
        private String prColocatedWith;
        private Integer prLocalMaxMemory;
        private Long prRecoveryDelay;
        private Integer prRedundantCopies;
        private Long prStartupRecoveryDelay;
        private Long prTotalMaxMemory;
        private Integer prTotalNumBuckets;
        private String partitionResolver;

        public Boolean hasPartitionAttributes() {
            return !this.getUserSpecifiedPartitionAttributes().isEmpty();
        }

        public Set<String> getUserSpecifiedPartitionAttributes() {
            HashSet<String> userSpecifiedPartitionAttributes = new HashSet<String>();
            if (this.prColocatedWith != null) {
                userSpecifiedPartitionAttributes.add("colocated-with");
            }
            if (this.prLocalMaxMemory != null) {
                userSpecifiedPartitionAttributes.add("local-max-memory");
            }
            if (this.prRecoveryDelay != null) {
                userSpecifiedPartitionAttributes.add("recovery-delay");
            }
            if (this.prRedundantCopies != null) {
                userSpecifiedPartitionAttributes.add("redundant-copies");
            }
            if (this.prStartupRecoveryDelay != null) {
                userSpecifiedPartitionAttributes.add("startup-recovery-delay");
            }
            if (this.prTotalMaxMemory != null) {
                userSpecifiedPartitionAttributes.add("total-max-memory");
            }
            if (this.prTotalNumBuckets != null) {
                userSpecifiedPartitionAttributes.add("total-num-buckets");
            }
            if (this.partitionResolver != null) {
                userSpecifiedPartitionAttributes.add("partition-resolver");
            }
            return userSpecifiedPartitionAttributes;
        }

        public void setPrColocatedWith(String prColocatedWith) {
            if (prColocatedWith != null) {
                this.prColocatedWith = prColocatedWith;
            }
        }

        public void setPrLocalMaxMemory(Integer prLocalMaxMemory) {
            if (prLocalMaxMemory != null) {
                this.prLocalMaxMemory = prLocalMaxMemory;
            }
        }

        public void setPrRecoveryDelay(Long prRecoveryDelay) {
            if (prRecoveryDelay != null) {
                this.prRecoveryDelay = prRecoveryDelay;
            }
        }

        public void setPrRedundantCopies(Integer prRedundantCopies) {
            if (prRedundantCopies != null) {
                this.prRedundantCopies = prRedundantCopies;
            }
        }

        public void setPrStartupRecoveryDelay(Long prStartupRecoveryDelay) {
            if (prStartupRecoveryDelay != null) {
                this.prStartupRecoveryDelay = prStartupRecoveryDelay;
            }
        }

        public void setPrTotalMaxMemory(Long prTotalMaxMemory) {
            if (prTotalMaxMemory != null) {
                this.prTotalMaxMemory = prTotalMaxMemory;
            }
        }

        public void setPrTotalNumBuckets(Integer prTotalNumBuckets) {
            if (prTotalNumBuckets != null) {
                this.prTotalNumBuckets = prTotalNumBuckets;
            }
        }

        public void setPartitionResolver(String partitionResolver) {
            if (partitionResolver != null) {
                this.partitionResolver = partitionResolver;
            }
        }

        public String getPrColocatedWith() {
            return this.prColocatedWith;
        }

        public Integer getPrLocalMaxMemory() {
            return this.prLocalMaxMemory;
        }

        public Long getPrRecoveryDelay() {
            return this.prRecoveryDelay;
        }

        public Integer getPrRedundantCopies() {
            return this.prRedundantCopies;
        }

        public Long getPrStartupRecoveryDelay() {
            return this.prStartupRecoveryDelay;
        }

        public Long getPrTotalMaxMemory() {
            return this.prTotalMaxMemory;
        }

        public Integer getPrTotalNumBuckets() {
            return this.prTotalNumBuckets;
        }

        public String getPartitionResolver() {
            return this.partitionResolver;
        }
    }

    public static class EvictionAttrs
    implements Serializable {
        private static final long serialVersionUID = 9015454906371076014L;
        private String evictionAction;
        private Integer maxEntryCount;
        private Integer maxMemory;
        private String objectSizer;

        public EvictionAttrs(String evictionAction, Integer maxEntryCount, Integer maxMemory, String objectSizer) {
            this.evictionAction = evictionAction;
            this.maxEntryCount = maxEntryCount;
            this.maxMemory = maxMemory;
            this.objectSizer = objectSizer;
        }

        public String getEvictionAction() {
            return this.evictionAction;
        }

        public Integer getMaxEntryCount() {
            return this.maxEntryCount;
        }

        public Integer getMaxMemory() {
            return this.maxMemory;
        }

        public String getObjectSizer() {
            return this.objectSizer;
        }

        public EvictionAttributes convertToEvictionAttributes() {
            ObjectSizer sizer;
            EvictionAction action = EvictionAction.parseAction(this.evictionAction);
            if (this.objectSizer != null) {
                try {
                    Class<?> sizerClass = ClassPathLoader.getLatest().forName(this.objectSizer);
                    sizer = (ObjectSizer)sizerClass.newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException("Unable to instantiate class " + this.objectSizer + " - " + e.toString());
                }
            } else {
                sizer = ObjectSizer.DEFAULT;
            }
            if (this.maxMemory == null && this.maxEntryCount == null) {
                return EvictionAttributes.createLRUHeapAttributes(sizer, action);
            }
            if (this.maxMemory != null) {
                return EvictionAttributes.createLRUMemoryAttributes(this.maxMemory, sizer, action);
            }
            return EvictionAttributes.createLRUEntryAttributes(this.maxEntryCount, action);
        }
    }

    public static class ExpirationAttrs
    implements Serializable {
        private static final long serialVersionUID = 1474255033398008063L;
        private final Integer time;
        private final ExpirationAction action;

        public ExpirationAttrs(Integer time, ExpirationAction action) {
            this.time = time;
            this.action = action;
        }

        public Integer getTime() {
            return this.time;
        }

        public ExpirationAction getAction() {
            return this.action;
        }

        public int hashCode() {
            return Objects.hash(this.time, this.action);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof ExpirationAttrs)) {
                return false;
            }
            ExpirationAttrs that = (ExpirationAttrs)object;
            if (this.time == null && that.time == null && this.action == that.action) {
                return true;
            }
            return this.time != null && this.time.equals(that.time) && this.action == that.action;
        }

        public boolean isTimeSet() {
            return this.time != null;
        }

        public boolean isTimeOrActionSet() {
            return this.time != null || this.action != null;
        }

        public ExpirationAttributes getExpirationAttributes() {
            return this.getExpirationAttributes(null);
        }

        public ExpirationAttributes getExpirationAttributes(ExpirationAttributes existing) {
            int timeToUse = 0;
            ExpirationAction actionToUse = ExpirationAction.INVALIDATE;
            if (existing != null) {
                timeToUse = existing.getTimeout();
                actionToUse = existing.getAction();
            }
            if (this.time != null) {
                timeToUse = this.time;
            }
            if (this.action != null) {
                actionToUse = this.action;
            }
            return new ExpirationAttributes(timeToUse, actionToUse);
        }
    }
}

