/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

public class RegionDestroyFunction
implements InternalFunction {
    private static final long serialVersionUID = 9172773671865750685L;
    @Immutable
    public static final RegionDestroyFunction INSTANCE = new RegionDestroyFunction();
    private static final String ID = RegionDestroyFunction.class.getName();

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public void execute(FunctionContext context) {
        String regionPath = null;
        String memberName = context.getMemberName();
        try {
            String functionId = context.getFunctionId();
            Object arguments = context.getArguments();
            if (!this.getId().equals(functionId) || arguments == null) {
                context.getResultSender().lastResult(new CliFunctionResult("", false, "Function Id mismatch or arguments is not available."));
                return;
            }
            regionPath = (String)arguments;
            InternalCacheForClientAccess cache = ((InternalCache)context.getCache()).getCacheForProcessingClientRequests();
            Region region = cache.getRegion(regionPath);
            if (region == null) {
                context.getResultSender().lastResult(new CliFunctionResult(memberName, true, String.format("Region '%s' already destroyed", regionPath)));
                return;
            }
            region.destroyRegion();
            String regionName = regionPath.startsWith("/") ? regionPath.substring(1) : regionPath;
            XmlEntity xmlEntity = new XmlEntity("region", "name", regionName);
            context.getResultSender().lastResult(new CliFunctionResult(memberName, xmlEntity, String.format("Region '%s' destroyed successfully", regionPath)));
        }
        catch (IllegalStateException ex) {
            context.getResultSender().lastResult(new CliFunctionResult(memberName, false, ex.getMessage()));
        }
        catch (RegionDestroyedException ex) {
            context.getResultSender().lastResult(new CliFunctionResult(memberName, true, String.format("Region '%s' already destroyed", regionPath)));
        }
        catch (Exception ex) {
            LogService.getLogger().error(ex.getMessage(), (Throwable)ex);
            context.getResultSender().lastResult(new CliFunctionResult(memberName, ex, ex.getMessage()));
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

