/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class ListFunctionFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();
    public static final String ID = ListFunctionFunction.class.getName();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            CliFunctionResult result;
            Object[] args = (Object[])context.getArguments();
            String stringPattern = (String)args[0];
            Cache cache = context.getCache();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            Map<String, Function> functions = FunctionService.getRegisteredFunctions();
            if (stringPattern == null || stringPattern.isEmpty()) {
                result = new CliFunctionResult(memberId, new HashSet<String>(functions.keySet()), null);
            } else {
                Pattern pattern = Pattern.compile(stringPattern);
                HashSet<String> resultSet = new HashSet<String>();
                for (String functionId : functions.keySet()) {
                    Matcher matcher = pattern.matcher(functionId);
                    if (!matcher.matches()) continue;
                    resultSet.add(functionId);
                }
                result = new CliFunctionResult(memberId, resultSet, null);
            }
            context.getResultSender().lastResult(result);
        }
        catch (Exception cce) {
            logger.error(cce.getMessage(), (Throwable)cce);
            CliFunctionResult result = new CliFunctionResult(memberId, false, cce.getMessage());
            context.getResultSender().lastResult(result);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

