/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.File;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.snapshot.RegionSnapshotService;
import org.apache.geode.cache.snapshot.SnapshotOptions;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;

public class ImportDataFunction
implements InternalFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        CliFunctionResult result;
        Object[] args = (Object[])context.getArguments();
        if (args.length < 4) {
            throw new IllegalStateException("Arguments length does not match required length. Import command may have been sent from incompatible older version");
        }
        String regionName = (String)args[0];
        String importFileName = (String)args[1];
        boolean invokeCallbacks = (Boolean)args[2];
        boolean parallel = (Boolean)args[3];
        try {
            InternalCacheForClientAccess cache = ((InternalCache)context.getCache()).getCacheForProcessingClientRequests();
            Region region = cache.getRegion(regionName);
            String hostName = cache.getDistributedSystem().getDistributedMember().getHost();
            if (region != null) {
                RegionSnapshotService snapshotService = region.getSnapshotService();
                SnapshotOptions options = snapshotService.createOptions();
                options.invokeCallbacks(invokeCallbacks);
                options.setParallelMode(parallel);
                File importFile = new File(importFileName);
                snapshotService.load(new File(importFileName), SnapshotOptions.SnapshotFormat.GEMFIRE, options);
                String successMessage = CliStrings.format("Data imported from file : {0} on host : {1} to region : {2}", importFile.getCanonicalPath(), hostName, regionName);
                result = new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.OK, successMessage);
            } else {
                result = new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format("Region : {0} not found", (Object)regionName));
            }
        }
        catch (Exception e) {
            result = new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, e.getMessage());
        }
        context.getResultSender().lastResult(result);
    }

    @Override
    public String getId() {
        return ImportDataFunction.class.getName();
    }
}

