/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.List;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewaySenderFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.GatewaySenderFunctionArgs;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.logging.log4j.Logger;

public class GatewaySenderCreateFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 8746830191680509335L;
    private static final String ID = GatewaySenderCreateFunction.class.getName();
    @Immutable
    public static final GatewaySenderCreateFunction INSTANCE = new GatewaySenderCreateFunction();

    @Override
    public void execute(FunctionContext context) {
        ResultSender resultSender = context.getResultSender();
        Cache cache = context.getCache();
        String memberNameOrId = context.getMemberName();
        GatewaySenderFunctionArgs gatewaySenderCreateArgs = (GatewaySenderFunctionArgs)context.getArguments();
        try {
            GatewaySender createdGatewaySender = this.createGatewaySender(cache, gatewaySenderCreateArgs);
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.OK, CliStrings.format("GatewaySender \"{0}\" created on \"{1}\"", createdGatewaySender.getId(), memberNameOrId)));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, e, null));
        }
    }

    private GatewaySender createGatewaySender(Cache cache, GatewaySenderFunctionArgs gatewaySenderCreateArgs) {
        List<String> gatewayTransportFilters;
        List<String> gatewayEventFilters;
        Boolean isDiskSynchronous;
        String diskStoreName;
        Boolean isPersistenceEnabled;
        Integer dispatcherThreads;
        Integer alertThreshold;
        Integer socketReadTimeout;
        Integer socketBufferSize;
        Boolean enableBatchConflation;
        Integer batchTimeInterval;
        Integer batchSize;
        Integer maxQueueMemory;
        Boolean manualStart;
        GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
        Boolean isParallel = gatewaySenderCreateArgs.isParallel();
        if (isParallel != null) {
            gateway.setParallel(isParallel);
        }
        if ((manualStart = gatewaySenderCreateArgs.isManualStart()) != null) {
            gateway.setManualStart(manualStart);
        }
        if ((maxQueueMemory = gatewaySenderCreateArgs.getMaxQueueMemory()) != null) {
            gateway.setMaximumQueueMemory(maxQueueMemory);
        }
        if ((batchSize = gatewaySenderCreateArgs.getBatchSize()) != null) {
            gateway.setBatchSize(batchSize);
        }
        if ((batchTimeInterval = gatewaySenderCreateArgs.getBatchTimeInterval()) != null) {
            gateway.setBatchTimeInterval(batchTimeInterval);
        }
        if ((enableBatchConflation = gatewaySenderCreateArgs.isBatchConflationEnabled()) != null) {
            gateway.setBatchConflationEnabled(enableBatchConflation);
        }
        if ((socketBufferSize = gatewaySenderCreateArgs.getSocketBufferSize()) != null) {
            gateway.setSocketBufferSize(socketBufferSize);
        }
        if ((socketReadTimeout = gatewaySenderCreateArgs.getSocketReadTimeout()) != null) {
            gateway.setSocketReadTimeout(socketReadTimeout);
        }
        if ((alertThreshold = gatewaySenderCreateArgs.getAlertThreshold()) != null) {
            gateway.setAlertThreshold(alertThreshold);
        }
        if ((dispatcherThreads = gatewaySenderCreateArgs.getDispatcherThreads()) != null && dispatcherThreads > 1) {
            gateway.setDispatcherThreads(dispatcherThreads);
            String orderPolicy = gatewaySenderCreateArgs.getOrderPolicy();
            gateway.setOrderPolicy(GatewaySender.OrderPolicy.valueOf(orderPolicy));
        }
        if ((isPersistenceEnabled = gatewaySenderCreateArgs.isPersistenceEnabled()) != null) {
            gateway.setPersistenceEnabled(isPersistenceEnabled);
        }
        if ((diskStoreName = gatewaySenderCreateArgs.getDiskStoreName()) != null) {
            gateway.setDiskStoreName(diskStoreName);
        }
        if ((isDiskSynchronous = gatewaySenderCreateArgs.isDiskSynchronous()) != null) {
            gateway.setDiskSynchronous(isDiskSynchronous);
        }
        if ((gatewayEventFilters = gatewaySenderCreateArgs.getGatewayEventFilter()) != null) {
            for (String gatewayEventFilter : gatewayEventFilters) {
                Class gatewayEventFilterKlass = CliUtil.forName(gatewayEventFilter, "gateway-event-filter");
                gateway.addGatewayEventFilter((GatewayEventFilter)CliUtil.newInstance(gatewayEventFilterKlass, "gateway-event-filter"));
            }
        }
        if ((gatewayTransportFilters = gatewaySenderCreateArgs.getGatewayTransportFilter()) != null) {
            for (String gatewayTransportFilter : gatewayTransportFilters) {
                Class gatewayTransportFilterKlass = CliUtil.forName(gatewayTransportFilter, "gateway-transport-filter");
                gateway.addGatewayTransportFilter((GatewayTransportFilter)CliUtil.newInstance(gatewayTransportFilterKlass, "gateway-transport-filter"));
            }
        }
        return gateway.create(gatewaySenderCreateArgs.getId(), gatewaySenderCreateArgs.getRemoteDistributedSystemId());
    }

    @Override
    public String getId() {
        return ID;
    }
}

