/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.ClassNameType;

public class GatewayReceiverFunctionArgs
implements Serializable {
    private static final long serialVersionUID = -5158224572470173267L;
    private final Boolean manualStart;
    private final Integer startPort;
    private final Integer endPort;
    private final String bindAddress;
    private final Integer socketBufferSize;
    private final Integer maximumTimeBetweenPings;
    private final String[] gatewayTransportFilters;
    private final String hostnameForSenders;
    private final Boolean ifNotExists;

    public GatewayReceiverFunctionArgs(CacheConfig.GatewayReceiver configuration, Boolean ifNotExists) {
        this.manualStart = configuration.isManualStart();
        this.startPort = configuration.getStartPort() != null ? Integer.valueOf(configuration.getStartPort()) : null;
        this.endPort = configuration.getEndPort() != null ? Integer.valueOf(configuration.getEndPort()) : null;
        this.bindAddress = configuration.getBindAddress();
        this.socketBufferSize = configuration.getSocketBufferSize() != null ? Integer.valueOf(configuration.getSocketBufferSize()) : null;
        this.maximumTimeBetweenPings = configuration.getMaximumTimeBetweenPings() != null ? Integer.valueOf(configuration.getMaximumTimeBetweenPings()) : null;
        this.gatewayTransportFilters = configuration.getGatewayTransportFilters() != null ? (String[])configuration.getGatewayTransportFilters().stream().map(ClassNameType::getClassName).toArray(String[]::new) : null;
        this.hostnameForSenders = configuration.getHostnameForSenders();
        this.ifNotExists = ifNotExists;
    }

    public Boolean isManualStart() {
        return this.manualStart;
    }

    public Integer getStartPort() {
        return this.startPort;
    }

    public Integer getEndPort() {
        return this.endPort;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public Integer getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings;
    }

    public String[] getGatewayTransportFilters() {
        return this.gatewayTransportFilters;
    }

    public String getHostnameForSenders() {
        return this.hostnameForSenders;
    }

    public Boolean getIfNotExists() {
        return this.ifNotExists;
    }
}

