/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashMap;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogLevel;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class ChangeLogLevelFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    public static final String ID = ChangeLogLevelFunction.class.getName();

    @Override
    public void execute(FunctionContext context) {
        InternalCache cache = (InternalCache)context.getCache();
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Object[] args = (Object[])context.getArguments();
            String logLevel = (String)args[0];
            Level log4jLevel = LogLevel.getLevel(logLevel);
            int logWriterLevel = LogLevel.getLogWriterLevel(logLevel);
            cache.getInternalDistributedSystem().getConfig().setLogLevel(logWriterLevel);
            System.setProperty("gemfire.log-level", logLevel);
            logger.info(LogMarker.CONFIG_MARKER, "GFSH Changed log level to {}", (Object)log4jLevel);
            result.put(cache.getDistributedSystem().getDistributedMember().getId(), "New log level is " + log4jLevel);
            context.getResultSender().lastResult(result);
        }
        catch (Exception ex) {
            logger.info(LogMarker.CONFIG_MARKER, "GFSH Changing log level exception {}", (Object)ex.getMessage(), (Object)ex);
            result.put(cache.getDistributedSystem().getDistributedMember().getId(), "ChangeLogLevelFunction exception " + ex.getMessage());
            context.getResultSender().lastResult(result);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

