/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class FilePathStringConverter
implements Converter<String> {
    public boolean supports(Class<?> type, String optionContext) {
        return String.class.equals(type) && optionContext.contains("geode.converter.file.path:disable-string-converter");
    }

    public String convertFromText(String value, Class<?> targetType, String optionContext) {
        return value;
    }

    public List<String> getRoots() {
        File[] roots = File.listRoots();
        return Arrays.stream(roots).map(File::getAbsolutePath).collect(Collectors.toList());
    }

    public List<String> getSiblings(String path) {
        File currentFile = new File(path);
        if (!currentFile.isDirectory()) {
            if ((currentFile = currentFile.getParentFile()) == null) {
                currentFile = new File("./");
                path = null;
            } else {
                path = currentFile.getPath();
            }
        }
        String prefix = path == null ? "" : (path.endsWith(File.separator) ? path : path + File.separator);
        return Arrays.stream(currentFile.list()).map(s -> prefix + s).collect(Collectors.toList());
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        if (StringUtils.isBlank((CharSequence)existingData)) {
            this.getRoots().stream().forEach(path -> completions.add(new Completion(path)));
            return !completions.isEmpty();
        }
        this.getSiblings(existingData).stream().filter(string -> string.startsWith(existingData)).forEach(path -> completions.add(new Completion(path)));
        return !completions.isEmpty();
    }
}

