/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StatusGatewayReceiverCommand
extends SingleGfshCommand {
    @CliCommand(value={"status gateway-receiver"}, help="Display the status of a Gateway Receiver.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel statusGatewayReceiver(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of Gateway Receivers for which to display status.") String[] onGroup, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the Gateway Receiver for which to display status.") String[] onMember) {
        SystemManagementService service = (SystemManagementService)this.getManagementService();
        Set<DistributedMember> dsMembers = this.findMembers(onGroup, onMember);
        if (dsMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        ResultModel crd = new ResultModel();
        TabularResultModel availableReceiverData = crd.addTable("Available GatewayReceiver Section");
        TabularResultModel notAvailableReceiverData = crd.addTable("Not Available GatewayReceiver Section");
        for (DistributedMember member : dsMembers) {
            GatewayReceiverMXBean receiverBean;
            ObjectName gatewayReceiverObjectName = MBeanJMXAdapter.getGatewayReceiverMBeanName(member);
            if (gatewayReceiverObjectName != null && (receiverBean = service.getMBeanProxy(gatewayReceiverObjectName, GatewayReceiverMXBean.class)) != null) {
                this.buildReceiverStatus(member.getId(), receiverBean, availableReceiverData);
                continue;
            }
            this.buildReceiverStatus(member.getId(), null, notAvailableReceiverData);
        }
        return crd;
    }

    private TabularResultModel buildReceiverStatus(String memberId, GatewayReceiverMXBean bean, TabularResultModel resultData) {
        resultData.accumulate("Member", memberId);
        if (bean != null) {
            resultData.accumulate("Port", Integer.toString(bean.getPort()));
            resultData.accumulate("Status", bean.isRunning() ? "Running" : "Not Running");
        } else {
            resultData.accumulate("Error", "GatewayReceiver is not available or already stopped");
        }
        return resultData;
    }
}

