/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.ShowMetricsCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.model.FileResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;

public class ShowMetricsInterceptor
extends AbstractCliAroundInterceptor {
    @Override
    public Result preExecution(GfshParseResult parseResult) {
        String export_to_report_to = parseResult.getParamValueAsString("file");
        if (export_to_report_to != null && !export_to_report_to.endsWith(".csv")) {
            return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".csv"));
        }
        String regionName = parseResult.getParamValueAsString("region");
        String port = parseResult.getParamValueAsString("port");
        String member = parseResult.getParamValueAsString("member");
        String[] categoryArgs = (String[])parseResult.getParamValue("categories");
        if (regionName != null && port != null) {
            return ResultBuilder.createUserErrorResult("The --region and --port parameters are mutually exclusive. Please only use one or the other.");
        }
        if (port != null && member == null) {
            return ResultBuilder.createUserErrorResult("If the --port parameter is specified, then the --member parameter must also be specified.");
        }
        if (categoryArgs != null) {
            boolean regionProvided = regionName != null;
            boolean portProvided = port != null;
            boolean memberProvided = member != null;
            List<String> validCategories = ShowMetricsInterceptor.getValidCategoriesAsStrings(regionProvided, memberProvided, portProvided);
            HashSet<String> userCategories = new HashSet<String>(Arrays.asList(categoryArgs));
            userCategories.removeAll(validCategories);
            if (!userCategories.isEmpty()) {
                return this.getInvalidCategoryResult(userCategories);
            }
        }
        return ResultBuilder.createInfoResult("OK");
    }

    static List<ShowMetricsCommand.Category> getValidCategories(boolean regionProvided, boolean memberProvided, boolean portProvided) {
        if (regionProvided && memberProvided) {
            return ShowMetricsCommand.REGION_METRIC_CATEGORIES;
        }
        if (regionProvided) {
            return ShowMetricsCommand.SYSTEM_REGION_METRIC_CATEGORIES;
        }
        if (memberProvided && portProvided) {
            return ShowMetricsCommand.MEMBER_WITH_PORT_METRIC_CATEGORIES;
        }
        if (memberProvided) {
            return ShowMetricsCommand.MEMBER_METRIC_CATEGORIES;
        }
        return ShowMetricsCommand.SYSTEM_METRIC_CATEGORIES;
    }

    static List<String> getValidCategoriesAsStrings(boolean regionProvided, boolean memberProvided, boolean portProvided) {
        return ShowMetricsInterceptor.getValidCategories(regionProvided, memberProvided, portProvided).stream().map(Enum::name).collect(Collectors.toList());
    }

    private CommandResult getInvalidCategoryResult(Set<String> invalidCategories) {
        StringBuilder sb = new StringBuilder();
        sb.append("Invalid Categories\n");
        for (String category : invalidCategories) {
            sb.append(category);
            sb.append('\n');
        }
        return ResultBuilder.createUserErrorResult(sb.toString());
    }

    @Override
    public ResultModel postExecution(GfshParseResult parseResult, ResultModel resultModel, Path tempFile) {
        try {
            for (Map.Entry<String, FileResultModel> entry : resultModel.getFiles().entrySet()) {
                entry.getValue().saveFile();
                resultModel.addInfo().addLine("Metrics saved to: " + entry.getKey());
            }
        }
        catch (IOException e) {
            resultModel.addInfo().addLine("Unable to save file: " + e.getMessage());
            resultModel.setStatus(Result.Status.ERROR);
        }
        return resultModel;
    }
}

