/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ModelCommandResult;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.springframework.shell.event.ParseResult;

public class QueryInterceptor
extends AbstractCliAroundInterceptor {
    public static final String FILE_ALREADY_EXISTS_MESSAGE = "The specified output file already exists.";

    @Override
    public ResultModel preExecution(GfshParseResult parseResult) {
        File outputFile = this.getOutputFile(parseResult);
        if (outputFile != null && outputFile.exists()) {
            return ResultModel.createError(FILE_ALREADY_EXISTS_MESSAGE);
        }
        return new ResultModel();
    }

    @Override
    public ResultModel postExecution(GfshParseResult parseResult, ResultModel model, Path tempFile) throws Exception {
        File outputFile = this.getOutputFile(parseResult);
        if (outputFile == null) {
            return model;
        }
        Object sectionResultData = model.getDataSection("data-info").getContent();
        String limit = (String)sectionResultData.get("Limit");
        String resultString = (String)sectionResultData.get("Result");
        String rows = (String)sectionResultData.get("Rows");
        if ("false".equalsIgnoreCase(resultString)) {
            return model;
        }
        this.writeResultTableToFile(outputFile, new ModelCommandResult(model));
        ResultModel newModel = new ResultModel();
        DataResultModel data = newModel.addData("data-info");
        data.addData("Result", resultString);
        if (StringUtils.isNotBlank((CharSequence)limit)) {
            data.addData("Limit", limit);
        }
        data.addData("Rows", rows);
        newModel.addInfo().addLine("Query results output to " + outputFile.getAbsolutePath());
        return newModel;
    }

    private File getOutputFile(ParseResult parseResult) {
        return (File)parseResult.getArguments()[1];
    }

    private void writeResultTableToFile(File file, CommandResult commandResult) throws IOException {
        try (FileWriter fileWriter = new FileWriter(file);){
            while (commandResult.hasNextLine()) {
                fileWriter.write(commandResult.nextLine());
                if (!commandResult.hasNextLine()) continue;
                fileWriter.write(SystemUtils.LINE_SEPARATOR);
            }
        }
    }
}

