/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ListGatewayCommand
extends InternalGfshCommand {
    @CliCommand(value={"list gateways"}, help="Display the Gateway Senders and Receivers for a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel listGateway(@CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Member(s) for which Gateway Senders and Receivers will be displayed.") String[] onMember, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members for which Gateway Senders and Receivers will be displayed.") String[] onGroup) throws Exception {
        ResultModel result = new ResultModel();
        SystemManagementService service = (SystemManagementService)this.getManagementService();
        Set<DistributedMember> dsMembers = this.findMembers(onGroup, onMember);
        if (dsMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        TreeMap<String, Map<String, GatewaySenderMXBean>> gatewaySenderBeans = new TreeMap<String, Map<String, GatewaySenderMXBean>>();
        TreeMap<String, GatewayReceiverMXBean> gatewayReceiverBeans = new TreeMap<String, GatewayReceiverMXBean>();
        DistributedSystemMXBean dsMXBean = service.getDistributedSystemMXBean();
        for (DistributedMember member : dsMembers) {
            GatewayReceiverMXBean receiverBean;
            ObjectName gatewayReceiverObjectName;
            String memberName = member.getName();
            String memberNameOrId = memberName != null && !memberName.isEmpty() ? memberName : member.getId();
            ObjectName[] gatewaySenderObjectNames = dsMXBean.listGatewaySenderObjectNames(memberNameOrId);
            if (gatewaySenderObjectNames != null) {
                for (ObjectName name : gatewaySenderObjectNames) {
                    Map<String, GatewaySenderMXBean> memberToBeanMap;
                    GatewaySenderMXBean senderBean = service.getMBeanProxy(name, GatewaySenderMXBean.class);
                    if (senderBean == null) continue;
                    if (gatewaySenderBeans.containsKey(senderBean.getSenderId())) {
                        memberToBeanMap = (Map)gatewaySenderBeans.get(senderBean.getSenderId());
                        memberToBeanMap.put(member.getId(), senderBean);
                        continue;
                    }
                    memberToBeanMap = new TreeMap<String, GatewaySenderMXBean>();
                    memberToBeanMap.put(member.getId(), senderBean);
                    gatewaySenderBeans.put(senderBean.getSenderId(), memberToBeanMap);
                }
            }
            if ((gatewayReceiverObjectName = MBeanJMXAdapter.getGatewayReceiverMBeanName(member)) == null || (receiverBean = service.getMBeanProxy(gatewayReceiverObjectName, GatewayReceiverMXBean.class)) == null) continue;
            gatewayReceiverBeans.put(member.getId(), receiverBean);
        }
        if (gatewaySenderBeans.isEmpty() && gatewayReceiverBeans.isEmpty()) {
            return ResultModel.createError("GatewaySenders or GatewayReceivers are not available in cluster");
        }
        this.accumulateListGatewayResult(result, gatewaySenderBeans, gatewayReceiverBeans);
        return result;
    }

    protected void accumulateListGatewayResult(ResultModel result, Map<String, Map<String, GatewaySenderMXBean>> gatewaySenderBeans, Map<String, GatewayReceiverMXBean> gatewayReceiverBeans) {
        TabularResultModel gatewaySenders;
        if (!gatewaySenderBeans.isEmpty()) {
            gatewaySenders = result.addTable("gatewaySenders");
            gatewaySenders.setHeader("GatewaySender Section");
            for (Map.Entry<String, Object> entry : gatewaySenderBeans.entrySet()) {
                for (Map.Entry memberToBean : ((Map)entry.getValue()).entrySet()) {
                    gatewaySenders.accumulate("GatewaySender Id", entry.getKey());
                    gatewaySenders.accumulate("Member", (String)memberToBean.getKey());
                    gatewaySenders.accumulate("Remote Cluster Id", ((GatewaySenderMXBean)memberToBean.getValue()).getRemoteDSId() + "");
                    gatewaySenders.accumulate("Type", ((GatewaySenderMXBean)memberToBean.getValue()).isParallel() ? "Parallel" : "Serial");
                    gatewaySenders.accumulate("Status", ((GatewaySenderMXBean)memberToBean.getValue()).isRunning() ? "Running" : "Not Running");
                    gatewaySenders.accumulate("Queued Events", ((GatewaySenderMXBean)memberToBean.getValue()).getEventQueueSize() + "");
                    gatewaySenders.accumulate("Receiver Location", ((GatewaySenderMXBean)memberToBean.getValue()).getGatewayReceiver());
                }
            }
        }
        if (!gatewayReceiverBeans.isEmpty()) {
            gatewaySenders = result.addTable("gatewayReceivers");
            gatewaySenders.setHeader("GatewayReceiver Section");
            for (Map.Entry<String, Object> entry : gatewayReceiverBeans.entrySet()) {
                gatewaySenders.accumulate("Member", entry.getKey());
                gatewaySenders.accumulate("Port", ((GatewayReceiverMXBean)entry.getValue()).getPort() + "");
                gatewaySenders.accumulate("Sender Count", ((GatewayReceiverMXBean)entry.getValue()).getClientConnectionCount() + "");
                if (entry.getValue() == null || ((GatewayReceiverMXBean)entry.getValue()).getConnectedGatewaySenders() == null) {
                    gatewaySenders.accumulate("Senders Connected", "");
                    continue;
                }
                gatewaySenders.accumulate("Senders Connected", Arrays.stream(((GatewayReceiverMXBean)entry.getValue()).getConnectedGatewaySenders()).collect(Collectors.joining(", ")));
            }
        }
    }
}

