/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.commands.DiskStoreCommandsUtils;
import org.apache.geode.management.internal.cli.domain.DiskStoreDetails;
import org.apache.geode.management.internal.cli.functions.ListDiskStoresFunction;
import org.apache.geode.management.internal.cli.result.ResultDataException;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;

public class ListDiskStoresCommand
extends GfshCommand {
    @CliCommand(value={"list disk-stores"}, help="Display disk stores for all members.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel listDiskStores() {
        Set<DistributedMember> dataMembers = DiskStoreCommandsUtils.getNormalMembers((InternalCache)this.getCache());
        if (dataMembers.isEmpty()) {
            return ResultModel.createInfo("No caching members found.");
        }
        return this.toTabularResult(this.getDiskStoreListing(dataMembers));
    }

    List<DiskStoreDetails> getDiskStoreListing(Set<DistributedMember> members) {
        Execution membersFunctionExecutor = this.getMembersFunctionExecutor(members);
        if (membersFunctionExecutor instanceof AbstractExecution) {
            ((AbstractExecution)membersFunctionExecutor).setIgnoreDepartedMembers(true);
        }
        ResultCollector resultCollector = membersFunctionExecutor.execute(new ListDiskStoresFunction());
        List results = (List)resultCollector.getResult();
        ArrayList<DiskStoreDetails> distributedSystemMemberDiskStores = new ArrayList<DiskStoreDetails>(results.size());
        for (Object result : results) {
            if (!(result instanceof Set)) continue;
            distributedSystemMemberDiskStores.addAll((Set)result);
        }
        Collections.sort(distributedSystemMemberDiskStores);
        return distributedSystemMemberDiskStores;
    }

    private ResultModel toTabularResult(List<DiskStoreDetails> diskStoreList) throws ResultDataException {
        if (!diskStoreList.isEmpty()) {
            ResultModel result = new ResultModel();
            TabularResultModel diskStoreData = result.addTable("disk-store");
            for (DiskStoreDetails diskStoreDetails : diskStoreList) {
                diskStoreData.accumulate("Member Name", diskStoreDetails.getMemberName());
                diskStoreData.accumulate("Member Id", diskStoreDetails.getMemberId());
                diskStoreData.accumulate("Disk Store Name", diskStoreDetails.getName());
                diskStoreData.accumulate("Disk Store ID", diskStoreDetails.getId().toString());
            }
            return result;
        }
        return ResultModel.createInfo("No Disk Stores Found");
    }
}

