/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.ListDeployedFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ListDeployedCommand
extends GfshCommand {
    private final ListDeployedFunction listDeployedFunction = new ListDeployedFunction();

    @CliCommand(value={"list deployed"}, help="Display a list of JARs that were deployed to members using the \"deploy\" command.")
    @CliMetaData(relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel listDeployed(@CliOption(key={"group", "groups"}, help="Group(s) of members for which deployed JARs will be displayed.  If not specified, JARs for all members will be displayed.") String[] group) {
        Set<DistributedMember> targetMembers = this.findMembers(group, null);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        ResultModel result = new ResultModel();
        TabularResultModel tabularData = result.addTable("jars");
        List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult(this.listDeployedFunction, null, targetMembers);
        for (CliFunctionResult cliResult : functionResults) {
            Map strings = (Map)cliResult.getResultObject();
            if (strings == null) continue;
            for (Map.Entry jar : strings.entrySet()) {
                tabularData.accumulate("Member", cliResult.getMemberIdOrName());
                tabularData.accumulate("JAR", (String)jar.getKey());
                tabularData.accumulate("JAR Location", (String)jar.getValue());
            }
        }
        if (tabularData.getRowSize() == 0) {
            return ResultModel.createInfo("No JAR Files Found");
        }
        return result;
    }
}

