/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ExportOfflineDiskStoreCommand
extends SingleGfshCommand {
    @CliCommand(value={"export offline-disk-store"}, help="Export region data from an offline disk store into Geode snapshot files.")
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public ResultModel exportOfflineDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the disk store to be exported.") String diskStoreName, @CliOption(key={"disk-dirs"}, mandatory=true, help="Directories which contain the disk store files.") String[] diskDirs, @CliOption(key={"dir"}, mandatory=true, help="Directory to export snapshot files to.") String dir) {
        try {
            File[] dirs = new File[diskDirs.length];
            for (int i = 0; i < diskDirs.length; ++i) {
                dirs[i] = new File(diskDirs[i]);
            }
            File output = new File(dir);
            DiskStoreImpl.exportOfflineSnapshot(diskStoreName, dirs, output);
            return ResultModel.createInfo(CliStrings.format("Exported all regions from disk store {0} to the directory {1}", diskStoreName, dir));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            LogWrapper.getInstance(this.getCache()).warning(th.getMessage(), th);
            return ResultModel.createError(CliStrings.format("Error exporting disk store {0} is : {1}", diskStoreName, th.toString()));
        }
    }
}

