/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.JndiBindingsType;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.DestroyJndiBindingFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyJndiBindingCommand
extends SingleGfshCommand {
    static final String DESTROY_JNDIBINDING = "destroy jndi-binding";
    static final String DESTROY_JNDIBINDING__HELP = "Destroy a JNDI binding that holds the configuration for an XA datasource.";
    static final String JNDI_NAME = "name";
    static final String JNDI_NAME__HELP = "Name of the binding to be destroyed.";
    static final String IFEXISTS_HELP = "Skip the destroy operation when the specified JNDI binding does not exist. Without this option, an error results from the specification of a JNDI binding that does not exist.";

    @CliCommand(value={"destroy jndi-binding"}, help="Destroy a JNDI binding that holds the configuration for an XA datasource.")
    @CliMetaData(relatedTopic={"Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel destroyJDNIBinding(@CliOption(key={"name"}, mandatory=true, help="Name of the binding to be destroyed.") String jndiName, @CliOption(key={"if-exists"}, help="Skip the destroy operation when the specified JNDI binding does not exist. Without this option, an error results from the specification of a JNDI binding that does not exist.", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean ifExists) {
        List bindings;
        JndiBindingsType.JndiBinding binding;
        InternalConfigurationPersistenceService service = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (service != null && (binding = (JndiBindingsType.JndiBinding)CacheElement.findElement((List)(bindings = service.getCacheConfig("cluster").getJndiBindings()), (String)jndiName)) == null) {
            throw new EntityNotFoundException(CliStrings.format("Jndi binding with jndi-name \"{0}\" does not exist.", (Object)jndiName), ifExists);
        }
        Set<DistributedMember> targetMembers = this.findMembers(null, null);
        if (targetMembers.size() > 0) {
            List<CliFunctionResult> jndiCreationResult = this.executeAndGetFunctionResult(new DestroyJndiBindingFunction(), new Object[]{jndiName, false}, targetMembers);
            ResultModel result = ResultModel.createMemberStatusResult(jndiCreationResult);
            result.setConfigObject(jndiName);
            return result;
        }
        return ResultModel.createInfo("No members found.");
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object element) {
        CacheElement.removeElement((List)config.getJndiBindings(), (String)((String)element));
        return true;
    }
}

