/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.domain.CacheServerInfo;
import org.apache.geode.management.internal.cli.domain.MemberInformation;
import org.apache.geode.management.internal.cli.functions.GetMemberInformationFunction;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DescribeMemberCommand
extends GfshCommand {
    @Immutable
    private static final GetMemberInformationFunction getMemberInformation = new GetMemberInformationFunction();

    @CliCommand(value={"describe member"}, help="Display information about a member, including name, id, groups, regions, etc.")
    @CliMetaData(relatedTopic={"Server"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel describeMember(@CliOption(key={"name"}, optionContext="geode.converter.all.member.idOrName:disable-string-converter", help="Display information about a member, including name, id, groups, regions, etc.", mandatory=true) String memberNameOrId) {
        List<CacheServerInfo> csList;
        DistributedMember memberToBeDescribed = this.getMember(memberNameOrId);
        ResultCollector<?, ?> rc = this.executeFunction((Function)getMemberInformation, null, memberToBeDescribed);
        ArrayList output = (ArrayList)rc.getResult();
        Object obj = output.get(0);
        if (obj == null || !(obj instanceof MemberInformation)) {
            return ResultModel.createInfo(String.format("Information for the member %s could not be retrieved.", memberNameOrId));
        }
        ResultModel result = new ResultModel();
        DataResultModel memberInfo = result.addData("memberInfo");
        MemberInformation memberInformation = (MemberInformation)obj;
        memberInfo.addData("Name", memberInformation.getName());
        memberInfo.addData("Id", memberInformation.getId());
        memberInfo.addData("Host", memberInformation.getHost());
        memberInfo.addData("Regions", StringUtils.join(memberInformation.getHostedRegions(), (char)'\n'));
        memberInfo.addData("PID", memberInformation.getProcessId());
        memberInfo.addData("Groups", memberInformation.getGroups());
        memberInfo.addData("Used Heap", memberInformation.getHeapUsage() + "M");
        memberInfo.addData("Max Heap", memberInformation.getMaxHeapSize() + "M");
        String offHeapMemorySize = memberInformation.getOffHeapMemorySize();
        if (offHeapMemorySize != null && !offHeapMemorySize.isEmpty()) {
            memberInfo.addData("Off Heap Size", offHeapMemorySize);
        }
        memberInfo.addData("Working Dir", memberInformation.getWorkingDirPath());
        memberInfo.addData("Log file", memberInformation.getLogFilePath());
        memberInfo.addData("Locators", memberInformation.getLocators());
        if (memberInformation.isServer() && (csList = memberInformation.getCacheServeInfo()) != null) {
            DataResultModel connectionInfo = result.addData("connectionInfo");
            Iterator<CacheServerInfo> iters = csList.iterator();
            connectionInfo.setHeader("Cache Server Information");
            while (iters.hasNext()) {
                CacheServerInfo cacheServerInfo = iters.next();
                connectionInfo.addData("Server Bind", cacheServerInfo.getBindAddress());
                connectionInfo.addData("Server Port", cacheServerInfo.getPort());
                connectionInfo.addData("Running", cacheServerInfo.isRunning());
            }
            connectionInfo.addData("Client Connections", memberInformation.getClientCount());
        }
        return result;
    }
}

