/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.CacheServerMXBean;
import org.apache.geode.management.ClientHealthStatus;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.functions.ContinuousQueryFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DescribeClientCommand
extends GfshCommand {
    @CliCommand(value={"describe client"}, help="Display details of specified client")
    @CliMetaData(relatedTopic={"Client"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel describeClient(@CliOption(key={"clientID"}, mandatory=true, help="ID of a client for which details are needed") String clientId) throws Exception {
        CacheServerMXBean service;
        ObjectName[] cacheServers;
        ResultModel result = new ResultModel();
        if (clientId.startsWith("\"")) {
            clientId = clientId.substring(1);
        }
        if (clientId.endsWith("\"")) {
            clientId = clientId.substring(0, clientId.length() - 2);
        }
        if (clientId.endsWith("\";")) {
            clientId = clientId.substring(0, clientId.length() - 2);
        }
        if ((cacheServers = ((ManagementService)((Object)(service = this.getManagementService()))).getDistributedSystemMXBean().listCacheServerObjectNames()).length == 0) {
            return ResultModel.createError(CliStrings.format("No cache-servers were observed.", new Object[0]));
        }
        ClientHealthStatus clientHealthStatus = null;
        for (ObjectName objName : cacheServers) {
            CacheServerMXBean serverMbean = ((ManagementService)((Object)service)).getMBeanInstance(objName, CacheServerMXBean.class);
            ArrayList<String> listOfClient = new ArrayList<String>(Arrays.asList(serverMbean.getClientIds()));
            if (!listOfClient.contains(clientId) || clientHealthStatus != null) continue;
            try {
                clientHealthStatus = serverMbean.showClientStats(clientId);
                if (clientHealthStatus != null) continue;
                return ResultModel.createError(CliStrings.format("Could not retrieve stats for client : {0}", (Object)clientId));
            }
            catch (Exception eee) {
                return ResultModel.createError(CliStrings.format("Could not retrieve stats for client : {0}. Reason : {1}", clientId, eee.getMessage()));
            }
        }
        if (clientHealthStatus == null) {
            return ResultModel.createError(CliStrings.format("Specified Client ID {0} not present", (Object)clientId));
        }
        Set<DistributedMember> dsMembers = this.getAllMembers();
        String isDurable = null;
        ArrayList<String> primaryServers = new ArrayList<String>();
        ArrayList<String> secondaryServers = new ArrayList<String>();
        if (dsMembers.size() > 0) {
            ContinuousQueryFunction continuousQueryFunction = new ContinuousQueryFunction();
            FunctionService.registerFunction(continuousQueryFunction);
            List resultList = (List)CliUtil.executeFunction(continuousQueryFunction, clientId, dsMembers).getResult();
            for (Object aResultList : resultList) {
                Object object = aResultList;
                if (object instanceof Throwable) {
                    LogWrapper.getInstance(this.getCache()).warning("Exception in Describe Client " + ((Throwable)object).getMessage(), (Throwable)object);
                    continue;
                }
                if (object == null) continue;
                ContinuousQueryFunction.ClientInfo objectResult = (ContinuousQueryFunction.ClientInfo)object;
                isDurable = objectResult.isDurable;
                if (objectResult.primaryServer != null && objectResult.primaryServer.length() > 0) {
                    if (primaryServers.size() == 0) {
                        primaryServers.add(objectResult.primaryServer);
                    } else {
                        primaryServers.add(" ,");
                        primaryServers.add(objectResult.primaryServer);
                    }
                }
                if (objectResult.secondaryServer == null || objectResult.secondaryServer.length() <= 0) continue;
                if (secondaryServers.size() == 0) {
                    secondaryServers.add(objectResult.secondaryServer);
                    continue;
                }
                secondaryServers.add(" ,");
                secondaryServers.add(objectResult.secondaryServer);
            }
            this.buildTableResult(result, clientHealthStatus, isDurable, primaryServers, secondaryServers);
        } else {
            result = ResultModel.createError("DS has no members");
        }
        LogWrapper.getInstance(this.getCache()).info("describe client result " + result);
        return result;
    }

    private void buildTableResult(ResultModel result, ClientHealthStatus clientHealthStatus, String isDurable, List<String> primaryServers, List<String> secondaryServers) {
        StringBuilder primServers = new StringBuilder();
        for (String string : primaryServers) {
            primServers.append(string);
        }
        StringBuilder secondServers = new StringBuilder();
        for (String secondServer : secondaryServers) {
            secondServers.append(secondServer);
        }
        DataResultModel dataResultModel = result.addData("infoSection");
        if (clientHealthStatus != null) {
            dataResultModel.addData("Primary Servers", primServers);
            dataResultModel.addData("Secondary Servers", secondServers);
            dataResultModel.addData("CPU", clientHealthStatus.getCpus());
            dataResultModel.addData("Number of Cache Listener Calls", clientHealthStatus.getNumOfCacheListenerCalls());
            dataResultModel.addData("Number of Gets", clientHealthStatus.getNumOfGets());
            dataResultModel.addData("Number of Misses", clientHealthStatus.getNumOfMisses());
            dataResultModel.addData("Number of Puts", clientHealthStatus.getNumOfPuts());
            dataResultModel.addData("Number of Threads", clientHealthStatus.getNumOfThreads());
            dataResultModel.addData("Process CPU Time (nanoseconds)", clientHealthStatus.getProcessCpuTime());
            dataResultModel.addData("Queue size", clientHealthStatus.getQueueSize());
            dataResultModel.addData("UP Time (seconds)", clientHealthStatus.getUpTime());
            dataResultModel.addData("Is Durable", isDurable);
            Map<String, String> poolStats = clientHealthStatus.getPoolStats();
            if (poolStats.size() > 0) {
                for (Map.Entry<String, String> entry : poolStats.entrySet()) {
                    TabularResultModel poolStatsResultTable = result.addTable(entry.getKey());
                    poolStatsResultTable.setHeader("Pool Stats For Pool Name = " + entry.getKey());
                    String poolStatsStr = entry.getValue();
                    String[] str = poolStatsStr.split(";");
                    LogWrapper logWrapper = LogWrapper.getInstance(this.getCache());
                    logWrapper.info("describe client clientHealthStatus min conn=" + str[0].substring(str[0].indexOf("=") + 1));
                    logWrapper.info("describe client clientHealthStatus max conn =" + str[1].substring(str[1].indexOf("=") + 1));
                    logWrapper.info("describe client clientHealthStatus redundancy =" + str[2].substring(str[2].indexOf("=") + 1));
                    logWrapper.info("describe client clientHealthStatus CQs =" + str[3].substring(str[3].indexOf("=") + 1));
                    poolStatsResultTable.accumulate("Minimum Connections", str[0].substring(str[0].indexOf("=") + 1));
                    poolStatsResultTable.accumulate("Maximum Connections", str[1].substring(str[1].indexOf("=") + 1));
                    poolStatsResultTable.accumulate("Redundancy", str[2].substring(str[2].indexOf("=") + 1));
                    poolStatsResultTable.accumulate("Num of CQs", str[3].substring(str[3].indexOf("=") + 1));
                }
            }
        }
    }
}

