/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.IndexDefinition;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DefineIndexCommand
extends InternalGfshCommand {
    @CliCommand(value={"define index"}, help="Define an index that can be used when executing queries.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public ResultModel defineIndex(@CliOption(key={"name"}, mandatory=true, help="Define an index that can be used when executing queries.") String indexName, @CliOption(key={"expression"}, mandatory=true, help="Field of the region values that are referenced by the index.") String indexedExpression, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region which corresponds to the \"from\" clause in a query.") String regionPath, @CliOption(key={"type"}, unspecifiedDefaultValue="range", optionContext="geode.converter.index.type:disable-enum-converter", help="Type of the index. Valid values are: range and key. Deprecated: Since Geode 1.4, hash should not be used.") IndexType indexType) {
        ResultModel result = new ResultModel();
        RegionConfig.Index indexInfo = new RegionConfig.Index();
        indexInfo.setName(indexName);
        indexInfo.setExpression(indexedExpression);
        indexInfo.setFromClause(regionPath);
        indexInfo.setType(indexType.getName());
        IndexDefinition.indexDefinitions.add(indexInfo);
        InfoResultModel infoResult = result.addInfo();
        infoResult.addLine("Index successfully defined with following details");
        infoResult.addLine(CliStrings.format("Name       : {0}", (Object)indexName));
        infoResult.addLine(CliStrings.format("Expression : {0}", (Object)indexedExpression));
        infoResult.addLine(CliStrings.format("RegionPath : {0}", (Object)regionPath));
        return result;
    }
}

