/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.backup.BackupOperation;
import org.apache.geode.management.BackupStatus;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class BackupDiskStoreCommand
extends GfshCommand {
    public static final String BACKED_UP_DISKSTORES_SECTION = "backed-up-diskstores";
    public static final String OFFLINE_DISKSTORES_SECTION = "offline-diskstores";

    @CliCommand(value={"backup disk-store"}, help="Perform a backup on all members with persistent data. The target directory must exist on all members, but can be either local or shared. This command can safely be executed on active members and is strongly recommended over copying files via operating system commands.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.READ)
    public ResultModel backupDiskStore(@CliOption(key={"dir"}, help="Directory to which backup files will be written.", mandatory=true) String targetDir, @CliOption(key={"baseline-dir"}, help="Directory which contains the baseline backup used for comparison during an incremental backup.") String baselineDir) {
        this.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.WRITE, ResourcePermission.Target.DISK);
        ResultModel result = new ResultModel();
        try {
            InternalCache cache = (InternalCache)this.getCache();
            DistributionManager dm = cache.getDistributionManager();
            BackupStatus backupStatus = baselineDir != null && !baselineDir.isEmpty() ? new BackupOperation(dm, dm.getCache()).backupAllMembers(targetDir, baselineDir) : new BackupOperation(dm, dm.getCache()).backupAllMembers(targetDir, null);
            Map<DistributedMember, Set<PersistentID>> backedupMemberDiskstoreMap = backupStatus.getBackedUpDiskStores();
            Set<DistributedMember> backedupMembers = backedupMemberDiskstoreMap.keySet();
            if (!backedupMembers.isEmpty()) {
                TabularResultModel backedupDiskStoresTable = result.addTable(BACKED_UP_DISKSTORES_SECTION);
                backedupDiskStoresTable.setHeader("The following disk stores were backed up successfully");
                for (DistributedMember member : backedupMembers) {
                    Set<PersistentID> backedupDiskStores = backedupMemberDiskstoreMap.get(member);
                    boolean printMember = true;
                    String memberName = member.getName();
                    if (memberName == null || memberName.isEmpty()) {
                        memberName = member.getId();
                    }
                    for (PersistentID persistentId : backedupDiskStores) {
                        if (persistentId == null) continue;
                        String UUID2 = persistentId.getUUID().toString();
                        String hostName = persistentId.getHost().getHostName();
                        String directory = persistentId.getDirectory();
                        if (printMember) {
                            this.writeToBackupDiskStoreTable(backedupDiskStoresTable, memberName, UUID2, hostName, directory);
                            printMember = false;
                            continue;
                        }
                        this.writeToBackupDiskStoreTable(backedupDiskStoresTable, "", UUID2, hostName, directory);
                    }
                }
            } else {
                result.addInfo().addLine("No disk store(s) were backed up.");
            }
            Set<PersistentID> offlineDiskStores = backupStatus.getOfflineDiskStores();
            if (!offlineDiskStores.isEmpty()) {
                TabularResultModel offlineDiskStoresTable = result.addTable(OFFLINE_DISKSTORES_SECTION);
                offlineDiskStoresTable.setHeader("The backup may be incomplete. The following disk stores are not online");
                for (PersistentID offlineDiskStore : offlineDiskStores) {
                    offlineDiskStoresTable.accumulate("UUID", offlineDiskStore.getUUID().toString());
                    offlineDiskStoresTable.accumulate("Host", offlineDiskStore.getHost().getHostName());
                    offlineDiskStoresTable.accumulate("Directory", offlineDiskStore.getDirectory());
                }
            }
        }
        catch (Exception e) {
            return ResultModel.createError(e.getMessage());
        }
        return result;
    }

    private void writeToBackupDiskStoreTable(TabularResultModel table, String memberId, String UUID2, String host, String directory) {
        table.accumulate("Member", memberId);
        table.accumulate("UUID", UUID2);
        table.accumulate("Directory", directory);
        table.accumulate("Host", host);
    }
}

