/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogLevel;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.functions.AlterRuntimeConfigFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class AlterRuntimeConfigCommand
extends InternalGfshCommand {
    private final AlterRuntimeConfigFunction alterRunTimeConfigFunction = new AlterRuntimeConfigFunction();
    private static final Logger logger = LogService.getLogger();

    @CliCommand(value={"alter runtime"}, help="Alter a subset of member or members configuration properties while running.")
    @CliMetaData(relatedTopic={"Configuration"}, interceptor="org.apache.geode.management.internal.cli.commands.AlterRuntimeConfigCommand$AlterRuntimeInterceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel alterRuntimeConfig(@CliOption(key={"member", "members"}, optionContext="geode.converter.all.member.idOrName:disable-string-converter", help="Name/Id of the member in whose configuration will be altered.") String[] memberNameOrId, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Name/Id of the member in whose configuration will be altered.") String[] group, @CliOption(key={"archive-disk-space-limit"}, help="Archive disk space limit. Valid values are (in megabytes): 0 - 1000000.") Integer archiveDiskSpaceLimit, @CliOption(key={"archive-file-size-limit"}, help="Archive file size limit. Valid values are (in megabytes): 0 - 1000000.") Integer archiveFileSizeLimit, @CliOption(key={"log-disk-space-limit"}, help="Log disk space limit. Valid values are (in megabytes): 0 - 1000000.") Integer logDiskSpaceLimit, @CliOption(key={"log-file-size-limit"}, help="Log file size limit. Valid values are (in megabytes): 0 - 1000000.") Integer logFileSizeLimit, @CliOption(key={"log-level"}, optionContext="geode.converter.log.levels:disable-string-converter", help="Log level. Possible values for log-level include: ALL, TRACE, DEBUG, INFO, WARN, ERROR, FATAL, OFF.") String logLevel, @CliOption(key={"statistic-archive-file"}, help="File to which the statistics will be written.") String statisticArchiveFile, @CliOption(key={"statistic-sample-rate"}, help="Statistic sampling rate. Valid values are (in milliseconds): 100 - 60000.") Integer statisticSampleRate, @CliOption(key={"enable-statistics"}, help="Whether statistic sampling should be enabled. Valid values are: true and false.") Boolean statisticSamplingEnabled, @CliOption(key={"copy-on-read"}, specifiedDefaultValue="false", help="Sets the \"copy on read\" feature for cache read operations") Boolean setCopyOnRead, @CliOption(key={"lock-lease"}, help="Sets the length, in seconds, of distributed lock leases obtained by this cache.") Integer lockLease, @CliOption(key={"lock-timeout"}, help="Sets the number of seconds a cache operation may wait to obtain a distributed lock lease before timing out.") Integer lockTimeout, @CliOption(key={"message-sync-interval"}, help="Sets the frequency (in seconds) at which a message will be sent by the primary cache-server node to all the secondary cache-server nodes to remove the events which have already been dispatched from the queue") Integer messageSyncInterval, @CliOption(key={"search-timeout"}, help="Sets the number of seconds a cache get operation can spend searching for a value.") Integer searchTimeout) {
        HashMap<String, String> runTimeDistributionConfigAttributes = new HashMap<String, String>();
        HashMap<String, String> rumTimeCacheAttributes = new HashMap<String, String>();
        Set<DistributedMember> targetMembers = this.findMembers(group, memberNameOrId);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        if (archiveDiskSpaceLimit != null) {
            runTimeDistributionConfigAttributes.put("archive-disk-space-limit", archiveDiskSpaceLimit.toString());
        }
        if (archiveFileSizeLimit != null) {
            runTimeDistributionConfigAttributes.put("archive-file-size-limit", archiveFileSizeLimit.toString());
        }
        if (logDiskSpaceLimit != null) {
            runTimeDistributionConfigAttributes.put("log-disk-space-limit", logDiskSpaceLimit.toString());
        }
        if (logFileSizeLimit != null) {
            runTimeDistributionConfigAttributes.put("log-file-size-limit", logFileSizeLimit.toString());
        }
        if (logLevel != null && !logLevel.isEmpty()) {
            runTimeDistributionConfigAttributes.put("log-level", logLevel);
        }
        if (statisticArchiveFile != null && !statisticArchiveFile.isEmpty()) {
            runTimeDistributionConfigAttributes.put("statistic-archive-file", statisticArchiveFile);
        }
        if (statisticSampleRate != null) {
            runTimeDistributionConfigAttributes.put("statistic-sample-rate", statisticSampleRate.toString());
        }
        if (statisticSamplingEnabled != null) {
            runTimeDistributionConfigAttributes.put("statistic-sampling-enabled", statisticSamplingEnabled.toString());
        }
        if (setCopyOnRead != null) {
            rumTimeCacheAttributes.put("copy-on-read", setCopyOnRead.toString());
        }
        if (lockLease != null && lockLease > 0 && lockLease < Integer.MAX_VALUE) {
            rumTimeCacheAttributes.put("lock-lease", lockLease.toString());
        }
        if (lockTimeout != null && lockTimeout > 0 && lockTimeout < Integer.MAX_VALUE) {
            rumTimeCacheAttributes.put("lock-timeout", lockTimeout.toString());
        }
        if (messageSyncInterval != null && messageSyncInterval > 0 && messageSyncInterval < Integer.MAX_VALUE) {
            rumTimeCacheAttributes.put("message-sync-interval", messageSyncInterval.toString());
        }
        if (searchTimeout != null && searchTimeout > 0 && searchTimeout < Integer.MAX_VALUE) {
            rumTimeCacheAttributes.put("search-timeout", searchTimeout.toString());
        }
        if (runTimeDistributionConfigAttributes.isEmpty() && rumTimeCacheAttributes.isEmpty()) {
            return ResultModel.createError("Please provide a relevant parameter(s)");
        }
        HashMap<String, String> allRunTimeAttributes = new HashMap<String, String>();
        allRunTimeAttributes.putAll(runTimeDistributionConfigAttributes);
        allRunTimeAttributes.putAll(rumTimeCacheAttributes);
        ResultCollector<?, ?> rc = CliUtil.executeFunction(this.alterRunTimeConfigFunction, allRunTimeAttributes, targetMembers);
        List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
        TreeSet<String> successfulMembers = new TreeSet<String>();
        TreeSet<String> errorMessages = new TreeSet<String>();
        for (CliFunctionResult result : results) {
            if (result.getThrowable() != null) {
                logger.info("Function failed: " + result.getThrowable());
                errorMessages.add(result.getThrowable().getMessage());
                continue;
            }
            successfulMembers.add(result.getMemberIdOrName());
        }
        String lineSeparator = System.getProperty("line.separator");
        if (!successfulMembers.isEmpty()) {
            StringBuilder successMessageBuilder = new StringBuilder();
            successMessageBuilder.append("Runtime configuration altered successfully for the following member(s)");
            successMessageBuilder.append(lineSeparator);
            for (String member : successfulMembers) {
                successMessageBuilder.append(member);
                successMessageBuilder.append(lineSeparator);
            }
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)runTimeDistributionConfigAttributes);
            ResultModel result = new ResultModel();
            InfoResultModel successInfo = result.addInfo("success");
            successInfo.addLine(successMessageBuilder.toString());
            XmlEntity xmlEntity = XmlEntity.builder().withType("cache").withAttributes(rumTimeCacheAttributes).build();
            InternalConfigurationPersistenceService cps = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
            if (cps == null) {
                successInfo.addLine("Cluster configuration service is not running. Configuration change is not persisted.");
            } else {
                cps.modifyXmlAndProperties(properties, xmlEntity, group);
            }
            return result;
        }
        StringBuilder errorMessageBuilder = new StringBuilder();
        errorMessageBuilder.append("Following errors occurred while altering runtime config");
        errorMessageBuilder.append(lineSeparator);
        for (String errorMessage : errorMessages) {
            errorMessageBuilder.append(errorMessage);
            errorMessageBuilder.append(lineSeparator);
        }
        return ResultModel.createError(errorMessageBuilder.toString());
    }

    public static class AlterRuntimeInterceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public ResultModel preExecution(GfshParseResult parseResult) {
            String logLevel = parseResult.getParamValueAsString("log-level");
            if (StringUtils.isNotBlank((CharSequence)logLevel) && LogLevel.getLevel(logLevel) == null) {
                return ResultModel.createError("Invalid log level: " + logLevel);
            }
            return ResultModel.createInfo("");
        }
    }
}

