/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.geode.management.internal.cli.CommandResponse;
import org.apache.geode.management.internal.cli.CommandResponseWriter;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.model.ResultModel;

public class CommandResponseBuilder {
    private static CommandResponse prepareCommandResponse(String memberName, CommandResult result) {
        GfJsonObject content = result.getContent();
        return new CommandResponse(memberName, CommandResponseBuilder.getType(result), result.getStatus().getCode(), "1/1", "__NULL__", CommandResponseBuilder.getDebugInfo(), result.getHeader(), content, result.getFooter(), result.failedToPersist(), result.getFileToDownload());
    }

    public static CommandResponse prepareCommandResponseFromJson(String jsonString) {
        GfJsonObject jsonObject;
        try {
            jsonObject = new GfJsonObject(jsonString);
        }
        catch (GfJsonException e) {
            jsonObject = GfJsonObject.getGfJsonErrorObject(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return new CommandResponse(jsonObject);
    }

    private static String getCommandResponseJson(CommandResponse commandResponse) {
        return new GfJsonObject(commandResponse).toString();
    }

    public static String createCommandResponseJson(String memberName, CommandResult result) {
        return CommandResponseBuilder.getCommandResponseJson(CommandResponseBuilder.prepareCommandResponse(memberName, result));
    }

    public static String createCommandResponseJson(String memberName, ResultModel result) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String json = mapper.writeValueAsString((Object)result);
            return json;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getType(CommandResult result) {
        return result.getType();
    }

    private static String getDebugInfo() {
        String debugInfo = "";
        if (CommandExecutionContext.isSetWrapperThreadLocal()) {
            CommandResponseWriter responseWriter = CommandExecutionContext.getCommandResponseWriter();
            debugInfo = responseWriter.getResponseWritten();
        }
        return debugInfo;
    }
}

