/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.nio.file.Path;
import java.text.DateFormat;
import java.util.Date;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.ResultData;

public class CommandResponse {
    private final String sender;
    private final String version;
    private final int status;
    private final String contentType;
    private final String page;
    private final String when;
    private final String tokenAccessor;
    private final String debugInfo;
    private final ResultData data;
    private final boolean failedToPersist;
    private final String fileToDownload;
    private final boolean isLegacy;

    CommandResponse(String sender, String contentType, int status, String page, String tokenAccessor, String debugInfo, String header, GfJsonObject content, String footer, boolean failedToPersist, Path fileToDownload) {
        this.sender = sender;
        this.contentType = contentType;
        this.status = status;
        this.page = page;
        this.tokenAccessor = tokenAccessor;
        this.debugInfo = debugInfo;
        this.data = new LegacyData(header, content, footer);
        this.when = DateFormat.getInstance().format(new Date());
        this.version = GemFireVersion.getGemFireVersion();
        this.failedToPersist = failedToPersist;
        this.fileToDownload = fileToDownload != null ? fileToDownload.toString() : null;
        this.isLegacy = true;
    }

    CommandResponse(GfJsonObject jsonObject) {
        this.sender = jsonObject.getString("sender");
        this.contentType = jsonObject.getString("contentType");
        this.status = jsonObject.getInt("status");
        this.page = jsonObject.getString("page");
        this.tokenAccessor = jsonObject.getString("tokenAccessor");
        this.debugInfo = jsonObject.getString("debugInfo");
        this.data = new LegacyData(jsonObject.getJSONObject("data"));
        this.when = jsonObject.getString("when");
        this.version = jsonObject.getString("version");
        this.failedToPersist = jsonObject.getBoolean("failedToPersist");
        this.fileToDownload = jsonObject.getString("fileToDownload");
        this.isLegacy = true;
    }

    public String getSender() {
        return this.sender;
    }

    public String getVersion() {
        return this.version;
    }

    public int getStatus() {
        return this.status;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getPage() {
        return this.page;
    }

    public String getFileToDownload() {
        return this.fileToDownload;
    }

    public String getWhen() {
        return this.when;
    }

    public String getTokenAccessor() {
        return this.tokenAccessor;
    }

    public ResultData getData() {
        return this.data;
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public boolean isFailedToPersist() {
        return this.failedToPersist;
    }

    public boolean isLegacy() {
        return this.isLegacy;
    }

    public static class LegacyData
    implements ResultData {
        private String header;
        private GfJsonObject content;
        private String footer;

        public LegacyData(String header, GfJsonObject content, String footer) {
            this.header = header;
            this.content = content;
            this.footer = footer;
        }

        public LegacyData(GfJsonObject dataJsonObject) {
            this.header = dataJsonObject.getString("header");
            this.content = dataJsonObject.getJSONObject("content");
            this.footer = dataJsonObject.getString("footer");
        }

        @Override
        public String getHeader() {
            return this.header;
        }

        @Override
        public Object getContent() {
            return this.content.getInternalJsonObject();
        }

        @Override
        public String getFooter() {
            return this.footer;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Data [header=").append(this.header).append(", content=").append(this.content).append(", footer=").append(this.footer).append("]");
            return builder.toString();
        }
    }
}

