/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.InternalQueryService;
import org.apache.geode.cache.query.internal.QueryExecutionContext;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalDataSet;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.ManagementConstants;
import org.apache.geode.management.internal.beans.BeanUtilFuncs;
import org.apache.geode.management.internal.beans.DataQueryEngine;
import org.apache.geode.management.internal.cli.json.QueryResultFormatter;
import org.apache.logging.log4j.Logger;

public class QueryDataFunction
implements Function,
InternalEntity {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogService.getLogger();
    public static final int DEFAULT_COLLECTION_ELEMENT_LIMIT = 100;
    private static final String MEMBER_KEY = "member";
    private static final String RESULT_KEY = "result";
    private static final String NO_DATA_FOUND = "No Data Found";
    private static final int DISPLAY_MEMBERWISE = 0;
    private static final int QUERY = 1;
    private static final int REGION = 2;
    private static final int LIMIT = 3;
    private static final int QUERY_RESULTSET_LIMIT = 4;
    private static final int QUERY_COLLECTIONS_DEPTH = 5;
    private static final String SELECT_EXPR = "\\s*SELECT\\s+.+\\s+FROM.+";
    private static final Pattern SELECT_EXPR_PATTERN = Pattern.compile("\\s*SELECT\\s+.+\\s+FROM.+", 2);
    private static final String SELECT_WITH_LIMIT_EXPR = "\\s*SELECT\\s+.+\\s+FROM(\\s+|(.*\\s+))LIMIT\\s+[0-9]+.*";
    private static final Pattern SELECT_WITH_LIMIT_EXPR_PATTERN = Pattern.compile("\\s*SELECT\\s+.+\\s+FROM(\\s+|(.*\\s+))LIMIT\\s+[0-9]+.*", 2);

    @Override
    public boolean hasResult() {
        return true;
    }

    public void execute(FunctionContext context) {
        Object[] functionArgs = (Object[])context.getArguments();
        boolean showMember = (Boolean)functionArgs[0];
        String queryString = (String)functionArgs[1];
        String regionName = (String)functionArgs[2];
        int limit = (Integer)functionArgs[3];
        int queryResultSetLimit = (Integer)functionArgs[4];
        int queryCollectionsDepth = (Integer)functionArgs[5];
        try {
            context.getResultSender().lastResult(this.selectWithType(context, queryString, showMember, regionName, limit, queryResultSetLimit, queryCollectionsDepth));
        }
        catch (Exception e) {
            context.getResultSender().sendException(e);
        }
    }

    @Override
    public String getId() {
        return ManagementConstants.QUERY_DATA_FUNCTION;
    }

    private byte[] selectWithType(FunctionContext context, String queryString, boolean showMember, String regionName, int limit, int queryResultSetLimit, int queryCollectionsDepth) throws Exception {
        InternalCache cache = (InternalCache)context.getCache();
        LocalQueryFunction localQueryFunc = new LocalQueryFunction("LocalQueryFunction", regionName, showMember).setOptimizeForWrite(true);
        queryString = QueryDataFunction.applyLimitClause(queryString, limit, queryResultSetLimit);
        try {
            QueryResultFormatter result = new QueryResultFormatter(queryCollectionsDepth);
            Region region = cache.getRegion(regionName);
            if (region == null) {
                throw new Exception(String.format("Cannot find region %s in member %s", regionName, cache.getDistributedSystem().getDistributedMember().getId()));
            }
            Object results = null;
            boolean noDataFound = true;
            if (region.getAttributes().getDataPolicy() == DataPolicy.NORMAL) {
                InternalQueryService queryService = cache.getQueryService();
                Query query = queryService.newQuery(queryString);
                results = query.execute();
            } else {
                PartitionedRegion parRegion = PartitionedRegionHelper.getPartitionedRegion(regionName, cache);
                if (parRegion != null && showMember) {
                    if (parRegion.isDataStore()) {
                        Set<BucketRegion> localPrimaryBucketRegions = parRegion.getDataStore().getAllLocalPrimaryBucketRegions();
                        HashSet<Integer> localPrimaryBucketSet = new HashSet<Integer>();
                        for (BucketRegion bRegion : localPrimaryBucketRegions) {
                            localPrimaryBucketSet.add(bRegion.getId());
                        }
                        LocalDataSet lds = new LocalDataSet(parRegion, localPrimaryBucketSet);
                        DefaultQuery query = (DefaultQuery)cache.getQueryService().newQuery(queryString);
                        QueryExecutionContext executionContext = new QueryExecutionContext(null, cache, query);
                        results = lds.executeQuery(query, executionContext, null, localPrimaryBucketSet);
                    }
                } else {
                    ResultCollector rcollector = FunctionService.onRegion(cache.getRegion(regionName)).setArguments(queryString).execute(localQueryFunc);
                    results = rcollector.getResult();
                }
            }
            if (results != null && results instanceof SelectResults) {
                SelectResults selectResults = (SelectResults)results;
                for (Object object : selectResults) {
                    result.add(RESULT_KEY, object);
                    noDataFound = false;
                }
            } else if (results != null && results instanceof ArrayList) {
                ArrayList listResults = (ArrayList)results;
                ArrayList actualResult = (ArrayList)listResults.get(0);
                for (Object object : actualResult) {
                    result.add(RESULT_KEY, object);
                    noDataFound = false;
                }
            }
            if (!noDataFound && showMember) {
                result.add(MEMBER_KEY, cache.getDistributedSystem().getDistributedMember().getId());
            }
            if (noDataFound) {
                return BeanUtilFuncs.compress(new DataQueryEngine.JsonisedErrorMessage(NO_DATA_FOUND).toString());
            }
            return BeanUtilFuncs.compress(result.toString());
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected static String applyLimitClause(String query, int limit, int queryResultSetLimit) {
        Matcher limit_matcher;
        boolean queryAlreadyHasLimitClause;
        Matcher matcher = SELECT_EXPR_PATTERN.matcher(query);
        if (matcher.matches() && !(queryAlreadyHasLimitClause = (limit_matcher = SELECT_WITH_LIMIT_EXPR_PATTERN.matcher(query)).matches())) {
            if (limit == 0) {
                limit = queryResultSetLimit;
            }
            String result = query;
            result = result + " LIMIT " + limit;
            return result;
        }
        return query;
    }

    private class LocalQueryFunction
    implements InternalFunction {
        private static final long serialVersionUID = 1L;
        private final String id;
        private boolean optimizeForWrite = false;
        private boolean showMembers;
        private String regionName;

        public LocalQueryFunction(String id, String regionName, boolean showMembers) {
            this.id = id;
            this.regionName = regionName;
            this.showMembers = showMembers;
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        @Override
        public boolean isHA() {
            return false;
        }

        @Override
        public boolean optimizeForWrite() {
            return this.optimizeForWrite;
        }

        public LocalQueryFunction setOptimizeForWrite(boolean optimizeForWrite) {
            this.optimizeForWrite = optimizeForWrite;
            return this;
        }

        @Override
        public void execute(FunctionContext context) {
            InternalCache cache = (InternalCache)context.getCache();
            InternalQueryService queryService = cache.getQueryService();
            String qstr = (String)context.getArguments();
            Region r = cache.getRegion(this.regionName);
            try {
                Query query = queryService.newQuery(qstr);
                if (r.getAttributes().getPartitionAttributes() != null && this.showMembers) {
                    SelectResults sr = (SelectResults)query.execute((RegionFunctionContext)context);
                    context.getResultSender().lastResult(sr.asList());
                } else {
                    SelectResults sr = (SelectResults)query.execute();
                    context.getResultSender().lastResult(sr.asList());
                }
            }
            catch (Exception e) {
                throw new FunctionException(e);
            }
        }

        @Override
        public String getId() {
            return this.id;
        }
    }
}

