/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.api;

import java.util.List;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.SSLConfig;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.management.api.ClusterManagementService;
import org.apache.geode.management.internal.JavaClientClusterManagementServiceFactory;
import org.apache.geode.management.internal.SSLUtil;
import org.apache.geode.management.internal.cli.domain.MemberInformation;
import org.apache.geode.management.internal.cli.functions.GetMemberInformationFunction;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.logging.log4j.Logger;

public class GeodeClusterManagementServiceFactory
extends JavaClientClusterManagementServiceFactory {
    @Immutable
    private static final GetMemberInformationFunction MEMBER_INFORMATION_FUNCTION = new GetMemberInformationFunction();
    private static final Logger logger = LogService.getLogger();

    public String getContext() {
        return "geode";
    }

    public ClusterManagementService create() {
        return this.create(null, null);
    }

    public ClusterManagementService create(String username, String password) {
        if (InternalLocator.getLocator() != null) {
            return InternalLocator.getLocator().getClusterManagementService();
        }
        Cache cache = CacheFactory.getAnyInstance();
        if (cache != null && cache.isServer()) {
            GemFireCacheImpl cacheImpl = (GemFireCacheImpl)cache;
            Set<InternalDistributedMember> locatorsWithClusterConfig = cacheImpl.getDistributionManager().getAllHostedLocatorsWithSharedConfiguration().keySet();
            MemberInformation memberInformation = this.getHttpServiceAddress(locatorsWithClusterConfig);
            SSLContext sslContext = null;
            NoopHostnameVerifier hostnameVerifier = null;
            if (memberInformation.isWebSSL()) {
                SSLConfig sslConfig = SSLConfigurationFactory.getSSLConfigForComponent(((GemFireCacheImpl)cache).getSystem().getConfig(), SecurableCommunicationChannel.WEB);
                if (!sslConfig.useDefaultSSLContext() && sslConfig.getTruststore() == null) {
                    throw new IllegalStateException("The server needs to have ssl-truststore or ssl-use-default-context specified in order to use cluster management service.");
                }
                sslContext = SSLUtil.createAndConfigureSSLContext(sslConfig, false);
                hostnameVerifier = new NoopHostnameVerifier();
            }
            return this.create(this.getHostName(memberInformation), memberInformation.getHttpServicePort(), sslContext, (HostnameVerifier)hostnameVerifier, username, password);
        }
        ClientCache clientCache = ClientCacheFactory.getAnyInstance();
        if (clientCache != null) {
            throw new IllegalStateException("Under construction. To retrieve an instance of ClusterManagementService from a Geode client, please use other methods");
        }
        throw new IllegalStateException("ClusterManagementService.create() must be executed on one of locator, server or client cache VMs");
    }

    private MemberInformation getHttpServiceAddress(Set<InternalDistributedMember> locators) {
        for (InternalDistributedMember locator : locators) {
            try {
                ResultCollector resultCollector = FunctionService.onMember(locator).execute(MEMBER_INFORMATION_FUNCTION);
                List memberInformations = (List)resultCollector.getResult();
                if (memberInformations.isEmpty()) continue;
                return (MemberInformation)memberInformations.get(0);
            }
            catch (FunctionException e) {
                logger.warn("Unable to execute GetMemberInformationFunction on " + locator.getId());
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalStateException("Unable to determine ClusterManagementService endpoint");
    }

    private String getHostName(MemberInformation memberInformation) {
        String host = StringUtils.isNotBlank((CharSequence)memberInformation.getHttpServiceBindAddress()) ? memberInformation.getHttpServiceBindAddress() : (StringUtils.isNotBlank((CharSequence)memberInformation.getServerBindAddress()) ? memberInformation.getServerBindAddress() : memberInformation.getHost());
        return host;
    }
}

