/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.util.Set;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AlertLevelChangeMessage;
import org.apache.geode.internal.logging.log4j.LogLevel;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.ManagerStartupMessage;

public class MemberMessenger {
    private final MBeanJMXAdapter jmxAdapter;
    private final InternalDistributedSystem system;

    MemberMessenger(MBeanJMXAdapter jmxAdapter, InternalDistributedSystem system) {
        this.jmxAdapter = jmxAdapter;
        this.system = system;
    }

    void sendManagerInfo(DistributedMember receiver) {
        String levelName = this.jmxAdapter.getDistributedSystemMXBean().getAlertLevel();
        int alertCode = LogLevel.getLogWriterLevel(levelName);
        ManagerStartupMessage msg = ManagerStartupMessage.create(alertCode);
        msg.setRecipient((InternalDistributedMember)receiver);
        this.sendAsync(msg);
    }

    void broadcastManagerInfo() {
        Set<InternalDistributedMember> otherMemberSet = this.system.getDistributionManager().getAllOtherMembers();
        String levelName = this.jmxAdapter.getDistributedSystemMXBean().getAlertLevel();
        int alertCode = LogLevel.getLogWriterLevel(levelName);
        ManagerStartupMessage msg = ManagerStartupMessage.create(alertCode);
        if (otherMemberSet != null && otherMemberSet.size() > 0) {
            msg.setRecipients(otherMemberSet);
        }
        this.sendAsync(msg);
        DistributionManager dm = this.system.getDistributionManager();
        if (dm instanceof ClusterDistributionManager) {
            msg.process((ClusterDistributionManager)this.system.getDistributionManager());
        }
    }

    private void sendAsync(DistributionMessage msg) {
        if (this.system != null) {
            this.system.getDistributionManager().putOutgoing(msg);
        }
    }

    public void setAlertLevel(String levelName) {
        int alertCode = LogLevel.getLogWriterLevel(levelName);
        AlertLevelChangeMessage m = AlertLevelChangeMessage.create(alertCode);
        this.sendAsync(m);
    }
}

