/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.alerting.AlertLevel;

public class ManagerStartupMessage
extends PooledDistributionMessage {
    private int alertLevel;

    public static ManagerStartupMessage create(int alertLevel) {
        return new ManagerStartupMessage(alertLevel);
    }

    public ManagerStartupMessage() {
    }

    private ManagerStartupMessage(int alertLevel) {
        this.alertLevel = alertLevel;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        if (this.alertLevel != Integer.MAX_VALUE) {
            dm.getAlertingService().addAlertListener(this.getSender(), AlertLevel.find(this.alertLevel));
        }
    }

    @Override
    public int getDSFID() {
        return 2149;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.alertLevel);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.alertLevel = in.readInt();
    }

    @Override
    public String toString() {
        return "ManagerStartupMessage from " + this.getSender() + " alertLevel=" + this.alertLevel;
    }
}

