/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.beans.IntrospectionException;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.ClassLoadUtil;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.MBeanProxyInfoRepository;
import org.apache.geode.management.internal.MBeanProxyInvocationHandler;
import org.apache.geode.management.internal.ProxyInfo;
import org.apache.geode.management.internal.ProxyInterface;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.logging.log4j.Logger;

public class MBeanProxyFactory {
    private static final Logger logger = LogService.getLogger();
    private MBeanProxyInfoRepository proxyRepo;
    private MBeanJMXAdapter jmxAdapter;
    private SystemManagementService service;

    public MBeanProxyFactory(MBeanJMXAdapter jmxAdapter, SystemManagementService service) {
        this.jmxAdapter = jmxAdapter;
        this.proxyRepo = new MBeanProxyInfoRepository();
        this.service = service;
    }

    public void createProxy(DistributedMember member, ObjectName objectName, Region<String, Object> monitoringRegion, Object newVal) {
        try {
            FederationComponent federationComponent = (FederationComponent)newVal;
            String interfaceClassName = federationComponent.getMBeanInterfaceClass();
            Class interfaceClass = ClassLoadUtil.classFromName(interfaceClassName);
            Object object = MBeanProxyInvocationHandler.newProxyInstance(member, monitoringRegion, objectName, federationComponent, interfaceClass);
            this.jmxAdapter.registerMBeanProxy(object, objectName);
            if (logger.isDebugEnabled()) {
                logger.debug("Registered ObjectName : {}", (Object)objectName);
            }
            ProxyInfo proxyInfo = new ProxyInfo(interfaceClass, object, objectName);
            this.proxyRepo.addProxyToRepository(member, proxyInfo);
            this.service.afterCreateProxy(objectName, interfaceClass, object, (FederationComponent)newVal);
            if (logger.isDebugEnabled()) {
                logger.debug("Proxy Created for : {}", (Object)objectName);
            }
        }
        catch (IntrospectionException | ClassNotFoundException e) {
            throw new ManagementException(e);
        }
    }

    public void createAllProxies(DistributedMember member, Region<String, Object> monitoringRegion) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating proxy for: {}", (Object)member.getId());
        }
        Set<Map.Entry<String, Object>> mbeans = monitoringRegion.entrySet();
        for (Map.Entry<String, Object> mbean : mbeans) {
            ObjectName objectName = null;
            try {
                objectName = ObjectName.getInstance(mbean.getKey());
                if (logger.isDebugEnabled()) {
                    logger.debug("Creating proxy for ObjectName: " + objectName.toString());
                }
                this.createProxy(member, objectName, monitoringRegion, mbean.getValue());
            }
            catch (Exception e) {
                logger.warn("Create Proxy failed for {} with exception {}", (Object)objectName, (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public void removeAllProxies(DistributedMember member, Region<String, Object> monitoringRegion) {
        Set<Map.Entry<String, Object>> entries = monitoringRegion.entrySet();
        if (logger.isDebugEnabled()) {
            logger.debug("Removing {} proxies for member {}", (Object)entries.size(), (Object)member.getId());
        }
        for (Map.Entry<String, Object> entry : entries) {
            String key = null;
            try {
                key = entry.getKey();
                Object val = entry.getValue();
                ObjectName mbeanName = ObjectName.getInstance(key);
                this.removeProxy(member, mbeanName, val);
            }
            catch (EntryNotFoundException entryNotFoundException) {
                this.logProxyAlreadyRemoved(member, entry);
            }
            catch (Exception e) {
                if (e.getCause() instanceof InstanceNotFoundException) continue;
                logger.warn("Remove Proxy failed for {} due to {}", (Object)key, (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public void removeProxy(DistributedMember member, ObjectName objectName, Object oldVal) {
        block5: {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing proxy for ObjectName: {}", (Object)objectName);
                }
                ProxyInfo proxyInfo = this.proxyRepo.findProxyInfo(objectName);
                this.proxyRepo.removeProxy(member, objectName);
                if (proxyInfo != null) {
                    this.service.afterRemoveProxy(objectName, proxyInfo.getProxyInterface(), proxyInfo.getProxyInstance(), (FederationComponent)oldVal);
                }
                this.jmxAdapter.unregisterMBean(objectName);
                if (logger.isDebugEnabled()) {
                    logger.debug("Removed proxy for ObjectName: {}", (Object)objectName);
                }
            }
            catch (Exception e) {
                if (e.getCause() instanceof InstanceNotFoundException) break block5;
                logger.warn("Could not remove proxy for Member {} due to {}", (Object)member, (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public void updateProxy(ObjectName objectName, ProxyInfo proxyInfo, Object newObject, Object oldObject) {
        try {
            if (proxyInfo != null) {
                Class interfaceClass = proxyInfo.getProxyInterface();
                this.service.afterUpdateProxy(objectName, interfaceClass, proxyInfo.getProxyInstance(), (FederationComponent)newObject, (FederationComponent)oldObject);
            }
        }
        catch (Exception e) {
            throw new ManagementException(e);
        }
    }

    public <T> T findProxy(ObjectName objectName, Class<T> interfaceClass) {
        return this.proxyRepo.findProxyByName(objectName, interfaceClass);
    }

    public ProxyInfo findProxyInfo(ObjectName objectName) {
        return this.proxyRepo.findProxyInfo(objectName);
    }

    public Set<ObjectName> findAllProxies(DistributedMember member) {
        return this.proxyRepo.findProxySet(member);
    }

    public long getLastUpdateTime(ObjectName objectName) {
        ProxyInterface proxyObj = this.findProxy(objectName, ProxyInterface.class);
        return proxyObj.getLastRefreshedTime();
    }

    void logProxyAlreadyRemoved(DistributedMember member, Map.Entry<String, Object> entry) {
        logger.warn("Proxy for entry {} and member {} has already been removed", entry, (Object)member.getId());
    }
}

