/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geode.CancelException;
import org.apache.geode.GemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.HasCachePerfStats;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingExecutors;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.ManagementResourceRepo;
import org.apache.geode.management.internal.Manager;
import org.apache.geode.management.internal.MonitoringRegionCacheListener;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.logging.log4j.Logger;

public class LocalManager
extends Manager {
    private static final Logger logger = LogService.getLogger();
    private ManagementTask managementTask;
    protected ScheduledExecutorService singleThreadFederationScheduler;
    private Map<ObjectName, FederationComponent> federatedComponentMap;
    private Object lock = new Object();
    private SystemManagementService service;

    public LocalManager(ManagementResourceRepo repo, InternalDistributedSystem system, SystemManagementService service, InternalCache cache) {
        super(repo, system, cache);
        this.service = service;
        this.federatedComponentMap = new ConcurrentHashMap<ObjectName, FederationComponent>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLocalManagement(Map<ObjectName, FederationComponent> federatedComponentMap) {
        LocalManager localManager = this;
        synchronized (localManager) {
            if (this.repo.getLocalMonitoringRegion() != null) {
                return;
            }
            this.singleThreadFederationScheduler = LoggingExecutors.newSingleThreadScheduledExecutor("Management Task");
            if (logger.isDebugEnabled()) {
                logger.debug("Creating  Management Region :");
            }
            InternalRegionArguments internalArgs = new InternalRegionArguments();
            internalArgs.setIsUsedForMetaRegion(true);
            HasCachePerfStats monitoringRegionStats = new HasCachePerfStats(){

                @Override
                public CachePerfStats getCachePerfStats() {
                    return new CachePerfStats(LocalManager.this.cache.getDistributedSystem(), "managementRegionStats");
                }
            };
            internalArgs.setCachePerfStatsHolder(monitoringRegionStats);
            AttributesFactory<String, Object> monitorRegionAttributeFactory = new AttributesFactory<String, Object>();
            monitorRegionAttributeFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
            monitorRegionAttributeFactory.setDataPolicy(DataPolicy.REPLICATE);
            monitorRegionAttributeFactory.setConcurrencyChecksEnabled(false);
            MonitoringRegionCacheListener localListener = new MonitoringRegionCacheListener(this.service);
            monitorRegionAttributeFactory.addCacheListener(localListener);
            RegionAttributes monitoringRegionAttrs = monitorRegionAttributeFactory.create();
            AttributesFactory notificationRegionAttributeFactory = new AttributesFactory();
            notificationRegionAttributeFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
            notificationRegionAttributeFactory.setDataPolicy(DataPolicy.EMPTY);
            notificationRegionAttributeFactory.setConcurrencyChecksEnabled(false);
            RegionAttributes notifRegionAttrs = notificationRegionAttributeFactory.create();
            String appender = MBeanJMXAdapter.getUniqueIDForMember(this.cache.getDistributedSystem().getDistributedMember());
            boolean monitoringRegionCreated = false;
            boolean notifRegionCreated = false;
            try {
                this.repo.setLocalMonitoringRegion(this.cache.createInternalRegion("_monitoringRegion_" + appender, monitoringRegionAttrs, internalArgs));
                monitoringRegionCreated = true;
            }
            catch (TimeoutException e) {
                throw new ManagementException(e);
            }
            catch (RegionExistsException e) {
                throw new ManagementException(e);
            }
            catch (IOException e) {
                throw new ManagementException(e);
            }
            catch (ClassNotFoundException e) {
                throw new ManagementException(e);
            }
            try {
                this.repo.setLocalNotificationRegion(this.cache.createInternalRegion("_notificationRegion_" + appender, notifRegionAttrs, internalArgs));
                notifRegionCreated = true;
            }
            catch (TimeoutException e) {
                throw new ManagementException(e);
            }
            catch (RegionExistsException e) {
                throw new ManagementException(e);
            }
            catch (IOException e) {
                throw new ManagementException(e);
            }
            catch (ClassNotFoundException e) {
                throw new ManagementException(e);
            }
            finally {
                if (!notifRegionCreated && monitoringRegionCreated) {
                    this.repo.getLocalMonitoringRegion().localDestroyRegion();
                }
            }
            this.managementTask = new ManagementTask(federatedComponentMap);
            this.managementTask.run();
            int updateRate = this.cache.getInternalDistributedSystem().getConfig().getJmxManagerUpdateRate();
            this.singleThreadFederationScheduler.scheduleAtFixedRate(this.managementTask, updateRate, updateRate, TimeUnit.MILLISECONDS);
            if (logger.isDebugEnabled()) {
                logger.debug("Management Region created with Name : {}", (Object)this.repo.getLocalMonitoringRegion().getName());
                logger.debug("Notification Region created with Name : {}", (Object)this.repo.getLocalNotificationRegion().getName());
            }
        }
    }

    public void markForFederation(ObjectName objName, FederationComponent fedComp) {
        this.federatedComponentMap.put(objName, fedComp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unMarkForFederation(ObjectName objName) {
        Object object = this.lock;
        synchronized (object) {
            if (this.federatedComponentMap.get(objName) != null) {
                this.federatedComponentMap.remove(objName);
            }
            if (this.repo.getLocalMonitoringRegion() != null && this.repo.getLocalMonitoringRegion().get(objName.toString()) != null) {
                this.repo.getLocalMonitoringRegion().remove(objName.toString());
            }
        }
    }

    private void shutdownTasks() {
        if (this.singleThreadFederationScheduler != null) {
            this.singleThreadFederationScheduler.shutdownNow();
        }
    }

    private void cleanUpResources() {
        if (!this.cache.isClosed() && InternalDistributedSystem.getConnectedInstance() != null) {
            if (this.repo.getLocalMonitoringRegion() != null) {
                for (String name : this.repo.getLocalMonitoringRegion().keySet()) {
                    ObjectName objName = null;
                    try {
                        objName = ObjectName.getInstance(name);
                        this.unMarkForFederation(objName);
                    }
                    catch (MalformedObjectNameException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Unable to clean MBean: {} due to {}", (Object)objName, (Object)e.getMessage(), (Object)e);
                    }
                    catch (NullPointerException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Unable to clean MBean: {} due to {}", (Object)objName, (Object)e.getMessage(), (Object)e);
                    }
                }
                this.repo.destroyLocalMonitoringRegion();
            }
            if (this.repo.getLocalNotificationRegion() != null) {
                this.repo.destroyLocalNotifRegion();
            }
        }
    }

    public ScheduledExecutorService getFederationSheduler() {
        return this.singleThreadFederationScheduler;
    }

    public void runManagementTaskAdhoc() {
        this.managementTask.run();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void startManager() {
        this.startLocalManagement(this.federatedComponentMap);
        this.running = true;
    }

    @Override
    public void stopManager() {
        this.shutdownTasks();
        this.cleanUpResources();
        this.running = false;
    }

    public void stopCacheOps() {
        this.stopCacheOps = true;
    }

    public void startCacheOps() {
        this.stopCacheOps = false;
    }

    public Map<ObjectName, FederationComponent> getFedComponents() {
        return this.federatedComponentMap;
    }

    private class ManagementTask
    implements Runnable {
        private Map<String, FederationComponent> replicaMap = new HashMap<String, FederationComponent>();

        public ManagementTask(Map<ObjectName, FederationComponent> federatedComponentMap) throws ManagementException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (logger.isTraceEnabled()) {
                logger.trace("Federation started at managed node : ");
            }
            try {
                Object object = LocalManager.this.lock;
                synchronized (object) {
                    this.replicaMap.clear();
                    Set keySet = LocalManager.this.federatedComponentMap.keySet();
                    if (keySet.size() == 0) {
                        return;
                    }
                    for (ObjectName objectName : keySet) {
                        FederationComponent fedCompInstance = (FederationComponent)LocalManager.this.federatedComponentMap.get(objectName);
                        if (Thread.interrupted()) {
                            this.replicaMap.clear();
                            return;
                        }
                        if (fedCompInstance == null) continue;
                        boolean stateChanged = fedCompInstance.refreshObjectState(LocalManager.this.service.isManager());
                        if (LocalManager.this.stopCacheOps) continue;
                        String key = objectName.toString();
                        if (!stateChanged && LocalManager.this.repo.keyExistsInLocalMonitoringRegion(key)) continue;
                        this.replicaMap.put(key, fedCompInstance);
                    }
                    if (LocalManager.this.stopCacheOps) {
                        return;
                    }
                    if (Thread.interrupted()) {
                        this.replicaMap.clear();
                        return;
                    }
                    LocalManager.this.repo.putAllInLocalMonitoringRegion(this.replicaMap);
                }
            }
            catch (CancelException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Management Task Cancelled");
                }
                return;
            }
            catch (GemFireException ex) {
                if (!LocalManager.this.cache.isClosed() && logger.isDebugEnabled()) {
                    logger.debug(ex.getMessage(), (Throwable)ex);
                }
                return;
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable th) {
                SystemFailure.checkFailure();
                throw th;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Federation completed at managed node : ");
            }
        }
    }
}

