/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLHandshakeException;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.ConflationKey;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.direct.DirectChannel;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.DSFIDFactory;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.alerting.AlertingAction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThread;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.tcp.Buffers;
import org.apache.geode.internal.tcp.ByteBufferInputStream;
import org.apache.geode.internal.tcp.ConnectionException;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.internal.tcp.DirectReplySender;
import org.apache.geode.internal.tcp.MemberShunnedException;
import org.apache.geode.internal.tcp.MsgDestreamer;
import org.apache.geode.internal.tcp.MsgOutputStream;
import org.apache.geode.internal.tcp.MsgReader;
import org.apache.geode.internal.tcp.NIOMsgReader;
import org.apache.geode.internal.tcp.OioMsgReader;
import org.apache.geode.internal.tcp.TCPConduit;
import org.apache.geode.internal.tcp.VersionedByteBufferInputStream;
import org.apache.geode.internal.util.concurrent.ReentrantSemaphore;
import org.apache.logging.log4j.Logger;

public class Connection
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    public static final String THREAD_KIND_IDENTIFIER = "P2P message reader";
    @MakeNotStatic
    private static final int INITIAL_CAPACITY = Integer.getInteger("p2p.readerBufferSize", 32768);
    @MakeNotStatic
    private static int P2P_CONNECT_TIMEOUT;
    @MakeNotStatic
    private static boolean IS_P2P_CONNECT_TIMEOUT_INITIALIZED;
    public static final int NORMAL_MSG_TYPE = 76;
    public static final int CHUNKED_MSG_TYPE = 77;
    public static final int END_CHUNKED_MSG_TYPE = 78;
    public static final int DIRECT_ACK_BIT = 32;
    public static final int MSG_HEADER_SIZE_OFFSET = 0;
    public static final int MSG_HEADER_TYPE_OFFSET = 4;
    public static final int MSG_HEADER_ID_OFFSET = 5;
    public static final int MSG_HEADER_BYTES = 7;
    public static final int SMALL_BUFFER_SIZE;
    @MakeNotStatic
    private static final AtomicLong idCounter;
    public static final String INITIATING_SUSPECT_PROCESSING = "member unexpectedly shut down shared, unordered connection";
    private final ConnectionTable owner;
    private final TCPConduit conduit;
    private volatile boolean isRunning = false;
    private boolean sharedResource;
    private SystemTimer.SystemTimerTask idleTask;
    private static final ThreadLocal isReaderThread;
    private static final boolean DOMINO_THREAD_OWNED_SOCKETS;
    private static final ThreadLocal isDominoThread;
    private final Socket socket;
    OutputStream output;
    private final Object outLock = new Object();
    String conduitIdStr;
    InternalDistributedMember remoteAddr;
    Version remoteVersion;
    private final boolean isReceiver;
    private static final ThreadLocal<Integer> dominoCount;
    private int asyncDistributionTimeout = 0;
    private int asyncQueueTimeout = 0;
    private long asyncMaxQueueSize = 0L;
    private volatile boolean asyncQueuingInProgress = false;
    private final Map conflatedKeys = new HashMap();
    private final LinkedList outgoingQueue = new LinkedList();
    private long queuedBytes = 0L;
    Thread pusherThread;
    private static final int MAX_SENDERS;
    private final Semaphore senderSem = new ReentrantSemaphore(MAX_SENDERS);
    volatile boolean handshakeRead = false;
    volatile boolean handshakeCancelled = false;
    private volatile int replyCode = 0;
    private static final byte REPLY_CODE_OK = 69;
    private static final byte REPLY_CODE_OK_WITH_ASYNC_INFO = 70;
    private final Object handshakeSync = new Object();
    private volatile Thread readerThread;
    volatile boolean stopped = true;
    private final AtomicBoolean closing = new AtomicBoolean(false);
    volatile boolean readerShuttingDown = false;
    volatile boolean connected = false;
    volatile boolean finishedConnecting = false;
    volatile boolean accessed = true;
    volatile boolean socketInUse = false;
    volatile boolean timedOut = false;
    private SystemTimer.SystemTimerTask ackTimeoutTask;
    long transmissionStartTime;
    private long ackWaitTimeout;
    private long ackSATimeout;
    List ackConnectionGroup;
    String ackThreadName;
    ByteBuffer nioInputBuffer;
    int nioMessageLength;
    byte nioMessageType;
    private final Object destreamerLock = new Object();
    MsgDestreamer idleMsgDestreamer;
    HashMap destreamerMap;
    boolean directAck;
    short nioMsgId;
    boolean nioLengthSet = false;
    boolean preserveOrder = false;
    private long messagesSent;
    private long messagesReceived;
    private volatile long uniqueId;
    private int sendBufferSize = -1;
    private int recvBufferSize = -1;
    @MakeNotStatic
    private static byte[] okHandshakeBytes;
    @MakeNotStatic
    private static ByteBuffer okHandshakeBuf;
    public static final int MAX_MSG_SIZE = 0xFFFFFF;
    private static final int HANDSHAKE_TIMEOUT_MS;
    public static final byte HANDSHAKE_VERSION = 7;
    private final AtomicBoolean asyncCloseCalled = new AtomicBoolean();
    private static final int CONNECT_HANDSHAKE_SIZE = 4096;
    private static final int RECONNECT_WAIT_TIME;
    private static final boolean BATCH_SENDS;
    private static final int BATCH_BUFFER_SIZE;
    private static final int BATCH_FLUSH_MS;
    private Object batchLock;
    private ByteBuffer fillBatchBuffer;
    private ByteBuffer sendBatchBuffer;
    private BatchBufferFlusher batchFlusher;
    private static final boolean SOCKET_WRITE_DISABLED;
    private final Object nioPusherSync = new Object();
    private boolean disconnectRequested = false;
    @MutableForTesting
    public static volatile boolean FORCE_ASYNC_QUEUE;
    private static final int MAX_WAIT_TIME = 32;
    private final Object stateLock = new Object();
    private byte connectionState = 0;
    protected static final byte STATE_IDLE = 0;
    protected static final byte STATE_SENDING = 1;
    protected static final byte STATE_POST_SENDING = 2;
    protected static final byte STATE_READING_ACK = 3;
    protected static final byte STATE_RECEIVED_ACK = 4;
    protected static final byte STATE_READING = 5;
    protected volatile boolean ackTimedOut;
    boolean nioChecked;
    boolean useNIO;

    public boolean isSharedResource() {
        return this.sharedResource;
    }

    public static void makeReaderThread() {
        Connection.makeReaderThread(true);
    }

    private static void makeReaderThread(boolean v) {
        isReaderThread.set(v);
    }

    public static boolean isReaderThread() {
        Object o = isReaderThread.get();
        if (o == null) {
            return false;
        }
        return (Boolean)o;
    }

    private int getP2PConnectTimeout() {
        if (IS_P2P_CONNECT_TIMEOUT_INITIALIZED) {
            return P2P_CONNECT_TIMEOUT;
        }
        String connectTimeoutStr = System.getProperty("p2p.connectTimeout");
        P2P_CONNECT_TIMEOUT = connectTimeoutStr != null ? Integer.parseInt(connectTimeoutStr) : 6 * this.conduit.getDM().getConfig().getMemberTimeout();
        IS_P2P_CONNECT_TIMEOUT_INITIALIZED = true;
        return P2P_CONNECT_TIMEOUT;
    }

    public static boolean tipDomino() {
        if (DOMINO_THREAD_OWNED_SOCKETS) {
            ConnectionTable.threadWantsOwnResources();
            isDominoThread.set(Boolean.TRUE);
            return true;
        }
        return false;
    }

    public static boolean isDominoThread() {
        Object o = isDominoThread.get();
        if (o == null) {
            return false;
        }
        return (Boolean)o;
    }

    private void setSendBufferSize(Socket sock) {
        this.setSendBufferSize(sock, this.owner.getConduit().tcpBufferSize);
    }

    private void setReceiveBufferSize(Socket sock) {
        this.setReceiveBufferSize(sock, this.owner.getConduit().tcpBufferSize);
    }

    private void setSendBufferSize(Socket sock, int requestedSize) {
        this.setSocketBufferSize(sock, true, requestedSize);
    }

    private void setReceiveBufferSize(Socket sock, int requestedSize) {
        this.setSocketBufferSize(sock, false, requestedSize);
    }

    public int getReceiveBufferSize() {
        return this.recvBufferSize;
    }

    private void setSocketBufferSize(Socket sock, boolean send, int requestedSize) {
        this.setSocketBufferSize(sock, send, requestedSize, false);
    }

    private void setSocketBufferSize(Socket sock, boolean send, int requestedSize, boolean alreadySetInSocket) {
        if (requestedSize > 0) {
            try {
                int currentSize;
                int n = currentSize = send ? sock.getSendBufferSize() : sock.getReceiveBufferSize();
                if (currentSize == requestedSize) {
                    if (send) {
                        this.sendBufferSize = currentSize;
                    }
                    return;
                }
                if (!alreadySetInSocket) {
                    if (send) {
                        sock.setSendBufferSize(requestedSize);
                    } else {
                        sock.setReceiveBufferSize(requestedSize);
                    }
                }
            }
            catch (SocketException currentSize) {
                // empty catch block
            }
            try {
                int actualSize;
                int n = actualSize = send ? sock.getSendBufferSize() : sock.getReceiveBufferSize();
                if (send) {
                    this.sendBufferSize = actualSize;
                } else {
                    this.recvBufferSize = actualSize;
                }
                if (actualSize < requestedSize) {
                    logger.info("Socket {} is {} instead of the requested {}.", (Object)(send ? "send buffer size" : "receive buffer size"), (Object)actualSize, (Object)requestedSize);
                } else if (actualSize > requestedSize) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Socket {} buffer size is {} instead of the requested {}", (Object)(send ? "send" : "receive"), (Object)actualSize, (Object)requestedSize);
                    }
                    if (send) {
                        this.sendBufferSize = requestedSize;
                    } else {
                        this.recvBufferSize = requestedSize;
                    }
                }
            }
            catch (SocketException ignore) {
                if (send) {
                    this.sendBufferSize = requestedSize;
                }
                this.recvBufferSize = requestedSize;
            }
        }
    }

    public int getSendBufferSize() {
        int result = this.sendBufferSize;
        if (result != -1) {
            return result;
        }
        try {
            result = this.getSocket().getSendBufferSize();
        }
        catch (SocketException ignore) {
            result = this.owner.getConduit().tcpBufferSize;
        }
        this.sendBufferSize = result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Connection createReceiver(ConnectionTable table, Socket socket) throws IOException, ConnectionException {
        Connection connection = new Connection(table, socket);
        boolean readerStarted = false;
        try {
            connection.startReader(table);
            readerStarted = true;
        }
        finally {
            if (!readerStarted) {
                connection.closeForReconnect("could not start reader thread");
            }
        }
        connection.waitForHandshake();
        connection.finishedConnecting = true;
        return connection;
    }

    protected Connection(ConnectionTable t, Socket socket) throws IOException, ConnectionException {
        if (t == null) {
            throw new IllegalArgumentException("Null ConnectionTable");
        }
        this.conduit = t.getConduit();
        this.isReceiver = true;
        this.owner = t;
        this.socket = socket;
        this.conduitIdStr = this.owner.getConduit().getSocketId().toString();
        this.handshakeRead = false;
        this.handshakeCancelled = false;
        this.connected = true;
        try {
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
            this.setSendBufferSize(socket, SMALL_BUFFER_SIZE);
            this.setReceiveBufferSize(socket);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (!this.useNIO()) {
            try {
                this.output = socket.getOutputStream();
            }
            catch (IOException io) {
                logger.fatal("Unable to get P2P connection streams", (Throwable)io);
                t.getSocketCloser().asyncClose(socket, this.remoteAddr.toString(), null);
                throw io;
            }
        }
    }

    protected void initReceiver() {
        this.startReader(this.owner);
        this.waitForHandshake();
        this.finishedConnecting = true;
    }

    void setIdleTimeoutTask(SystemTimer.SystemTimerTask task) {
        this.idleTask = task;
    }

    public boolean checkForIdleTimeout() {
        if (this.isSocketClosed()) {
            return true;
        }
        if (this.isSocketInUse() || this.sharedResource && !this.preserveOrder) {
            return false;
        }
        boolean isIdle = !this.accessed;
        this.accessed = false;
        if (isIdle) {
            this.timedOut = true;
            this.owner.getConduit().getStats().incLostLease();
            if (logger.isDebugEnabled()) {
                logger.debug("Closing idle connection {} shared={} ordered={}", (Object)this, (Object)this.sharedResource, (Object)this.preserveOrder);
            }
            try {
                this.closeForReconnect("idle connection timed out");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isIdle;
    }

    public static int calcHdrSize(int byteSize) {
        if (byteSize > 0xFFFFFF) {
            throw new IllegalStateException(String.format("tcp message exceeded max size of %s", 0xFFFFFF));
        }
        int hdrSize = byteSize;
        return hdrSize |= 0x7000000;
    }

    public static int calcMsgByteSize(int hdrSize) {
        return hdrSize & 0xFFFFFF;
    }

    public static byte calcHdrVersion(int hdrSize) throws IOException {
        byte ver = (byte)(hdrSize >> 24);
        if (ver != 7) {
            throw new IOException(String.format("Detected wrong version of GemFire product during handshake. Expected %s but found %s", new Byte(7), new Byte(ver)));
        }
        return ver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendOKHandshakeReply() throws IOException, ConnectionException {
        Object object;
        byte[] my_okHandshakeBytes = null;
        ByteBuffer my_okHandshakeBuf = null;
        if (this.isReceiver) {
            DistributionConfig cfg = this.owner.getConduit().config;
            ByteBuffer bb = this.useNIO() && TCPConduit.useDirectBuffers ? ByteBuffer.allocateDirect(128) : ByteBuffer.allocate(128);
            bb.putInt(0);
            bb.put((byte)76);
            bb.putShort((short)-1);
            bb.put((byte)70);
            bb.putInt(cfg.getAsyncDistributionTimeout());
            bb.putInt(cfg.getAsyncQueueTimeout());
            bb.putInt(cfg.getAsyncMaxQueueSize());
            Version.writeOrdinal(bb, Version.CURRENT.ordinal(), true);
            bb.putInt(0, Connection.calcHdrSize(bb.position() - 7));
            if (this.useNIO()) {
                my_okHandshakeBuf = bb;
                bb.flip();
            } else {
                my_okHandshakeBytes = new byte[bb.position()];
                bb.flip();
                bb.get(my_okHandshakeBytes);
            }
        } else {
            my_okHandshakeBuf = okHandshakeBuf;
            my_okHandshakeBytes = okHandshakeBytes;
        }
        if (this.useNIO()) {
            assert (my_okHandshakeBuf != null);
            object = my_okHandshakeBuf;
            synchronized (object) {
                my_okHandshakeBuf.position(0);
                this.nioWriteFully(this.getSocket().getChannel(), my_okHandshakeBuf, false, null);
            }
        }
        object = this.outLock;
        synchronized (object) {
            assert (my_okHandshakeBytes != null);
            this.output.write(my_okHandshakeBytes, 0, my_okHandshakeBytes.length);
            this.output.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void waitForHandshake() throws ConnectionException {
        boolean needToClose = false;
        String reason = null;
        try {
            Object object = this.handshakeSync;
            synchronized (object) {
                block26: {
                    if (!this.handshakeRead && !this.handshakeCancelled) {
                        block25: {
                            boolean bl;
                            boolean success = false;
                            reason = "unknown";
                            boolean interrupted = Thread.interrupted();
                            try {
                                long endTime = System.currentTimeMillis() + (long)HANDSHAKE_TIMEOUT_MS;
                                long msToWait = HANDSHAKE_TIMEOUT_MS;
                                while (!this.handshakeRead && !this.handshakeCancelled && msToWait > 0L) {
                                    this.handshakeSync.wait(msToWait);
                                    if (this.handshakeRead || this.handshakeCancelled) continue;
                                    msToWait = endTime - System.currentTimeMillis();
                                }
                                if (!this.handshakeRead && !this.handshakeCancelled) {
                                    String peerName;
                                    reason = "handshake timed out";
                                    if (this.remoteAddr != null) {
                                        peerName = this.remoteAddr.toString();
                                        this.owner.getDM().getMembershipManager().suspectMember(this.remoteAddr, String.format("Connection handshake with %s timed out after waiting %s milliseconds.", peerName, HANDSHAKE_TIMEOUT_MS));
                                        throw new ConnectionException(String.format("Connection handshake with %s timed out after waiting %s milliseconds.", peerName, HANDSHAKE_TIMEOUT_MS));
                                    } else {
                                        peerName = "socket " + this.socket.getRemoteSocketAddress().toString() + ":" + this.socket.getPort();
                                    }
                                    throw new ConnectionException(String.format("Connection handshake with %s timed out after waiting %s milliseconds.", peerName, HANDSHAKE_TIMEOUT_MS));
                                }
                                success = this.handshakeRead;
                                if (interrupted) {
                                    Thread.currentThread().interrupt();
                                }
                                if (!success) break block25;
                                if (!this.isReceiver) break block26;
                                if (this.owner.getConduit().getMembershipManager().addSurpriseMember(this.remoteAddr)) return;
                                bl = true;
                            }
                            catch (InterruptedException ex) {
                                block27: {
                                    boolean bl2;
                                    try {
                                        interrupted = true;
                                        this.owner.getConduit().getCancelCriterion().checkCancelInProgress(ex);
                                        reason = "interrupted";
                                        if (interrupted) {
                                            Thread.currentThread().interrupt();
                                        }
                                        if (!success) break block27;
                                        if (!this.isReceiver) break block26;
                                        if (this.owner.getConduit().getMembershipManager().addSurpriseMember(this.remoteAddr)) return;
                                        bl2 = true;
                                    }
                                    catch (Throwable throwable) {
                                        if (interrupted) {
                                            Thread.currentThread().interrupt();
                                        }
                                        if (success) {
                                            if (!this.isReceiver) throw throwable;
                                            needToClose = !this.owner.getConduit().getMembershipManager().addSurpriseMember(this.remoteAddr);
                                            if (!needToClose) throw throwable;
                                            reason = "this member is shunned";
                                            throw throwable;
                                        } else {
                                            needToClose = true;
                                        }
                                        throw throwable;
                                    }
                                    needToClose = bl2;
                                    if (needToClose) {
                                        reason = "this member is shunned";
                                    }
                                }
                                needToClose = true;
                            }
                            needToClose = bl;
                            if (needToClose) {
                                reason = "this member is shunned";
                            }
                            break block26;
                        }
                        needToClose = true;
                    }
                }
            }
            if (!needToClose) return;
        }
        catch (Throwable throwable) {
            if (!needToClose) throw throwable;
            try {
                this.requestClose(reason);
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.requestClose(reason);
            return;
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyHandshakeWaiter(boolean success) {
        Object object = this.handshakeSync;
        synchronized (object) {
            if (success) {
                this.handshakeRead = true;
            } else {
                this.handshakeCancelled = true;
            }
            this.handshakeSync.notify();
        }
    }

    private void asyncClose(boolean beingSick) {
        Socket s;
        if (beingSick) {
            this.prepareForAsyncClose();
        } else if (this.asyncCloseCalled.compareAndSet(false, true) && (s = this.socket) != null && !s.isClosed()) {
            this.prepareForAsyncClose();
            this.owner.getSocketCloser().asyncClose(s, String.valueOf(this.remoteAddr), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareForAsyncClose() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.readerThread != null && this.isRunning && !this.readerShuttingDown && (this.connectionState == 5 || this.connectionState == 3)) {
                this.readerThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAddressCompletion() {
        InternalDistributedMember myAddr;
        InternalDistributedMember internalDistributedMember = myAddr = this.owner.getConduit().getMemberId();
        synchronized (internalDistributedMember) {
            while (!this.owner.getConduit().getCancelCriterion().isCancelInProgress() && myAddr.getInetAddress() == null && myAddr.getVmViewId() < 0) {
                try {
                    myAddr.wait(100L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    this.owner.getConduit().getCancelCriterion().checkCancelInProgress(ie);
                }
            }
            Assert.assertTrue(myAddr.getDirectChannelPort() == this.owner.getConduit().getPort());
        }
    }

    private void handshakeNio() throws IOException {
        this.waitForAddressCompletion();
        InternalDistributedMember myAddr = this.owner.getConduit().getMemberId();
        MsgOutputStream connectHandshake = new MsgOutputStream(4096);
        connectHandshake.writeByte(0);
        connectHandshake.writeByte(7);
        InternalDataSerializer.invokeToData(myAddr, connectHandshake);
        connectHandshake.writeBoolean(this.sharedResource);
        connectHandshake.writeBoolean(this.preserveOrder);
        connectHandshake.writeLong(this.uniqueId);
        Version.CURRENT.writeOrdinal(connectHandshake, true);
        connectHandshake.writeInt(dominoCount.get() + 1);
        connectHandshake.setMessageHeader(76, 73, (short)-1);
        this.nioWriteFully(this.getSocket().getChannel(), connectHandshake.getContentBuffer(), false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshakeStream() throws IOException {
        this.waitForAddressCompletion();
        this.output = this.getSocket().getOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        DataOutputStream os = new DataOutputStream(baos);
        InternalDistributedMember myAddr = this.owner.getConduit().getMemberId();
        os.writeByte(0);
        os.writeByte(7);
        InternalDataSerializer.invokeToData(myAddr, os);
        os.writeBoolean(this.sharedResource);
        os.writeBoolean(this.preserveOrder);
        os.writeLong(this.uniqueId);
        Version.CURRENT.writeOrdinal(os, true);
        os.writeInt(dominoCount.get() + 1);
        os.flush();
        byte[] msg = baos.toByteArray();
        int len = Connection.calcHdrSize(msg.length);
        byte[] lenbytes = new byte[]{(byte)(len / 0x1000000 & 0xFF), (byte)(len / 65536 & 0xFF), (byte)(len / 256 & 0xFF), (byte)(len & 0xFF), 76, -1, -1};
        Object object = this.outLock;
        synchronized (object) {
            this.output.write(lenbytes, 0, lenbytes.length);
            this.output.write(msg, 0, msg.length);
            this.output.flush();
        }
    }

    private void attemptHandshake(ConnectionTable connTable) throws IOException {
        if (this.useNIO()) {
            this.handshakeNio();
        } else {
            this.handshakeStream();
        }
        this.startReader(connTable);
        this.waitForHandshake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Connection createSender(MembershipManager mgr, ConnectionTable t, boolean preserveOrder, DistributedMember remoteAddr, boolean sharedResource, long startTime, long ackTimeout, long ackSATimeout) throws IOException, DistributedSystemDisconnectedException {
        boolean warningPrinted = false;
        boolean success = false;
        boolean firstTime = true;
        Connection conn = null;
        boolean interrupted = Thread.interrupted();
        boolean severeAlertIssued = false;
        boolean suspected = false;
        long reconnectWaitTime = RECONNECT_WAIT_TIME;
        boolean connectionErrorLogged = false;
        try {
            while (!success) {
                block60: {
                    t.getConduit().getCancelCriterion().checkCancelInProgress(null);
                    long now = System.currentTimeMillis();
                    if (!severeAlertIssued && ackSATimeout > 0L && startTime + ackTimeout < now) {
                        if (startTime + ackTimeout + ackSATimeout < now) {
                            if (remoteAddr != null) {
                                logger.fatal("Unable to form a TCP/IP connection to {} in over {} seconds", (Object)remoteAddr, (Object)((ackSATimeout + ackTimeout) / 1000L));
                            }
                            severeAlertIssued = true;
                        } else if (!suspected) {
                            if (remoteAddr != null) {
                                logger.warn("Unable to form a TCP/IP connection to {} in over {} seconds", (Object)remoteAddr, (Object)(ackTimeout / 1000L));
                            }
                            mgr.suspectMember(remoteAddr, "Unable to form a TCP/IP connection in a reasonable amount of time");
                            suspected = true;
                        }
                        reconnectWaitTime = Math.min((long)RECONNECT_WAIT_TIME, ackSATimeout - (now - startTime - ackTimeout));
                        if (reconnectWaitTime <= 0L) {
                            reconnectWaitTime = RECONNECT_WAIT_TIME;
                        }
                    } else if (!suspected && startTime > 0L && ackTimeout > 0L && startTime + ackTimeout < now) {
                        mgr.suspectMember(remoteAddr, "Unable to form a TCP/IP connection in a reasonable amount of time");
                        suspected = true;
                    }
                    if (firstTime) {
                        firstTime = false;
                        if (!mgr.memberExists(remoteAddr) || mgr.isShunned(remoteAddr) || mgr.shutdownInProgress()) {
                            throw new IOException("Member " + remoteAddr + " left the system");
                        }
                    } else {
                        if (AlertingAction.isThreadAlerting()) {
                            throw new IOException("Cannot form connection to alert listener " + remoteAddr);
                        }
                        interrupted = Thread.interrupted() || interrupted;
                        try {
                            Thread.sleep(reconnectWaitTime);
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                            t.getConduit().getCancelCriterion().checkCancelInProgress(ie);
                        }
                        t.getConduit().getCancelCriterion().checkCancelInProgress(null);
                        if (Connection.giveUpOnMember(mgr, remoteAddr)) {
                            throw new IOException(String.format("Member %s left the group", remoteAddr));
                        }
                        if (!warningPrinted) {
                            warningPrinted = true;
                            logger.warn("Connection: Attempting reconnect to peer {}", (Object)remoteAddr);
                        }
                        t.getConduit().getStats().incReconnectAttempts();
                    }
                    try {
                        conn = null;
                        conn = new Connection(t, preserveOrder, remoteAddr, sharedResource);
                    }
                    catch (SSLHandshakeException se) {
                        throw se;
                    }
                    catch (IOException ioe) {
                        if (Connection.giveUpOnMember(mgr, remoteAddr)) {
                            throw ioe;
                        }
                        t.getConduit().getCancelCriterion().checkCancelInProgress(null);
                        if ("Too many open files".equals(ioe.getMessage())) {
                            t.fileDescriptorsExhausted();
                            break block60;
                        }
                        if (!connectionErrorLogged) {
                            connectionErrorLogged = true;
                            logger.info("Connection: shared={} ordered={} failed to connect to peer {} because: {}", (Object)sharedResource, (Object)preserveOrder, (Object)remoteAddr, (Object)ioe);
                        }
                    }
                    finally {
                        if (conn == null) {
                            t.getConduit().getStats().incFailedConnect();
                        }
                    }
                }
                if (conn == null) continue;
                try {
                    conn.attemptHandshake(t);
                    if (conn.isSocketClosed()) {
                        if (Connection.giveUpOnMember(mgr, remoteAddr)) {
                            throw new IOException(String.format("Member %s left the group", remoteAddr));
                        }
                        t.getConduit().getCancelCriterion().checkCancelInProgress(null);
                        continue;
                    }
                    success = true;
                }
                catch (ConnectionException e) {
                    if (Connection.giveUpOnMember(mgr, remoteAddr)) {
                        IOException ioe = new IOException("Handshake failed");
                        ioe.initCause(e);
                        throw ioe;
                    }
                    t.getConduit().getCancelCriterion().checkCancelInProgress(null);
                    logger.info("Connection: shared={} ordered={} handshake failed to connect to peer {} because: {}", (Object)sharedResource, (Object)preserveOrder, (Object)remoteAddr, (Object)e);
                }
                catch (IOException e) {
                    if (Connection.giveUpOnMember(mgr, remoteAddr)) {
                        throw e;
                    }
                    t.getConduit().getCancelCriterion().checkCancelInProgress(null);
                    logger.info("Connection: shared={} ordered={} handshake failed to connect to peer {} because: {}", (Object)sharedResource, (Object)preserveOrder, (Object)remoteAddr, (Object)e);
                    if (sharedResource || !"Too many open files".equals(e.getMessage())) continue;
                    t.fileDescriptorsExhausted();
                }
                finally {
                    if (success) continue;
                    try {
                        conn.requestClose("failed handshake");
                    }
                    catch (Exception e) {}
                    conn = null;
                }
            }
            if (warningPrinted) {
                logger.info("{}: Successfully reestablished connection to peer {}", (Object)mgr.getLocalMember(), (Object)remoteAddr);
            }
        }
        finally {
            try {
                if (!success && conn != null) {
                    conn.requestClose("failed construction");
                    conn = null;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (conn == null) {
            throw new ConnectionException(String.format("Connection: failed construction for peer %s", remoteAddr));
        }
        if (preserveOrder && BATCH_SENDS) {
            conn.createBatchSendBuffer();
        }
        conn.finishedConnecting = true;
        return conn;
    }

    private static boolean giveUpOnMember(MembershipManager mgr, DistributedMember remoteAddr) {
        return !mgr.memberExists(remoteAddr) || mgr.isShunned(remoteAddr) || mgr.shutdownInProgress();
    }

    private void setRemoteAddr(DistributedMember m) {
        this.remoteAddr = this.owner.getDM().getCanonicalId(m);
        MembershipManager mgr = this.conduit.getMembershipManager();
        mgr.addSurpriseMember(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection(ConnectionTable t, boolean preserveOrder, DistributedMember remoteID, boolean sharedResource) throws IOException, DistributedSystemDisconnectedException {
        InternalDistributedMember remoteAddr = (InternalDistributedMember)remoteID;
        if (t == null) {
            throw new IllegalArgumentException("ConnectionTable is null.");
        }
        this.conduit = t.getConduit();
        this.isReceiver = false;
        this.owner = t;
        this.sharedResource = sharedResource;
        this.preserveOrder = preserveOrder;
        this.setRemoteAddr(remoteAddr);
        this.conduitIdStr = this.owner.getConduit().getSocketId().toString();
        this.handshakeRead = false;
        this.handshakeCancelled = false;
        this.connected = true;
        this.uniqueId = idCounter.getAndIncrement();
        InetSocketAddress addr = new InetSocketAddress(remoteAddr.getInetAddress(), remoteAddr.getDirectChannelPort());
        if (this.useNIO()) {
            SocketChannel channel = SocketChannel.open();
            this.owner.addConnectingSocket(channel.socket(), addr.getAddress());
            try {
                channel.socket().setTcpNoDelay(true);
                channel.socket().setKeepAlive(SocketCreator.ENABLE_TCP_KEEP_ALIVE);
                if (!sharedResource) {
                    this.setReceiveBufferSize(channel.socket(), this.owner.getConduit().tcpBufferSize);
                } else {
                    this.setReceiveBufferSize(channel.socket(), SMALL_BUFFER_SIZE);
                }
                this.setSendBufferSize(channel.socket());
                channel.configureBlocking(true);
                int connectTime = this.getP2PConnectTimeout();
                try {
                    channel.socket().connect(addr, connectTime);
                }
                catch (NullPointerException e) {
                    ConnectException c = new ConnectException("Encountered bug #45044 - retrying");
                    c.initCause(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    throw c;
                }
                catch (CancelledKeyException | ClosedSelectorException e) {
                    ConnectException c = new ConnectException(String.format("Attempt timed out after %s milliseconds", connectTime));
                    c.initCause(e);
                    throw c;
                }
            }
            finally {
                this.owner.removeConnectingSocket(channel.socket());
            }
            this.socket = channel.socket();
        } else if (TCPConduit.useSSL) {
            int socketBufferSize = sharedResource ? SMALL_BUFFER_SIZE : this.owner.getConduit().tcpBufferSize;
            this.socket = this.owner.getConduit().getSocketCreator().connectForServer(remoteAddr.getInetAddress(), remoteAddr.getDirectChannelPort(), socketBufferSize);
            this.setSocketBufferSize(this.socket, false, socketBufferSize, true);
            this.setSendBufferSize(this.socket);
        } else {
            Socket s;
            this.socket = s = new Socket();
            s.setTcpNoDelay(true);
            s.setKeepAlive(SocketCreator.ENABLE_TCP_KEEP_ALIVE);
            this.setReceiveBufferSize(s, SMALL_BUFFER_SIZE);
            this.setSendBufferSize(s);
            s.connect(addr, 0);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Connection: connected to {} with IP address {}", (Object)remoteAddr, (Object)addr);
        }
        try {
            this.getSocket().setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    private void createBatchSendBuffer() {
        if (!this.useNIO) {
            return;
        }
        this.batchLock = new Object();
        if (TCPConduit.useDirectBuffers) {
            this.fillBatchBuffer = ByteBuffer.allocateDirect(BATCH_BUFFER_SIZE);
            this.sendBatchBuffer = ByteBuffer.allocateDirect(BATCH_BUFFER_SIZE);
        } else {
            this.fillBatchBuffer = ByteBuffer.allocate(BATCH_BUFFER_SIZE);
            this.sendBatchBuffer = ByteBuffer.allocate(BATCH_BUFFER_SIZE);
        }
        this.batchFlusher = new BatchBufferFlusher();
        this.batchFlusher.start();
    }

    public void cleanUpOnIdleTaskCancel() {
        if (this.isReceiver) {
            this.owner.removeReceiver(this);
        }
    }

    private void closeBatchBuffer() {
        if (this.batchFlusher != null) {
            this.batchFlusher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void batchSend(ByteBuffer src) throws IOException {
        if (SOCKET_WRITE_DISABLED) {
            return;
        }
        long start = DistributionStats.getStatTime();
        try {
            ByteBuffer dst = null;
            Assert.assertTrue(src.remaining() <= BATCH_BUFFER_SIZE, "Message size(" + src.remaining() + ") exceeded BATCH_BUFFER_SIZE(" + BATCH_BUFFER_SIZE + ")");
            while (true) {
                Object object = this.batchLock;
                synchronized (object) {
                    dst = this.fillBatchBuffer;
                    if (src.remaining() <= dst.remaining()) {
                        long copyStart = DistributionStats.getStatTime();
                        dst.put(src);
                        this.owner.getConduit().getStats().incBatchCopyTime(copyStart);
                        return;
                    }
                }
                this.batchFlusher.flushBuffer(dst);
            }
        }
        finally {
            this.owner.getConduit().getStats().incBatchSendTime(start);
        }
    }

    void requestClose(String reason) {
        this.close(reason, true, true, false, false);
    }

    boolean isClosing() {
        return this.closing.get();
    }

    void closePartialConnect(String reason, boolean beingSick) {
        this.close(reason, false, false, beingSick, false);
    }

    void closeForReconnect(String reason) {
        this.close(reason, true, false, false, false);
    }

    void closeOldConnection(String reason) {
        this.close(reason, true, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @SuppressWarnings(value={"TLW_TWO_LOCK_WAIT"})
    private void close(String reason, boolean cleanupEndpoint, boolean p_removeEndpoint, boolean beingSick, boolean forceRemoval) {
        block37: {
            block38: {
                block39: {
                    boolean removeEndpoint;
                    block32: {
                        block31: {
                            block36: {
                                block34: {
                                    block35: {
                                        block33: {
                                            removeEndpoint = p_removeEndpoint;
                                            boolean onlyCleanup = this.closing.getAndSet(true);
                                            if (onlyCleanup && !forceRemoval) {
                                                return;
                                            }
                                            if (onlyCleanup) break block32;
                                            Connection connection = this;
                                            // MONITORENTER : connection
                                            this.stopped = true;
                                            if (!this.connected) break block33;
                                            if (!this.asyncQueuingInProgress || this.pusherThread == Thread.currentThread()) break block34;
                                            LinkedList linkedList = this.outgoingQueue;
                                            // MONITORENTER : linkedList
                                            break block35;
                                        }
                                        if (!forceRemoval) {
                                            removeEndpoint = false;
                                        }
                                        break block36;
                                    }
                                    while (this.asyncQueuingInProgress) {
                                        boolean interrupted = Thread.interrupted();
                                        try {
                                            this.outgoingQueue.wait();
                                        }
                                        catch (InterruptedException ie) {
                                            interrupted = true;
                                        }
                                        finally {
                                            if (!interrupted) continue;
                                            Thread.currentThread().interrupt();
                                        }
                                    }
                                    // MONITOREXIT : linkedList
                                }
                                this.connected = false;
                                this.closeSenderSem();
                                DMStats stats = this.owner.getConduit().getStats();
                                if (this.finishedConnecting) {
                                    if (this.isReceiver) {
                                        stats.decReceivers();
                                    } else {
                                        stats.decSenders(this.sharedResource, this.preserveOrder);
                                    }
                                }
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Closing socket for {}", (Object)this);
                                }
                            }
                            this.asyncClose(false);
                            this.nioLengthSet = false;
                            // MONITOREXIT : connection
                            this.notifyHandshakeWaiter(false);
                            boolean isIBM = false;
                            if (this.conduit.config.getEnableNetworkPartitionDetection() || this.conduit.getMemberId().getVmKind() == 12 || this.conduit.getMemberId().getVmKind() == 11) {
                                isIBM = "IBM Corporation".equals(System.getProperty("java.vm.vendor"));
                            }
                            Thread readerThreadSnapshot = this.readerThread;
                            if (!beingSick && readerThreadSnapshot != null && !isIBM && this.isRunning && !this.readerShuttingDown && readerThreadSnapshot != Thread.currentThread()) {
                                try {
                                    readerThreadSnapshot.join(500L);
                                    readerThreadSnapshot = this.readerThread;
                                    if (!this.isRunning || this.readerShuttingDown || readerThreadSnapshot == null || this.owner.getDM().getRootCause() != null) break block31;
                                    readerThreadSnapshot.join(1500L);
                                    if (this.isRunning) {
                                        logger.info("Timed out waiting for readerThread on {} to finish.", (Object)this);
                                    }
                                }
                                catch (IllegalThreadStateException interrupted) {
                                }
                                catch (InterruptedException ignore) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                        this.closeBatchBuffer();
                        this.closeAllMsgDestreamers();
                    }
                    if (!cleanupEndpoint) break block37;
                    if (this.isReceiver) {
                        this.owner.removeReceiver(this);
                    }
                    if (!removeEndpoint) break block38;
                    if (!this.sharedResource) break block39;
                    if (!this.preserveOrder) {
                        if (!this.isReceiver && this.finishedConnecting) {
                            this.owner.removeEndpoint(this.remoteAddr, reason);
                        }
                        break block37;
                    } else {
                        this.owner.removeSharedConnection(reason, this.remoteAddr, this.preserveOrder, this);
                    }
                    break block37;
                }
                if (!this.isReceiver) {
                    this.owner.removeThreadConnection(this.remoteAddr, this);
                }
                break block37;
            }
            if (this.sharedResource) {
                this.owner.removeSharedConnection(reason, this.remoteAddr, this.preserveOrder, this);
            } else if (!this.isReceiver) {
                this.owner.removeThreadConnection(this.remoteAddr, this);
            }
        }
        if (this.idleTask != null) {
            this.idleTask.cancel();
        }
        if (this.ackTimeoutTask == null) return;
        this.ackTimeoutTask.cancel();
    }

    private void startReader(ConnectionTable connTable) {
        Assert.assertTrue(!this.isRunning);
        this.stopped = false;
        this.isRunning = true;
        connTable.executeCommand(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.readerThread = Thread.currentThread();
        this.readerThread.setName(this.p2pReaderName());
        ConnectionTable.threadWantsSharedResources();
        Connection.makeReaderThread(this.isReceiver);
        try {
            if (this.useNIO()) {
                this.runNioReader();
            } else {
                this.runOioReader();
            }
        }
        finally {
            ByteBuffer tmp;
            if (logger.isDebugEnabled()) {
                logger.debug("Stopping {} for {}", (Object)this.p2pReaderName(), (Object)this.remoteAddr);
            }
            this.initiateSuspicionIfSharedUnordered();
            if (this.isReceiver) {
                if (!this.sharedResource) {
                    this.conduit.getStats().incThreadOwnedReceivers(-1L, dominoCount.get());
                }
                this.asyncClose(false);
                this.owner.removeAndCloseThreadOwnedSockets();
            }
            if ((tmp = this.nioInputBuffer) != null) {
                this.nioInputBuffer = null;
                DMStats stats = this.owner.getConduit().getStats();
                Buffers.releaseReceiveBuffer(tmp, stats);
            }
            this.notifyHandshakeWaiter(false);
            this.readerThread.setName("unused p2p reader");
            Object object = this.stateLock;
            synchronized (object) {
                this.isRunning = false;
                this.readerThread = null;
            }
        }
    }

    private String p2pReaderName() {
        StringBuilder sb = new StringBuilder(64);
        if (this.isReceiver) {
            sb.append("P2P message reader@");
        } else {
            sb.append("P2P handshake reader@");
        }
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        if (!this.isReceiver) {
            sb.append('-').append(this.getUniqueId());
        }
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    private void runNioReader() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [61[UNCONDITIONALDOLOOP]], but top level block is 12[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initiateSuspicionIfSharedUnordered() {
        if (this.isReceiver && this.handshakeRead && !this.preserveOrder && this.sharedResource && !this.owner.getConduit().getCancelCriterion().isCancelInProgress()) {
            this.owner.getDM().getMembershipManager().suspectMember(this.getRemoteAddress(), INITIATING_SUSPECT_PROCESSING);
        }
    }

    public static boolean isIgnorableIOException(Exception e) {
        if (e instanceof ClosedChannelException) {
            return true;
        }
        String msg = e.getMessage();
        if (msg == null) {
            msg = e.toString();
        }
        return (msg = msg.toLowerCase()).contains("forcibly closed") || msg.contains("reset by peer") || msg.contains("connection reset");
    }

    private static boolean validMsgType(int msgType) {
        return msgType == 76 || msgType == 77 || msgType == 78;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllMsgDestreamers() {
        Object object = this.destreamerLock;
        synchronized (object) {
            if (this.idleMsgDestreamer != null) {
                this.idleMsgDestreamer.close();
                this.idleMsgDestreamer = null;
            }
            if (this.destreamerMap != null) {
                for (MsgDestreamer md : this.destreamerMap.values()) {
                    md.close();
                }
                this.destreamerMap = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MsgDestreamer obtainMsgDestreamer(short msgId, Version v) {
        Object object = this.destreamerLock;
        synchronized (object) {
            Short key;
            MsgDestreamer result;
            if (this.destreamerMap == null) {
                this.destreamerMap = new HashMap();
            }
            if ((result = (MsgDestreamer)this.destreamerMap.get(key = new Short(msgId))) == null) {
                result = this.idleMsgDestreamer;
                if (result != null) {
                    this.idleMsgDestreamer = null;
                } else {
                    result = new MsgDestreamer(this.owner.getConduit().getStats(), this.conduit.getCancelCriterion(), v);
                }
                result.setName(this.p2pReaderName() + " msgId=" + msgId);
                this.destreamerMap.put(key, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseMsgDestreamer(short msgId, MsgDestreamer md) {
        Short key = new Short(msgId);
        Object object = this.destreamerLock;
        synchronized (object) {
            this.destreamerMap.remove(key);
            if (this.idleMsgDestreamer == null) {
                md.reset();
                this.idleMsgDestreamer = md;
            } else {
                md.close();
            }
        }
    }

    private void sendFailureReply(int rpId, String exMsg, Throwable ex, boolean directAck) {
        ReplySender dm = null;
        if (directAck) {
            dm = new DirectReplySender(this);
        } else if (rpId != 0) {
            dm = this.owner.getDM();
        }
        if (dm != null) {
            ReplyMessage.send(this.getRemoteAddress(), rpId, new ReplyException(exMsg, ex), dm);
        }
    }

    /*
     * Exception decompiling
     */
    private void runOioReader() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"DE_MIGHT_IGNORE"})
    int readFully(InputStream input, byte[] buffer, int len) throws IOException {
        int bytesSoFar = 0;
        while (bytesSoFar < len) {
            Object object;
            this.owner.getConduit().getCancelCriterion().checkCancelInProgress(null);
            try {
                object = this.stateLock;
                synchronized (object) {
                    this.connectionState = (byte)5;
                }
                int bytesThisTime = input.read(buffer, bytesSoFar, len - bytesSoFar);
                if (bytesThisTime < 0) {
                    this.readerShuttingDown = true;
                    try {
                        this.requestClose("Stream read returned non-positive length");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int n = -1;
                    return n;
                }
                bytesSoFar += bytesThisTime;
            }
            catch (InterruptedIOException io) {
                this.readerShuttingDown = true;
                try {
                    this.requestClose("Current thread interrupted");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Thread.currentThread().interrupt();
                this.owner.getConduit().getCancelCriterion().checkCancelInProgress(null);
            }
            finally {
                object = this.stateLock;
                synchronized (object) {
                    this.connectionState = 0;
                }
            }
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPreserialized(ByteBuffer buffer, boolean cacheContentChanges, DistributionMessage msg) throws IOException, ConnectionException {
        if (!this.connected) {
            throw new ConnectionException(String.format("Not connected to %s", this.remoteAddr));
        }
        if (this.batchFlusher != null) {
            this.batchSend(buffer);
            return;
        }
        boolean origSocketInUse = this.socketInUse;
        int originalState = -1;
        Object object = this.stateLock;
        synchronized (object) {
            originalState = this.connectionState;
            this.connectionState = 1;
        }
        this.socketInUse = true;
        try {
            if (this.useNIO()) {
                SocketChannel channel = this.getSocket().getChannel();
                this.nioWriteFully(channel, buffer, false, msg);
            } else if (buffer.hasArray()) {
                this.output.write(buffer.array(), buffer.arrayOffset(), buffer.limit() - buffer.position());
            } else {
                byte[] bytesToWrite = Connection.getBytesToWrite(buffer);
                Object object2 = this.outLock;
                synchronized (object2) {
                    this.output.write(bytesToWrite);
                    this.output.flush();
                }
            }
            if (cacheContentChanges) {
                ++this.messagesSent;
            }
        }
        finally {
            this.accessed();
            this.socketInUse = origSocketInUse;
            object = this.stateLock;
            synchronized (object) {
                this.connectionState = (byte)originalState;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setInUse(boolean use, long startTime, long ackWaitThreshold, long ackSAThreshold, List connectionGroup) {
        boolean origSocketInUse = this.socketInUse;
        Connection connection = this;
        synchronized (connection) {
            if (use && (ackWaitThreshold > 0L || ackSAThreshold > 0L)) {
                this.transmissionStartTime = startTime;
                this.ackWaitTimeout = ackWaitThreshold;
                this.ackSATimeout = ackSAThreshold;
                this.ackConnectionGroup = connectionGroup;
                this.ackThreadName = Thread.currentThread().getName();
            } else {
                this.ackWaitTimeout = 0L;
                this.ackSATimeout = 0L;
                this.ackConnectionGroup = null;
                this.ackThreadName = null;
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.connectionState = 0;
            }
            this.socketInUse = use;
        }
        if (!use) {
            this.accessed();
        }
        return origSocketInUse;
    }

    protected void setSharedUnorderedForTest() {
        this.preserveOrder = false;
        this.sharedResource = true;
        this.handshakeRead = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scheduleAckTimeouts() {
        if (this.ackTimeoutTask == null) {
            long msAW = (long)this.owner.getDM().getConfig().getAckWaitThreshold() * 1000L;
            long msSA = (long)this.owner.getDM().getConfig().getAckSevereAlertThreshold() * 1000L;
            this.ackTimeoutTask = new SystemTimer.SystemTimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run2() {
                    if (Connection.this.owner.isClosed()) {
                        return;
                    }
                    int connState = -1;
                    Object object = Connection.this.stateLock;
                    synchronized (object) {
                        connState = Connection.this.connectionState;
                    }
                    boolean sentAlert = false;
                    Connection connection = Connection.this;
                    synchronized (connection) {
                        if (Connection.this.socketInUse) {
                            switch (connState) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    sentAlert = Connection.this.doSevereAlertProcessing();
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                                case 3: {
                                    sentAlert = Connection.this.doSevereAlertProcessing();
                                    break;
                                }
                                case 4: {
                                    break;
                                }
                            }
                        }
                    }
                    List group = Connection.this.ackConnectionGroup;
                    if (sentAlert && group != null) {
                        for (Connection con : group) {
                            if (con == Connection.this) continue;
                            con.transmissionStartTime += con.ackSATimeout;
                        }
                    }
                }
            };
            ConnectionTable connectionTable = this.owner;
            synchronized (connectionTable) {
                SystemTimer timer = this.owner.getIdleConnTimer();
                if (timer != null) {
                    if (msSA > 0L) {
                        timer.scheduleAtFixedRate(this.ackTimeoutTask, msAW, Math.min(msAW, msSA));
                    } else {
                        timer.schedule(this.ackTimeoutTask, msAW);
                    }
                }
            }
        }
    }

    protected boolean doSevereAlertProcessing() {
        long now = System.currentTimeMillis();
        if (this.ackSATimeout > 0L && this.transmissionStartTime + this.ackWaitTimeout + this.ackSATimeout <= now) {
            logger.fatal("{} seconds have elapsed waiting for a response from {} for thread {}", (Object)((this.ackWaitTimeout + this.ackSATimeout) / 1000L), (Object)this.getRemoteAddress(), (Object)this.ackThreadName);
            this.ackSATimeout = 0L;
            return true;
        }
        if (!this.ackTimedOut && 0L < this.ackWaitTimeout && this.transmissionStartTime + this.ackWaitTimeout <= now) {
            String state;
            logger.warn("{} seconds have elapsed waiting for a response from {} for thread {}", (Object)(this.ackWaitTimeout / 1000L), (Object)this.getRemoteAddress(), (Object)this.ackThreadName);
            this.ackTimedOut = true;
            String string = state = this.connectionState == 1 ? "Sender has been unable to transmit a message within ack-wait-threshold seconds" : "Sender has been unable to receive a response to a message within ack-wait-threshold seconds";
            if (this.ackSATimeout > 0L) {
                this.owner.getDM().getMembershipManager().suspectMembers(Collections.singleton(this.getRemoteAddress()), state);
            }
        }
        return false;
    }

    private static byte[] getBytesToWrite(ByteBuffer buffer) {
        byte[] bytesToWrite = new byte[buffer.limit()];
        buffer.get(bytesToWrite);
        return bytesToWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean addToQueue(ByteBuffer buffer, DistributionMessage msg, boolean force) throws ConnectionException {
        long newQueueSize;
        boolean didConflation;
        int origBufferPos;
        int newBytes;
        Object objToQueue;
        long start;
        DMStats stats;
        block15: {
            ConflationKey ck;
            block16: {
                block17: {
                    ByteBuffer oldBuffer;
                    block18: {
                        stats = this.owner.getConduit().getStats();
                        start = DistributionStats.getStatTime();
                        try {
                            ck = null;
                            if (msg != null) {
                                ck = msg.getConflationKey();
                            }
                            objToQueue = null;
                            newBytes = buffer.remaining();
                            origBufferPos = buffer.position();
                            if (ck == null || !ck.allowsConflation()) {
                                ByteBuffer newbb = ByteBuffer.allocate(newBytes);
                                newbb.put(buffer);
                                newbb.flip();
                                objToQueue = newbb;
                            }
                            LinkedList linkedList = this.outgoingQueue;
                            // MONITORENTER : linkedList
                            if (this.disconnectRequested) {
                                buffer.position(origBufferPos);
                                throw new ConnectionException(String.format("Forced disconnect sent to %s", this.remoteAddr));
                            }
                            if (!force && !this.asyncQueuingInProgress) {
                                buffer.position(origBufferPos);
                                boolean bl = false;
                                // MONITOREXIT : linkedList
                                if (!DistributionStats.enableClockStats) return bl;
                                stats.incAsyncQueueAddTime(DistributionStats.getStatTime() - start);
                                return bl;
                            }
                            didConflation = false;
                            if (ck == null) break block15;
                            if (!ck.allowsConflation()) break block16;
                            objToQueue = ck;
                            ConflationKey oldValue = this.conflatedKeys.put(ck, ck);
                            if (oldValue == null) break block17;
                            ConflationKey oldck = oldValue;
                            oldBuffer = oldck.getBuffer();
                            oldck.setBuffer(null);
                            if (this.outgoingQueue.getLast() != oldck) break block18;
                            this.outgoingQueue.removeLast();
                        }
                        catch (Throwable throwable) {
                            if (!DistributionStats.enableClockStats) throw throwable;
                            stats.incAsyncQueueAddTime(DistributionStats.getStatTime() - start);
                            throw throwable;
                        }
                    }
                    int oldBytes = oldBuffer.remaining();
                    this.queuedBytes -= (long)oldBytes;
                    stats.incAsyncQueueSize(-oldBytes);
                    stats.incAsyncConflatedMsgs();
                    didConflation = true;
                    if (oldBuffer.capacity() >= newBytes) {
                        oldBuffer.clear();
                        oldBuffer.put(buffer);
                        oldBuffer.flip();
                        ck.setBuffer(oldBuffer);
                        break block15;
                    } else {
                        oldBuffer = null;
                        ByteBuffer newbb = ByteBuffer.allocate(newBytes);
                        newbb.put(buffer);
                        newbb.flip();
                        ck.setBuffer(newbb);
                    }
                    break block15;
                }
                ByteBuffer newbb = ByteBuffer.allocate(newBytes);
                newbb.put(buffer);
                newbb.flip();
                ck.setBuffer(newbb);
                break block15;
            }
            this.conflatedKeys.remove(ck);
        }
        if ((newQueueSize = (long)newBytes + this.queuedBytes) > this.asyncMaxQueueSize) {
            logger.warn("Queued bytes {} exceeds max of {}, asking slow receiver {} to disconnect.", (Object)newQueueSize, (Object)this.asyncMaxQueueSize, (Object)this.remoteAddr);
            stats.incAsyncQueueSizeExceeded(1);
            this.disconnectSlowReceiver();
            buffer.position(origBufferPos);
            boolean bl = false;
            // MONITOREXIT : linkedList
            if (!DistributionStats.enableClockStats) return bl;
            stats.incAsyncQueueAddTime(DistributionStats.getStatTime() - start);
            return bl;
        }
        this.outgoingQueue.addLast(objToQueue);
        this.queuedBytes += (long)newBytes;
        stats.incAsyncQueueSize(newBytes);
        if (!didConflation) {
            stats.incAsyncQueuedMsgs();
        }
        boolean bl = true;
        // MONITOREXIT : linkedList
        if (!DistributionStats.enableClockStats) return bl;
        stats.incAsyncQueueAddTime(DistributionStats.getStatTime() - start);
        return bl;
    }

    private boolean handleBlockedWrite(ByteBuffer buffer, DistributionMessage msg) throws ConnectionException {
        if (!this.addToQueue(buffer, msg, true)) {
            return false;
        }
        this.startNioPusher();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startNioPusher() {
        Object object = this.nioPusherSync;
        synchronized (object) {
            while (true) {
                if (this.pusherThread == null) {
                    this.asyncQueuingInProgress = true;
                    this.pusherThread = new LoggingThread("P2P async pusher to " + this.remoteAddr, this::runNioPusher);
                    // MONITOREXIT @DISABLED, blocks:[3, 7, 8] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.pusherThread.start();
                    return;
                }
                boolean interrupted = Thread.interrupted();
                try {
                    this.nioPusherSync.wait();
                    continue;
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    this.owner.getConduit().getCancelCriterion().checkCancelInProgress(ex);
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer takeFromOutgoingQueue() throws InterruptedException {
        ByteBuffer result = null;
        DMStats stats = this.owner.getConduit().getStats();
        long start = DistributionStats.getStatTime();
        try {
            LinkedList linkedList = this.outgoingQueue;
            synchronized (linkedList) {
                Object o;
                block11: {
                    if (!this.disconnectRequested) break block11;
                    this.asyncQueuingInProgress = false;
                    this.outgoingQueue.notifyAll();
                    ByteBuffer byteBuffer = null;
                    return byteBuffer;
                }
                while (!this.outgoingQueue.isEmpty() && (o = this.outgoingQueue.removeFirst()) != null) {
                    block13: {
                        block14: {
                            block12: {
                                if (!(o instanceof ConflationKey)) break block12;
                                result = ((ConflationKey)o).getBuffer();
                                if (result == null) break block13;
                                this.conflatedKeys.remove(o);
                                break block14;
                            }
                            result = (ByteBuffer)o;
                        }
                        int newBytes = result.remaining();
                        this.queuedBytes -= (long)newBytes;
                        stats.incAsyncQueueSize(-newBytes);
                        stats.incAsyncDequeuedMsgs();
                    }
                    if (result == null) continue;
                }
                if (result == null) {
                    this.asyncQueuingInProgress = false;
                    this.outgoingQueue.notifyAll();
                }
            }
            linkedList = result;
            return linkedList;
        }
        finally {
            if (DistributionStats.enableClockStats) {
                stats.incAsyncQueueRemoveTime(DistributionStats.getStatTime() - start);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectSlowReceiver() {
        LinkedList linkedList = this.outgoingQueue;
        synchronized (linkedList) {
            if (this.disconnectRequested) {
                return;
            }
            this.disconnectRequested = true;
        }
        DistributionManager dm = this.owner.getDM();
        if (dm == null) {
            this.owner.removeEndpoint(this.remoteAddr, "no distribution manager");
            return;
        }
        dm.getMembershipManager().requestMemberRemoval(this.remoteAddr, "Disconnected as a slow-receiver");
        int FORCE_TIMEOUT = 3000;
        while (dm.getOtherDistributionManagerIds().contains(this.remoteAddr)) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                this.owner.getConduit().getCancelCriterion().checkCancelInProgress(ie);
                return;
            }
        }
        this.owner.removeEndpoint(this.remoteAddr, "Force disconnect timed out");
        if (dm.getOtherDistributionManagerIds().contains(this.remoteAddr)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Force disconnect timed out after waiting {} seconds", (Object)3);
            }
            return;
        }
    }

    /*
     * Exception decompiling
     */
    protected void runNioPusher() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 4[TRYBLOCK], 1[TRYBLOCK]], but top level block is 72[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean useSyncWrites(boolean forceAsync) {
        if (forceAsync) {
            return false;
        }
        if (this.asyncQueuingInProgress) {
            return true;
        }
        if (this.isReceiver) {
            return true;
        }
        if (!this.preserveOrder) {
            return true;
        }
        return this.asyncDistributionTimeout == 0;
    }

    /*
     * Exception decompiling
     */
    private void writeAsync(SocketChannel channel, ByteBuffer buffer, boolean forceAsync, DistributionMessage p_msg, DMStats stats) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nioWriteFully(SocketChannel channel, ByteBuffer buffer, boolean forceAsync, DistributionMessage msg) throws IOException, ConnectionException {
        DMStats stats = this.owner.getConduit().getStats();
        if (!this.sharedResource) {
            stats.incTOSentMsg();
        }
        if (this.useSyncWrites(forceAsync)) {
            if (this.asyncQueuingInProgress && this.addToQueue(buffer, msg, false)) {
                return;
            }
            long startLock = stats.startSocketLock();
            Object object = this.outLock;
            synchronized (object) {
                stats.endSocketLock(startLock);
                if (this.asyncQueuingInProgress && this.addToQueue(buffer, msg, false)) {
                    return;
                }
                do {
                    int amtWritten = 0;
                    long start = stats.startSocketWrite(true);
                    try {
                        amtWritten = channel.write(buffer);
                    }
                    finally {
                        stats.endSocketWrite(true, start, amtWritten, 0);
                    }
                } while (buffer.remaining() > 0);
            }
        } else {
            this.writeAsync(channel, buffer, forceAsync, msg, stats);
        }
    }

    protected ByteBuffer getNIOBuffer() {
        DMStats stats = this.owner.getConduit().getStats();
        if (this.nioInputBuffer == null) {
            int allocSize = this.recvBufferSize;
            if (allocSize == -1) {
                allocSize = this.owner.getConduit().tcpBufferSize;
            }
            this.nioInputBuffer = Buffers.acquireReceiveBuffer(allocSize, stats);
        }
        return this.nioInputBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAck(int msToWait, long msInterval, DirectReplyProcessor processor) throws SocketTimeoutException, ConnectionException {
        if (this.isSocketClosed()) {
            throw new ConnectionException("connection is closed");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.connectionState = (byte)3;
        }
        boolean origSocketInUse = this.socketInUse;
        this.socketInUse = true;
        MsgReader msgReader = null;
        DMStats stats = this.owner.getConduit().getStats();
        Version version = this.getRemoteVersion();
        try {
            int len;
            msgReader = this.useNIO() ? new NIOMsgReader(this, version) : new OioMsgReader(this, version);
            MsgReader.Header header = msgReader.readHeader();
            ReplyMessage msg = null;
            if (header.getNioMessageType() == 76) {
                msg = (ReplyMessage)msgReader.readMessage(header);
                len = header.getNioMessageLength();
            } else {
                MsgDestreamer destreamer = this.obtainMsgDestreamer(header.getNioMessageId(), version);
                while (header.getNioMessageType() == 77) {
                    msgReader.readChunk(header, destreamer);
                    header = msgReader.readHeader();
                }
                msgReader.readChunk(header, destreamer);
                msg = (ReplyMessage)destreamer.getMessage();
                this.releaseMsgDestreamer(header.getNioMessageId(), destreamer);
                len = destreamer.size();
            }
            ClusterDistributionManager dm = (ClusterDistributionManager)this.owner.getDM();
            msg.setBytesRead(len);
            msg.setSender(this.remoteAddr);
            stats.incReceivedMessages(1L);
            stats.incReceivedBytes(msg.getBytesRead());
            stats.incMessageChannelTime(msg.resetTimestamp());
            msg.process(dm, processor);
        }
        catch (MemberShunnedException header) {
        }
        catch (SocketTimeoutException timeout) {
            throw timeout;
        }
        catch (IOException e) {
            String err = String.format("ack read io exception for %s", this);
            if (!this.isSocketClosed() && logger.isDebugEnabled() && !Connection.isIgnorableIOException(e)) {
                logger.debug(err, (Throwable)e);
            }
            try {
                this.requestClose(err + ": " + e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ConnectionException(String.format("Unable to read direct ack because: %s", e));
        }
        catch (ConnectionException e) {
            this.owner.getConduit().getCancelCriterion().checkCancelInProgress(e);
            throw e;
        }
        catch (Exception e) {
            this.owner.getConduit().getCancelCriterion().checkCancelInProgress(e);
            if (!this.isSocketClosed()) {
                logger.fatal("ack read exception", (Throwable)e);
            }
            try {
                this.requestClose(String.format("ack read exception: %s", e));
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ConnectionException(String.format("Unable to read direct ack because: %s", e));
        }
        finally {
            stats.incProcessedMessages(1L);
            this.accessed();
            this.socketInUse = origSocketInUse;
            if (this.ackTimedOut) {
                logger.info("Finished waiting for reply from {}", (Object)this.getRemoteAddress());
                this.ackTimedOut = false;
            }
            if (msgReader != null) {
                msgReader.close();
            }
        }
        Object object2 = this.stateLock;
        synchronized (object2) {
            this.connectionState = (byte)4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void processNIOBuffer() throws ConnectionException, IOException {
        if (this.nioInputBuffer != null) {
            this.nioInputBuffer.flip();
        }
        done = false;
        while (!done && this.connected) {
            block80: {
                block81: {
                    block83: {
                        block84: {
                            block82: {
                                this.owner.getConduit().getCancelCriterion().checkCancelInProgress(null);
                                remaining = this.nioInputBuffer.remaining();
                                if (!this.nioLengthSet && remaining < 7) break block80;
                                if (!this.nioLengthSet) {
                                    headerStartPos = this.nioInputBuffer.position();
                                    this.nioMessageLength = this.nioInputBuffer.getInt();
                                    Connection.calcHdrVersion(this.nioMessageLength);
                                    this.nioMessageLength = Connection.calcMsgByteSize(this.nioMessageLength);
                                    this.nioMessageType = this.nioInputBuffer.get();
                                    this.nioMsgId = this.nioInputBuffer.getShort();
                                    v0 = this.directAck = (this.nioMessageType & 32) != 0;
                                    if (this.directAck) {
                                        this.nioMessageType = (byte)(this.nioMessageType & -33);
                                    }
                                    if (!Connection.validMsgType(this.nioMessageType)) {
                                        nioMessageTypeInteger = this.nioMessageType;
                                        Connection.logger.fatal("Unknown P2P message type: {}", (Object)nioMessageTypeInteger);
                                        this.readerShuttingDown = true;
                                        this.requestClose(String.format("Unknown P2P message type: %s", new Object[]{nioMessageTypeInteger}));
                                        break;
                                    }
                                    this.nioLengthSet = true;
                                    this.nioInputBuffer.position(headerStartPos);
                                }
                                if (remaining < this.nioMessageLength + 7) break block81;
                                this.nioLengthSet = false;
                                this.nioInputBuffer.position(this.nioInputBuffer.position() + 7);
                                startPos = this.nioInputBuffer.position();
                                oldLimit = this.nioInputBuffer.limit();
                                this.nioInputBuffer.limit(startPos + this.nioMessageLength);
                                if (!this.handshakeRead) break block82;
                                if (this.nioMessageType == 76) {
                                    this.owner.getConduit().getStats().incMessagesBeingReceived(true, this.nioMessageLength);
                                    bbis = this.remoteVersion == null ? new ByteBufferInputStream(this.nioInputBuffer) : new VersionedByteBufferInputStream(this.nioInputBuffer, this.remoteVersion);
                                    msg = null;
                                    try {
                                        ReplyProcessor21.initMessageRPId();
                                        startSer = this.owner.getConduit().getStats().startMsgDeserialization();
                                        msg = (DistributionMessage)InternalDataSerializer.readDSFID(bbis);
                                        this.owner.getConduit().getStats().endMsgDeserialization(startSer);
                                        if (bbis.available() != 0) {
                                            Connection.logger.warn("Message deserialization of {} did not read {} bytes.", (Object)msg, (Object)bbis.available());
                                        }
                                        try {
                                            if (this.dispatchMessage(msg, this.nioMessageLength, this.directAck)) ** GOTO lbl277
                                            this.directAck = false;
                                        }
                                        catch (MemberShunnedException e) {
                                            this.directAck = false;
                                        }
                                        catch (Exception de) {
                                            this.owner.getConduit().getCancelCriterion().checkCancelInProgress(de);
                                            Connection.logger.fatal("Error dispatching message", (Throwable)de);
                                        }
                                        catch (ThreadDeath td) {
                                            throw td;
                                        }
                                        catch (VirtualMachineError err) {
                                            SystemFailure.initiateFailure(err);
                                            throw err;
                                        }
                                        catch (Throwable t) {
                                            SystemFailure.checkFailure();
                                            Connection.logger.fatal("Throwable dispatching message", t);
                                        }
                                    }
                                    catch (VirtualMachineError err) {
                                        SystemFailure.initiateFailure(err);
                                        throw err;
                                    }
                                    catch (Throwable t) {
                                        SystemFailure.checkFailure();
                                        this.sendFailureReply(ReplyProcessor21.getMessageRPId(), "Error deserializing message", t, this.directAck);
                                        if (t instanceof ThreadDeath) {
                                            throw (ThreadDeath)t;
                                        }
                                        if (t instanceof CancelException && !(t instanceof CacheClosedException)) {
                                            throw (CancelException)t;
                                        }
                                        Connection.logger.fatal("Error deserializing message", t);
                                    }
                                    finally {
                                        ReplyProcessor21.clearMessageRPId();
                                    }
                                } else if (this.nioMessageType == 77) {
                                    md = this.obtainMsgDestreamer(this.nioMsgId, this.remoteVersion);
                                    this.owner.getConduit().getStats().incMessagesBeingReceived(md.size() == 0, this.nioMessageLength);
                                    try {
                                        md.addChunk(this.nioInputBuffer, this.nioMessageLength);
                                    }
                                    catch (IOException ex) {
                                        Connection.logger.fatal("Failed handling chunk message", (Throwable)ex);
                                    }
                                } else {
                                    md = this.obtainMsgDestreamer(this.nioMsgId, this.remoteVersion);
                                    this.owner.getConduit().getStats().incMessagesBeingReceived(md.size() == 0, this.nioMessageLength);
                                    try {
                                        md.addChunk(this.nioInputBuffer, this.nioMessageLength);
                                    }
                                    catch (IOException ex) {
                                        Connection.logger.fatal("Failed handling end chunk message", (Throwable)ex);
                                    }
                                    msg = null;
                                    msgLength = 0;
                                    failureMsg = null;
                                    failureEx /* !! */  = null;
                                    rpId = 0;
                                    interrupted = false;
                                    try {
                                        msg = md.getMessage();
                                    }
                                    catch (ClassNotFoundException ex) {
                                        this.owner.getConduit().getStats().decMessagesBeingReceived(md.size());
                                        failureMsg = "ClassNotFound deserializing message";
                                        failureEx /* !! */  = ex;
                                        rpId = md.getRPid();
                                        Connection.logger.fatal("ClassNotFound deserializing message: {}", (Object)ex.toString());
                                    }
                                    catch (IOException ex) {
                                        this.owner.getConduit().getStats().decMessagesBeingReceived(md.size());
                                        failureMsg = "IOException deserializing message";
                                        failureEx /* !! */  = ex;
                                        rpId = md.getRPid();
                                        Connection.logger.fatal("IOException deserializing message", (Throwable)failureEx /* !! */ );
                                    }
                                    catch (InterruptedException ex) {
                                        interrupted = true;
                                        this.owner.getConduit().getCancelCriterion().checkCancelInProgress(ex);
                                    }
                                    catch (VirtualMachineError err) {
                                        SystemFailure.initiateFailure(err);
                                        throw err;
                                    }
                                    catch (Throwable ex) {
                                        SystemFailure.checkFailure();
                                        this.owner.getConduit().getCancelCriterion().checkCancelInProgress(ex);
                                        this.owner.getConduit().getStats().decMessagesBeingReceived(md.size());
                                        failureMsg = "Unexpected failure deserializing message";
                                        failureEx /* !! */  = ex;
                                        rpId = md.getRPid();
                                        Connection.logger.fatal("Unexpected failure deserializing message", (Throwable)failureEx /* !! */ );
                                    }
                                    finally {
                                        msgLength = md.size();
                                        this.releaseMsgDestreamer(this.nioMsgId, md);
                                        if (interrupted) {
                                            Thread.currentThread().interrupt();
                                        }
                                    }
                                    if (msg != null) {
                                        try {
                                            if (this.dispatchMessage(msg, msgLength, this.directAck)) ** GOTO lbl277
                                            this.directAck = false;
                                        }
                                        catch (MemberShunnedException e) {
                                            this.directAck = false;
                                        }
                                        catch (Exception de) {
                                            this.owner.getConduit().getCancelCriterion().checkCancelInProgress(de);
                                            Connection.logger.fatal("Error dispatching message", (Throwable)de);
                                        }
                                        catch (ThreadDeath td) {
                                            throw td;
                                        }
                                        catch (VirtualMachineError err) {
                                            SystemFailure.initiateFailure(err);
                                            throw err;
                                        }
                                        catch (Throwable t) {
                                            SystemFailure.checkFailure();
                                            Connection.logger.fatal("Throwable dispatching message", t);
                                        }
                                    } else if (failureEx /* !! */  != null) {
                                        this.sendFailureReply(rpId, failureMsg, failureEx /* !! */ , this.directAck);
                                    }
                                }
                                break block83;
                            }
                            bbis = new ByteBufferInputStream(this.nioInputBuffer);
                            dis = new DataInputStream(bbis);
                            if (this.isReceiver) break block84;
                            try {
                                this.replyCode = dis.readUnsignedByte();
                                if (this.replyCode == 70) {
                                    this.asyncDistributionTimeout = dis.readInt();
                                    this.asyncQueueTimeout = dis.readInt();
                                    this.asyncMaxQueueSize = (long)dis.readInt() * 0x100000L;
                                    if (this.asyncDistributionTimeout != 0) {
                                        Connection.logger.info("{} async configuration received {}.", (Object)this.p2pReaderName(), (Object)(" asyncDistributionTimeout=" + this.asyncDistributionTimeout + " asyncQueueTimeout=" + this.asyncQueueTimeout + " asyncMaxQueueSize=" + this.asyncMaxQueueSize / 0x100000L));
                                    }
                                    this.remoteVersion = Version.readVersion(dis, true);
                                }
                            }
                            catch (Exception e) {
                                this.owner.getConduit().getCancelCriterion().checkCancelInProgress(e);
                                Connection.logger.fatal("Error deserializing P2P handshake reply", (Throwable)e);
                                this.readerShuttingDown = true;
                                this.requestClose("Error deserializing P2P handshake reply");
                                return;
                            }
                            catch (ThreadDeath td) {
                                throw td;
                            }
                            catch (VirtualMachineError err) {
                                SystemFailure.initiateFailure(err);
                                throw err;
                            }
                            catch (Throwable t) {
                                SystemFailure.checkFailure();
                                Connection.logger.fatal("Throwable deserializing P2P handshake reply", t);
                                this.readerShuttingDown = true;
                                this.requestClose("Throwable deserializing P2P handshake reply");
                                return;
                            }
                            if (this.replyCode != 69 && this.replyCode != 70) {
                                err = "Unknown handshake reply code: %s nioMessageLength: %s";
                                errArgs = new Object[]{this.replyCode, this.nioMessageLength};
                                if (this.replyCode == 0 && Connection.logger.isDebugEnabled()) {
                                    Connection.logger.debug(String.format(err, errArgs) + " (peer probably departed ungracefully)");
                                } else {
                                    Connection.logger.fatal(err, errArgs);
                                }
                                this.readerShuttingDown = true;
                                this.requestClose(String.format(err, errArgs));
                                return;
                            }
                            this.notifyHandshakeWaiter(true);
                            break block83;
                        }
                        try {
                            b = dis.readByte();
                            if (b != 0) {
                                throw new IllegalStateException(String.format("Detected old version (pre 5.0.1) of GemFire or non-GemFire during handshake due to initial byte being %s", new Object[]{new Byte(b)}));
                            }
                            handshakeByte = dis.readByte();
                            if (handshakeByte != 7) {
                                throw new IllegalStateException(String.format("Detected wrong version of GemFire product during handshake. Expected %s but found %s", new Object[]{new Byte(7), new Byte(handshakeByte)}));
                            }
                            remote = DSFIDFactory.readInternalDistributedMember(dis);
                            this.setRemoteAddr(remote);
                            this.sharedResource = dis.readBoolean();
                            this.preserveOrder = dis.readBoolean();
                            this.uniqueId = dis.readLong();
                            this.remoteVersion = Version.readVersion(dis, true);
                            dominoNumber = 0;
                            if (this.remoteVersion == null || this.remoteVersion.compareTo(Version.GFE_80) >= 0) {
                                dominoNumber = dis.readInt();
                                if (this.sharedResource) {
                                    dominoNumber = 0;
                                }
                                Connection.dominoCount.set(dominoNumber);
                            }
                            if (!this.sharedResource) {
                                if (Connection.tipDomino()) {
                                    Connection.logger.info("thread owned receiver forcing itself to send on thread owned sockets");
                                } else {
                                    ConnectionTable.threadWantsOwnResources();
                                    if (Connection.logger.isDebugEnabled()) {
                                        Connection.logger.debug("thread-owned receiver with domino count of {} will prefer sending on thread-owned sockets", (Object)dominoNumber);
                                    }
                                }
                                this.conduit.getStats().incThreadOwnedReceivers(1L, dominoNumber);
                                this.setSendBufferSize(this.socket);
                            }
                            this.setThreadName(dominoNumber);
                        }
                        catch (Exception e) {
                            this.owner.getConduit().getCancelCriterion().checkCancelInProgress(e);
                            Connection.logger.fatal("Error deserializing P2P handshake message", (Throwable)e);
                            this.readerShuttingDown = true;
                            this.requestClose("Error deserializing P2P handshake message");
                            return;
                        }
                        if (Connection.logger.isDebugEnabled()) {
                            Connection.logger.debug("P2P handshake remoteAddr is {}{}", (Object)this.remoteAddr, (Object)(this.remoteVersion != null ? " (" + this.remoteVersion + ')' : ""));
                        }
                        try {
                            authInit = System.getProperty("gemfire.sys.security-peer-auth-init");
                            v1 = isSecure = authInit != null && authInit.length() != 0;
                            if (!isSecure) ** GOTO lbl263
                            if (this.owner.getConduit().waitForMembershipCheck(this.remoteAddr)) {
                                this.sendOKHandshakeReply();
                                this.notifyHandshakeWaiter(true);
                            } else {
                                this.notifyHandshakeWaiter(false);
                                Connection.logger.warn("{} timed out during a membership check.", (Object)this.p2pReaderName());
                                return;
lbl263:
                                // 1 sources

                                this.sendOKHandshakeReply();
                                try {
                                    this.notifyHandshakeWaiter(true);
                                }
                                catch (Exception e) {
                                    Connection.logger.fatal("Uncaught exception from listener", (Throwable)e);
                                }
                            }
                        }
                        catch (IOException ex) {
                            err = "Failed sending handshake reply";
                            if (Connection.logger.isDebugEnabled()) {
                                Connection.logger.debug("Failed sending handshake reply", (Throwable)ex);
                            }
                            this.readerShuttingDown = true;
                            this.requestClose("Failed sending handshake reply: " + ex);
                            return;
                        }
                    }
                    if (!this.connected) continue;
                    this.accessed();
                    this.nioInputBuffer.limit(oldLimit);
                    this.nioInputBuffer.position(startPos + this.nioMessageLength);
                    continue;
                }
                done = true;
                this.compactOrResizeBuffer(this.nioMessageLength);
                continue;
            }
            done = true;
            if (this.nioInputBuffer.position() != 0) {
                this.nioInputBuffer.compact();
                continue;
            }
            this.nioInputBuffer.position(this.nioInputBuffer.limit());
            this.nioInputBuffer.limit(this.nioInputBuffer.capacity());
        }
    }

    private void setThreadName(int dominoNumber) {
        Thread.currentThread().setName("P2P message reader for " + this.remoteAddr + " " + (this.sharedResource ? "" : "un") + "shared " + (this.preserveOrder ? "" : "un") + "ordered uid=" + this.uniqueId + (dominoNumber > 0 ? " dom #" + dominoNumber : "") + " port=" + this.socket.getPort());
    }

    private void compactOrResizeBuffer(int messageLength) {
        int oldBufferSize = this.nioInputBuffer.capacity();
        DMStats stats = this.owner.getConduit().getStats();
        int allocSize = messageLength + 7;
        if (oldBufferSize < allocSize) {
            logger.info("Allocating larger network read buffer, new size is {} old size was {}.", (Object)allocSize, (Object)oldBufferSize);
            ByteBuffer oldBuffer = this.nioInputBuffer;
            this.nioInputBuffer = Buffers.acquireReceiveBuffer(allocSize, stats);
            if (oldBuffer != null) {
                int oldByteCount = oldBuffer.remaining();
                this.nioInputBuffer.put(oldBuffer);
                this.nioInputBuffer.position(oldByteCount);
                Buffers.releaseReceiveBuffer(oldBuffer, stats);
            }
        } else if (this.nioInputBuffer.position() != 0) {
            this.nioInputBuffer.compact();
        } else {
            this.nioInputBuffer.position(this.nioInputBuffer.limit());
            this.nioInputBuffer.limit(this.nioInputBuffer.capacity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dispatchMessage(DistributionMessage msg, int bytesRead, boolean directAck) {
        try {
            msg.setDoDecMessagesBeingReceived(true);
            if (directAck) {
                Assert.assertTrue(!this.isSharedResource(), "We were asked to send a direct reply on a shared socket");
                msg.setReplySender(new DirectReplySender(this));
            }
            this.owner.getConduit().messageReceived(this, msg, bytesRead);
            boolean bl = true;
            return bl;
        }
        finally {
            if (msg.containsRegionContentChange()) {
                ++this.messagesReceived;
            }
        }
    }

    protected TCPConduit getConduit() {
        return this.conduit;
    }

    protected Socket getSocket() throws SocketException {
        Socket result = this.socket;
        if (result == null) {
            throw new SocketException("socket has been closed");
        }
        return result;
    }

    public boolean isSocketClosed() {
        return this.socket.isClosed() || !this.socket.isConnected();
    }

    public boolean isReceiverStopped() {
        return this.stopped;
    }

    private boolean isSocketInUse() {
        return this.socketInUse;
    }

    protected void accessed() {
        this.accessed = true;
    }

    public InternalDistributedMember getRemoteAddress() {
        return this.remoteAddr;
    }

    public Version getRemoteVersion() {
        return this.remoteVersion;
    }

    public String toString() {
        return String.valueOf(this.remoteAddr) + '@' + this.uniqueId + (this.remoteVersion != null ? '(' + this.remoteVersion.toString() + ')' : "");
    }

    protected boolean getOriginatedHere() {
        return !this.isReceiver;
    }

    protected boolean getPreserveOrder() {
        return this.preserveOrder;
    }

    protected long getUniqueId() {
        return this.uniqueId;
    }

    protected long getMessagesReceived() {
        return this.messagesReceived;
    }

    protected long getMessagesSent() {
        return this.messagesSent;
    }

    public void acquireSendPermission() throws ConnectionException {
        if (!this.connected) {
            throw new ConnectionException("connection is closed");
        }
        if (Connection.isReaderThread()) {
            return;
        }
        boolean interrupted = false;
        try {
            while (true) {
                this.owner.getConduit().getCancelCriterion().checkCancelInProgress(null);
                try {
                    this.senderSem.acquire();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (!this.connected) {
            this.senderSem.release();
            this.owner.getConduit().getCancelCriterion().checkCancelInProgress(null);
            throw new ConnectionException("connection is closed");
        }
    }

    public void releaseSendPermission() {
        if (Connection.isReaderThread()) {
            return;
        }
        this.senderSem.release();
    }

    private void closeSenderSem() {
        this.releaseSendPermission();
    }

    private boolean useNIO() {
        String os;
        if (TCPConduit.useSSL) {
            return false;
        }
        if (this.nioChecked) {
            return this.useNIO;
        }
        this.nioChecked = true;
        this.useNIO = this.owner.getConduit().useNIO();
        if (!this.useNIO) {
            return false;
        }
        if (this.socket != null && this.socket.getInetAddress() instanceof Inet6Address && (os = System.getProperty("os.name")) != null && os.contains("Windows")) {
            this.useNIO = false;
        }
        return this.useNIO;
    }

    static {
        IS_P2P_CONNECT_TIMEOUT_INITIALIZED = false;
        SMALL_BUFFER_SIZE = Integer.getInteger("gemfire.SMALL_BUFFER_SIZE", 4096);
        idCounter = new AtomicLong(1L);
        isReaderThread = new ThreadLocal();
        DOMINO_THREAD_OWNED_SOCKETS = Boolean.getBoolean("p2p.ENABLE_DOMINO_THREAD_OWNED_SOCKETS");
        isDominoThread = new ThreadLocal();
        dominoCount = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
        MAX_SENDERS = Integer.getInteger("p2p.maxConnectionSenders", DirectChannel.DEFAULT_CONCURRENCY_LEVEL);
        int msglen = 1;
        byte[] bytes = new byte[7 + msglen];
        msglen = Connection.calcHdrSize(msglen);
        bytes[0] = (byte)(msglen / 0x1000000 & 0xFF);
        bytes[1] = (byte)(msglen / 65536 & 0xFF);
        bytes[2] = (byte)(msglen / 256 & 0xFF);
        bytes[3] = (byte)(msglen & 0xFF);
        bytes[4] = 76;
        bytes[5] = -1;
        bytes[6] = -1;
        bytes[7] = 69;
        int allocSize = bytes.length;
        ByteBuffer bb = TCPConduit.useDirectBuffers ? ByteBuffer.allocateDirect(allocSize) : ByteBuffer.allocate(allocSize);
        bb.put(bytes);
        okHandshakeBuf = bb;
        okHandshakeBytes = bytes;
        HANDSHAKE_TIMEOUT_MS = Integer.getInteger("p2p.handshakeTimeoutMs", 59000);
        RECONNECT_WAIT_TIME = Integer.getInteger("gemfire.RECONNECT_WAIT_TIME", 2000);
        BATCH_SENDS = Boolean.getBoolean("p2p.batchSends");
        BATCH_BUFFER_SIZE = Integer.getInteger("p2p.batchBufferSize", 0x100000);
        BATCH_FLUSH_MS = Integer.getInteger("p2p.batchFlushTime", 50);
        SOCKET_WRITE_DISABLED = Boolean.getBoolean("p2p.disableSocketWrite");
        FORCE_ASYNC_QUEUE = false;
    }

    private class BatchBufferFlusher
    extends Thread {
        private volatile boolean flushNeeded = false;
        private volatile boolean timeToStop = false;
        private DMStats stats;

        public BatchBufferFlusher() {
            this.setDaemon(true);
            this.stats = Connection.this.owner.getConduit().getStats();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void flushBuffer(ByteBuffer bb) {
            long start = DistributionStats.getStatTime();
            try {
                Object object = this;
                synchronized (object) {
                    Object object2 = Connection.this.batchLock;
                    synchronized (object2) {
                        if (bb != Connection.this.fillBatchBuffer) {
                            return;
                        }
                    }
                    this.flushNeeded = true;
                    this.notify();
                }
                object = Connection.this.batchLock;
                synchronized (object) {
                    while (bb == Connection.this.fillBatchBuffer) {
                        Connection.this.owner.getConduit().getCancelCriterion().checkCancelInProgress(null);
                        boolean interrupted = Thread.interrupted();
                        try {
                            Connection.this.batchLock.wait();
                        }
                        catch (InterruptedException ex) {
                            interrupted = true;
                        }
                        finally {
                            if (!interrupted) continue;
                            Thread.currentThread().interrupt();
                        }
                    }
                    return;
                }
            }
            finally {
                Connection.this.owner.getConduit().getStats().incBatchWaitTime(start);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            BatchBufferFlusher batchBufferFlusher = this;
            synchronized (batchBufferFlusher) {
                this.timeToStop = true;
                this.flushNeeded = true;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BatchBufferFlusher batchBufferFlusher = this;
                synchronized (batchBufferFlusher) {
                    while (!this.timeToStop) {
                        if (!this.flushNeeded && Connection.this.fillBatchBuffer.position() <= BATCH_BUFFER_SIZE / 2) {
                            this.wait(BATCH_FLUSH_MS);
                        }
                        if (!this.flushNeeded && Connection.this.fillBatchBuffer.position() <= BATCH_BUFFER_SIZE / 2) continue;
                        long start = DistributionStats.getStatTime();
                        Object object = Connection.this.batchLock;
                        synchronized (object) {
                            this.flushNeeded = false;
                            ByteBuffer tmp = Connection.this.fillBatchBuffer;
                            Connection.this.fillBatchBuffer = Connection.this.sendBatchBuffer;
                            Connection.this.sendBatchBuffer = tmp;
                            Connection.this.batchLock.notifyAll();
                        }
                        if (Connection.this.sendBatchBuffer.position() > 0) {
                            boolean origSocketInUse = Connection.this.socketInUse;
                            Connection.this.socketInUse = true;
                            try {
                                Connection.this.sendBatchBuffer.flip();
                                SocketChannel channel = Connection.this.getSocket().getChannel();
                                Connection.this.nioWriteFully(channel, Connection.this.sendBatchBuffer, false, null);
                                Connection.this.sendBatchBuffer.clear();
                            }
                            catch (IOException | ConnectionException ex) {
                                logger.fatal("Exception flushing batch send buffer: %s", (Throwable)ex);
                                Connection.this.readerShuttingDown = true;
                                Connection.this.requestClose(String.format("Exception flushing batch send buffer: %s", ex));
                            }
                            finally {
                                Connection.this.accessed();
                                Connection.this.socketInUse = origSocketInUse;
                            }
                        }
                        this.stats.incBatchFlushTime(start);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

