/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.security.shiro;

import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.security.shiro.CustomAuthRealm;
import org.apache.geode.internal.security.shiro.GeodePermissionResolver;
import org.apache.geode.security.SecurityManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionManager;

public class SecurityManagerProvider {
    private static final Logger logger = LogService.getLogger("org.apache.geode.security");
    private org.apache.shiro.mgt.SecurityManager shiroManager;
    private SecurityManager securityManager;

    public SecurityManagerProvider() {
        this.shiroManager = SecurityUtils.getSecurityManager();
    }

    public SecurityManagerProvider(String shiroConfig) {
        this.securityManager = null;
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory("classpath:" + shiroConfig);
        Ini.Section main = factory.getIni().addSection("main");
        main.put("geodePermissionResolver", GeodePermissionResolver.class.getName());
        if (!main.containsKey((Object)"iniRealm.permissionResolver")) {
            main.put("iniRealm.permissionResolver", "$geodePermissionResolver");
        }
        this.shiroManager = (org.apache.shiro.mgt.SecurityManager)factory.getInstance();
    }

    public SecurityManagerProvider(SecurityManager securityManager) {
        this.securityManager = securityManager;
        CustomAuthRealm realm = new CustomAuthRealm(securityManager);
        this.shiroManager = new DefaultSecurityManager((Realm)realm);
        this.increaseShiroGlobalSessionTimeout((DefaultSecurityManager)this.shiroManager);
    }

    private void increaseShiroGlobalSessionTimeout(DefaultSecurityManager shiroManager) {
        SessionManager sessionManager = shiroManager.getSessionManager();
        if (DefaultSessionManager.class.isInstance(sessionManager)) {
            DefaultSessionManager defaultSessionManager = (DefaultSessionManager)sessionManager;
            defaultSessionManager.setGlobalSessionTimeout(Long.MAX_VALUE);
            long value = defaultSessionManager.getGlobalSessionTimeout();
            if (value != Long.MAX_VALUE) {
                logger.error("Unable to set Shiro Global Session Timeout. Current value is '{}'.", (Object)value);
            }
        } else {
            logger.error("Unable to set Shiro Global Session Timeout. Current SessionManager is '{}'.", sessionManager == null ? "null" : sessionManager.getClass());
        }
    }

    public org.apache.shiro.mgt.SecurityManager getShiroSecurityManager() {
        return this.shiroManager;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }
}

