/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.util.Properties;
import org.apache.commons.lang3.Validate;
import org.apache.geode.internal.process.StartupStatus;
import org.apache.geode.internal.process.StartupStatusListener;

public class ProcessLauncherContext {
    public static final String OVERRIDDEN_DEFAULTS_PREFIX = "gemfire.default.";
    private static final boolean REDIRECT_OUTPUT_DEFAULT = false;
    private static final ThreadLocal<ProcessLauncherContext> DATA = new ThreadLocal();
    private final boolean redirectOutput;
    private final Properties overriddenDefaults;
    private final StartupStatusListener startupListener;

    private static ProcessLauncherContext get() {
        return DATA.get();
    }

    public static boolean isRedirectingOutput() {
        ProcessLauncherContext context = ProcessLauncherContext.get();
        if (context == null) {
            return false;
        }
        return context.redirectOutput();
    }

    public static Properties getOverriddenDefaults() {
        ProcessLauncherContext context = ProcessLauncherContext.get();
        if (context == null) {
            return new Properties();
        }
        return context.overriddenDefaults();
    }

    public static StartupStatusListener getStartupListener() {
        ProcessLauncherContext context = ProcessLauncherContext.get();
        if (context == null) {
            return null;
        }
        return context.startupListener();
    }

    public static void set(boolean redirectOutput, Properties overriddenDefaults, StartupStatusListener startupListener) {
        Validate.notNull((Object)overriddenDefaults, (String)("Invalid overriddenDefaults '" + overriddenDefaults + "' specified"), (Object[])new Object[0]);
        DATA.set(new ProcessLauncherContext(redirectOutput, overriddenDefaults, startupListener));
        ProcessLauncherContext.installLogListener(startupListener);
    }

    public static void remove() {
        DATA.remove();
        ProcessLauncherContext.clearLogListener();
    }

    private static void installLogListener(StartupStatusListener startupListener) {
        if (startupListener != null) {
            StartupStatus.setListener(startupListener);
        }
    }

    private static void clearLogListener() {
        StartupStatus.clearListener();
    }

    private ProcessLauncherContext(boolean redirectOutput, Properties overriddenDefaults, StartupStatusListener startupListener) {
        this.redirectOutput = redirectOutput;
        this.overriddenDefaults = overriddenDefaults;
        this.startupListener = startupListener;
    }

    private boolean redirectOutput() {
        return this.redirectOutput;
    }

    private Properties overriddenDefaults() {
        return this.overriddenDefaults;
    }

    private StartupStatusListener startupListener() {
        return this.startupListener;
    }
}

