/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.DSCODE;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.entries.OffHeapRegionEntry;
import org.apache.geode.internal.offheap.OffHeapStoredObject;
import org.apache.geode.internal.offheap.ReferenceCountHelper;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.offheap.TinyStoredObject;

public class OffHeapRegionEntryHelper {
    protected static final long NULL_ADDRESS = 0L;
    protected static final long INVALID_ADDRESS = 2L;
    protected static final long LOCAL_INVALID_ADDRESS = 4L;
    protected static final long DESTROYED_ADDRESS = 6L;
    protected static final long REMOVED_PHASE1_ADDRESS = 8L;
    protected static final long REMOVED_PHASE2_ADDRESS = 10L;
    protected static final long END_OF_STREAM_ADDRESS = 12L;
    protected static final long NOT_AVAILABLE_ADDRESS = 14L;
    protected static final long TOMBSTONE_ADDRESS = 16L;
    public static final int MAX_LENGTH_FOR_DATA_AS_ADDRESS = 8;
    @Immutable
    private static final Token[] addrToObj = new Token[]{null, Token.INVALID, Token.LOCAL_INVALID, Token.DESTROYED, Token.REMOVED_PHASE1, Token.REMOVED_PHASE2, Token.END_OF_STREAM, Token.NOT_AVAILABLE, Token.TOMBSTONE};
    private static final long ENCODED_BIT = 1L;
    static final long SERIALIZED_BIT = 2L;
    static final long COMPRESSED_BIT = 4L;
    private static final long LONG_BIT = 8L;
    private static final long SIZE_MASK = 112L;
    private static final int SIZE_SHIFT = 4;
    private static final ThreadLocal<Object> clearNeedsToCheckForOffHeap = new ThreadLocal();

    private static long objectToAddress(Object v) {
        if (v instanceof StoredObject) {
            return ((StoredObject)v).getAddress();
        }
        if (v == null) {
            return 0L;
        }
        if (v == Token.TOMBSTONE) {
            return 16L;
        }
        if (v == Token.INVALID) {
            return 2L;
        }
        if (v == Token.LOCAL_INVALID) {
            return 4L;
        }
        if (v == Token.DESTROYED) {
            return 6L;
        }
        if (v == Token.REMOVED_PHASE1) {
            return 8L;
        }
        if (v == Token.REMOVED_PHASE2) {
            return 10L;
        }
        if (v == Token.END_OF_STREAM) {
            return 12L;
        }
        if (v == Token.NOT_AVAILABLE) {
            return 14L;
        }
        throw new IllegalStateException("Can not convert " + v + " to an off heap address.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object addressToObject(long ohAddress, boolean decompress, RegionEntryContext context) {
        if (OffHeapRegionEntryHelper.isOffHeap(ohAddress)) {
            OffHeapStoredObject chunk = new OffHeapStoredObject(ohAddress);
            Object result = chunk;
            if (decompress && chunk.isCompressed()) {
                try {
                    byte[] decompressedBytes = chunk.getDecompressedBytes(context);
                    result = chunk.isSerialized() ? CachedDeserializableFactory.create(decompressedBytes, context.getCache()) : (Object)decompressedBytes;
                }
                finally {
                    chunk.release();
                }
            }
            return result;
        }
        if ((ohAddress & 1L) != 0L) {
            TinyStoredObject daa = new TinyStoredObject(ohAddress);
            Object result = daa;
            if (decompress && daa.isCompressed()) {
                byte[] decompressedBytes = daa.getDecompressedBytes(context);
                result = daa.isSerialized() ? CachedDeserializableFactory.create(decompressedBytes, context.getCache()) : (Object)decompressedBytes;
            }
            return result;
        }
        return addrToObj[(int)ohAddress >> 1];
    }

    public static int getSerializedLength(TinyStoredObject dataAsAddress) {
        long ohAddress = dataAsAddress.getAddress();
        if ((ohAddress & 1L) != 0L) {
            boolean isLong;
            boolean bl = isLong = (ohAddress & 8L) != 0L;
            if (isLong) {
                return 9;
            }
            return (int)((ohAddress & 0x70L) >> 4);
        }
        return 0;
    }

    private static Token addressToToken(long ohAddress) {
        if (OffHeapRegionEntryHelper.isOffHeap(ohAddress) || (ohAddress & 1L) != 0L) {
            return Token.NOT_A_TOKEN;
        }
        return addrToObj[(int)ohAddress >> 1];
    }

    private static void releaseAddress(long ohAddress) {
        if (OffHeapRegionEntryHelper.isOffHeap(ohAddress)) {
            OffHeapStoredObject.release(ohAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseEntry(OffHeapRegionEntry re) {
        DiskId did;
        if (re instanceof DiskEntry && (did = ((DiskEntry)((Object)re)).getDiskId()) != null && did.isPendingAsync()) {
            DiskId diskId = did;
            synchronized (diskId) {
                did.setPendingAsync(false);
                OffHeapRegionEntryHelper.setValue(re, Token.REMOVED_PHASE2);
                return;
            }
        }
        OffHeapRegionEntryHelper.setValue(re, Token.REMOVED_PHASE2);
    }

    public static void releaseEntry(OffHeapRegionEntry re, StoredObject expectedValue) {
        long newAddress;
        long oldAddress = OffHeapRegionEntryHelper.objectToAddress(expectedValue);
        if (re.setAddress(oldAddress, newAddress = OffHeapRegionEntryHelper.objectToAddress(Token.REMOVED_PHASE2))) {
            OffHeapRegionEntryHelper.releaseAddress(oldAddress);
        }
    }

    public static long encodeDataAsAddress(byte[] v, boolean isSerialized, boolean isCompressed) {
        if (v.length < 8) {
            long result = 0L;
            for (int i = 0; i < v.length; ++i) {
                result |= (long)(v[i] & 0xFF);
                result <<= 8;
            }
            result |= (long)(v.length << 4) | 1L;
            if (isSerialized) {
                result |= 2L;
            }
            if (isCompressed) {
                result |= 4L;
            }
            return result;
        }
        if (isSerialized && !isCompressed && v[0] == DSCODE.LONG.toByte() && (v[1] == 0 && (v[2] & 0x80) == 0 || v[1] == -1 && (v[2] & 0x80) != 0)) {
            long result = 0L;
            for (int i = 2; i < v.length; ++i) {
                result |= (long)(v[i] & 0xFF);
                result <<= 8;
            }
            return result |= 0x7BL;
        }
        return 0L;
    }

    static Object decodeAddressToObject(long ohAddress) {
        boolean isSerialized;
        byte[] bytes = OffHeapRegionEntryHelper.decodeUncompressedAddressToBytes(ohAddress);
        boolean bl = isSerialized = (ohAddress & 2L) != 0L;
        if (isSerialized) {
            return EntryEventImpl.deserialize(bytes);
        }
        return bytes;
    }

    static int decodeAddressToDataSize(long addr) {
        boolean isLong;
        if ((addr & 1L) == 0L) {
            throw new AssertionError((Object)("Invalid address: " + addr));
        }
        boolean bl = isLong = (addr & 8L) != 0L;
        if (isLong) {
            return 9;
        }
        return (int)((addr & 0x70L) >> 4);
    }

    static byte[] decodeUncompressedAddressToBytes(long addr) {
        if ((addr & 4L) != 0L) {
            throw new AssertionError((Object)"Did not expect encoded address to be compressed");
        }
        return OffHeapRegionEntryHelper.decodeAddressToRawBytes(addr);
    }

    static byte[] decodeAddressToRawBytes(long addr) {
        byte[] bytes;
        boolean isLong;
        if ((addr & 1L) == 0L) {
            throw new AssertionError((Object)("Invalid address: " + addr));
        }
        int size = (int)((addr & 0x70L) >> 4);
        boolean bl = isLong = (addr & 8L) != 0L;
        if (isLong) {
            bytes = new byte[9];
            bytes[0] = DSCODE.LONG.toByte();
            for (int i = 8; i >= 2; --i) {
                bytes[i] = (byte)((addr >>= 8) & 0xFFL);
            }
            bytes[1] = (bytes[2] & 0x80) != 0 ? -1 : 0;
        } else {
            bytes = new byte[size];
            for (int i = size - 1; i >= 0; --i) {
                bytes[i] = (byte)((addr >>= 8) & 0xFFL);
            }
        }
        return bytes;
    }

    public static void setValue(OffHeapRegionEntry re, Object v) {
        long oldAddress;
        long newAddress = OffHeapRegionEntryHelper.objectToAddress(v);
        while (!re.setAddress(oldAddress = re.getAddress(), newAddress)) {
        }
        ReferenceCountHelper.setReferenceCountOwner(re);
        OffHeapRegionEntryHelper.releaseAddress(oldAddress);
        ReferenceCountHelper.setReferenceCountOwner(null);
    }

    public static Token getValueAsToken(OffHeapRegionEntry re) {
        return OffHeapRegionEntryHelper.addressToToken(re.getAddress());
    }

    public static Object _getValue(OffHeapRegionEntry re) {
        return OffHeapRegionEntryHelper.addressToObject(re.getAddress(), false, null);
    }

    public static boolean isOffHeap(long addr) {
        if ((addr & 1L) != 0L) {
            return false;
        }
        if (addr < 0L) {
            return true;
        }
        return (addr >>= 1) >= (long)addrToObj.length;
    }

    public static Object _getValueRetain(OffHeapRegionEntry re, boolean decompress, RegionEntryContext context) {
        int retryCount = 0;
        long addr = re.getAddress();
        while (OffHeapRegionEntryHelper.isOffHeap(addr)) {
            long addr2;
            if (OffHeapStoredObject.retain(addr)) {
                addr2 = re.getAddress();
                if (addr != addr2) {
                    retryCount = 0;
                    OffHeapStoredObject.release(addr);
                    addr = addr2;
                    continue;
                }
                return OffHeapRegionEntryHelper.addressToObject(addr, decompress, context);
            }
            addr2 = re.getAddress();
            if (++retryCount > 100) {
                throw new IllegalStateException("retain failed addr=" + addr + " addr2=" + addr + " 100 times history=" + ReferenceCountHelper.getFreeRefCountInfo(addr));
            }
            addr = addr2;
        }
        return OffHeapRegionEntryHelper.addressToObject(addr, decompress, context);
    }

    public static boolean isSerialized(long address) {
        return (address & 2L) != 0L;
    }

    public static boolean isCompressed(long address) {
        return (address & 4L) != 0L;
    }

    public static boolean doesClearNeedToCheckForOffHeap() {
        return clearNeedsToCheckForOffHeap.get() != null;
    }

    public static void doWithOffHeapClear(Runnable r) {
        clearNeedsToCheckForOffHeap.set(Boolean.TRUE);
        try {
            r.run();
        }
        finally {
            clearNeedsToCheckForOffHeap.remove();
        }
    }
}

