/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging.log4j;

import java.util.HashSet;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.logging.LogConfig;
import org.apache.geode.internal.logging.LogLevelUpdateOccurs;
import org.apache.geode.internal.logging.LogLevelUpdateScope;
import org.apache.geode.internal.logging.LogWriterLevel;
import org.apache.geode.internal.logging.ProviderAgent;
import org.apache.geode.internal.logging.log4j.FastLogger;
import org.apache.geode.internal.logging.log4j.GeodeConsoleAppender;
import org.apache.geode.internal.logging.log4j.LogWriterLevelConverter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;

public class Log4jAgent
implements ProviderAgent {
    static final String GEODE_CONSOLE_APPENDER_NAME = "STDOUT";
    static final String LOGWRITER_APPENDER_NAME = "LOGWRITER";
    static final String SECURITY_LOGWRITER_APPENDER_NAME = "SECURITYLOGWRITER";
    static final String ALERT_APPENDER_NAME = "ALERT";
    private static final String GEODE_VERBOSE_FILTER = "{GEODE_VERBOSE}";
    private static final String GEMFIRE_VERBOSE_FILTER = "{GEMFIRE_VERBOSE}";
    private static final String GEODE_DEFAULT_PROPERTY = "geode-default";
    private boolean configuredSecurityAppenders;

    public static void updateLogLevel(Level level, LoggerConfig ... loggerConfigs) {
        for (LoggerConfig loggerConfig : loggerConfigs) {
            loggerConfig.setLevel(level);
        }
        Log4jAgent.getRootLoggerContext().updateLoggers();
    }

    public static LoggerConfig getLoggerConfig(Logger logger) {
        return ((org.apache.logging.log4j.core.Logger)logger).get();
    }

    @VisibleForTesting
    static String getConfigurationInfoString() {
        return Log4jAgent.getConfiguration().getConfigurationSource().toString();
    }

    static boolean isUsingGemFireDefaultConfig() {
        Configuration configuration = Log4jAgent.getConfiguration();
        StrSubstitutor strSubstitutor = configuration.getStrSubstitutor();
        StrLookup variableResolver = strSubstitutor.getVariableResolver();
        String value = variableResolver.lookup(GEODE_DEFAULT_PROPERTY);
        return "true".equals(value);
    }

    private static LoggerContext getRootLoggerContext() {
        return ((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger()).getContext();
    }

    private static Configuration getConfiguration() {
        return Log4jAgent.getRootLoggerContext().getConfiguration();
    }

    @Override
    public void configure(LogConfig logConfig, LogLevelUpdateOccurs logLevelUpdateOccurs, LogLevelUpdateScope logLevelUpdateScope) {
        if (this.shouldUpdateLogLevels(logLevelUpdateOccurs)) {
            Level loggerLevel = LogWriterLevelConverter.toLevel(LogWriterLevel.find(logConfig.getLogLevel()));
            Log4jAgent.updateLogLevel(loggerLevel, this.getLoggerConfig("org.apache.geode"));
            Level securityLoggerLevel = LogWriterLevelConverter.toLevel(LogWriterLevel.find(logConfig.getSecurityLogLevel()));
            Log4jAgent.updateLogLevel(securityLoggerLevel, this.getLoggerConfig("org.apache.geode.security"));
            if (!LogConfig.hasSecurityLogFile(logConfig)) {
                this.configuredSecurityAppenders = this.configureSecurityAppenders("org.apache.geode.security", securityLoggerLevel);
            }
        }
        if (this.shouldUpdateLogLevels(logLevelUpdateOccurs)) {
            this.updateLogLevel(logConfig, logLevelUpdateScope);
        }
        this.configureFastLoggerDelegating();
    }

    private boolean shouldUpdateLogLevels(LogLevelUpdateOccurs logLevelUpdateOccurs) {
        return logLevelUpdateOccurs.always() || logLevelUpdateOccurs.onlyWhenUsingDefaultConfig() && Log4jAgent.isUsingGemFireDefaultConfig();
    }

    @Override
    public void cleanup() {
        if (this.configuredSecurityAppenders) {
            Configuration log4jConfiguration = Log4jAgent.getRootLoggerContext().getConfiguration();
            LoggerConfig loggerConfig = log4jConfiguration.getLoggerConfig("org.apache.geode.security");
            loggerConfig.removeAppender(GEODE_CONSOLE_APPENDER_NAME);
            loggerConfig.removeAppender(LOGWRITER_APPENDER_NAME);
            loggerConfig.setAdditive(false);
            Log4jAgent.getRootLoggerContext().updateLoggers();
        }
    }

    @Override
    public String getConfigurationInfo() {
        return Log4jAgent.getConfiguration().getConfigurationSource().toString();
    }

    @Override
    public void enableLoggingToStandardOutput() {
        Configuration log4jConfiguration = Log4jAgent.getRootLoggerContext().getConfiguration();
        Appender appender = log4jConfiguration.getAppender(GEODE_CONSOLE_APPENDER_NAME);
        if (GeodeConsoleAppender.class.isInstance(appender)) {
            GeodeConsoleAppender geodeConsoleAppender = (GeodeConsoleAppender)appender;
            geodeConsoleAppender.resume();
        }
    }

    @Override
    public void disableLoggingToStandardOutput() {
        Configuration log4jConfiguration = Log4jAgent.getRootLoggerContext().getConfiguration();
        Appender appender = log4jConfiguration.getAppender(GEODE_CONSOLE_APPENDER_NAME);
        if (GeodeConsoleAppender.class.isInstance(appender)) {
            GeodeConsoleAppender geodeConsoleAppender = (GeodeConsoleAppender)appender;
            geodeConsoleAppender.pause();
        }
    }

    public String toString() {
        return super.toString() + ": {configuredSecurityAppenders=" + this.configuredSecurityAppenders + "}";
    }

    private void updateLogLevel(LogConfig logConfig, LogLevelUpdateScope logLevelUpdateScope) {
        Level level = LogWriterLevelConverter.toLevel(LogWriterLevel.find(logConfig.getLogLevel()));
        Configuration configuration = Log4jAgent.getRootLoggerContext().getConfiguration();
        HashSet<LoggerConfig> loggerConfigs = new HashSet<LoggerConfig>();
        for (LoggerConfig loggerConfig : configuration.getLoggers().values()) {
            switch (logLevelUpdateScope) {
                case ALL_LOGGERS: {
                    loggerConfigs.add(loggerConfig);
                    break;
                }
                case GEODE_AND_SECURITY_LOGGERS: {
                    if (!loggerConfig.getName().startsWith("org.apache.geode")) break;
                    loggerConfigs.add(loggerConfig);
                    break;
                }
                case GEODE_AND_APPLICATION_LOGGERS: {
                    if (loggerConfig.getName().equals("org.apache.geode.security")) break;
                    loggerConfigs.add(loggerConfig);
                    break;
                }
                case GEODE_LOGGERS: {
                    if (!loggerConfig.getName().startsWith("org.apache.geode") || loggerConfig.getName().equals("org.apache.geode.security")) break;
                    loggerConfigs.add(loggerConfig);
                }
            }
        }
        Log4jAgent.updateLogLevel(level, loggerConfigs.toArray(new LoggerConfig[0]));
    }

    private boolean configureSecurityAppenders(String name, Level level) {
        Configuration log4jConfiguration = Log4jAgent.getRootLoggerContext().getConfiguration();
        LoggerConfig loggerConfig = log4jConfiguration.getLoggerConfig(name);
        if (!loggerConfig.getName().equals("org.apache.geode.security")) {
            return false;
        }
        Appender stdoutAppender = log4jConfiguration.getAppender(GEODE_CONSOLE_APPENDER_NAME);
        Appender mainLogWriterAppender = log4jConfiguration.getAppender(LOGWRITER_APPENDER_NAME);
        if (stdoutAppender != null) {
            loggerConfig.addAppender(stdoutAppender, level, null);
        }
        if (mainLogWriterAppender != null) {
            loggerConfig.addAppender(mainLogWriterAppender, level, null);
        }
        loggerConfig.setAdditive(true);
        Log4jAgent.getRootLoggerContext().updateLoggers();
        return true;
    }

    private LoggerConfig getLoggerConfig(String name) {
        Configuration log4jConfiguration = Log4jAgent.getRootLoggerContext().getConfiguration();
        return log4jConfiguration.getLoggerConfig(name);
    }

    private void configureFastLoggerDelegating() {
        Configuration configuration = Log4jAgent.getConfiguration();
        if (this.hasContextWideFilter(configuration) || this.hasAppenderFilter(configuration) || this.hasDebugOrLower(configuration) || this.hasLoggerFilter(configuration) || this.hasAppenderRefFilter(configuration)) {
            FastLogger.setDelegating(true);
        } else {
            FastLogger.setDelegating(false);
        }
    }

    private boolean hasContextWideFilter(Configuration config) {
        return config.hasFilter();
    }

    private boolean hasAppenderFilter(Configuration config) {
        for (Appender appender : config.getAppenders().values()) {
            if (!(appender instanceof AbstractFilterable) || !((AbstractFilterable)appender).hasFilter()) continue;
            return true;
        }
        return false;
    }

    private boolean hasDebugOrLower(Configuration config) {
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            boolean isDebugOrLower = loggerConfig.getLevel().isLessSpecificThan(Level.DEBUG);
            if (!isDebugOrLower) continue;
            return true;
        }
        return false;
    }

    private boolean hasLoggerFilter(Configuration config) {
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            boolean isGemFireVerboseFilter;
            boolean isRoot = loggerConfig.getName().equals("");
            boolean isGemFire = loggerConfig.getName().startsWith("org.apache.geode");
            boolean hasFilter = loggerConfig.hasFilter();
            boolean bl = isGemFireVerboseFilter = hasFilter && (GEODE_VERBOSE_FILTER.equals(loggerConfig.getFilter().toString()) || GEMFIRE_VERBOSE_FILTER.equals(loggerConfig.getFilter().toString()));
            if (!isRoot && !isGemFire || !hasFilter || isGemFireVerboseFilter) continue;
            return true;
        }
        return false;
    }

    private boolean hasAppenderRefFilter(Configuration config) {
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            boolean isRoot = loggerConfig.getName().equals("");
            boolean isGemFire = loggerConfig.getName().startsWith("org.apache.geode");
            if (!isRoot && !isGemFire) continue;
            for (AppenderRef appenderRef : loggerConfig.getAppenderRefs()) {
                if (appenderRef.getFilter() == null) continue;
                return true;
            }
        }
        return false;
    }
}

