/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging.log4j;

import org.apache.geode.annotations.Immutable;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;

@Plugin(name="HexThreadIdPatternConverter", category="Converter")
@ConverterKeys(value={"hexTid", "hexThreadId"})
public class HexThreadIdPatternConverter
extends LogEventPatternConverter {
    @Immutable
    static final HexThreadIdPatternConverter INSTANCE = new HexThreadIdPatternConverter();

    private HexThreadIdPatternConverter() {
        super("HexThreadId", "hexThreadId");
    }

    public static HexThreadIdPatternConverter newInstance(String[] options) {
        return INSTANCE;
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        toAppendTo.append("0x").append(Long.toHexString(Thread.currentThread().getId()));
    }
}

