/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging.log4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.alerting.AlertLevel;
import org.apache.geode.internal.alerting.AlertMessaging;
import org.apache.geode.internal.alerting.AlertingAction;
import org.apache.geode.internal.alerting.AlertingProvider;
import org.apache.geode.internal.alerting.AlertingProviderRegistry;
import org.apache.geode.internal.logging.log4j.AlertLevelConverter;
import org.apache.geode.internal.logging.log4j.AlertListener;
import org.apache.geode.internal.logging.log4j.DebuggableAppender;
import org.apache.geode.internal.logging.log4j.PausableAppender;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="GeodeAlert", category="Core", elementType="appender", printObject=true)
public class AlertAppender
extends AbstractAppender
implements PausableAppender,
DebuggableAppender,
AlertingProvider {
    public static final String PLUGIN_NAME = "GeodeAlert";
    private static final boolean START_PAUSED_BY_DEFAULT = true;
    @MakeNotStatic
    private static final AtomicReference<AlertAppender> instanceRef = new AtomicReference();
    private final AtomicReference<AlertMessaging> alertMessagingRef = new AtomicReference();
    private final CopyOnWriteArrayList<AlertListener> listeners = new CopyOnWriteArrayList();
    private final AlertingProviderRegistry alertingProviderRegistry;
    private final boolean debug;
    private final List<LogEvent> events;
    private volatile boolean paused;

    protected AlertAppender(String name, Layout<? extends Serializable> layout, Filter filter) {
        this(name, layout, filter, AlertingProviderRegistry.get(), true, false);
    }

    protected AlertAppender(String name, Layout<? extends Serializable> layout, Filter filter, AlertingProviderRegistry alertingProviderRegistry, boolean startPaused, boolean debug) {
        super(name, filter, layout);
        this.alertingProviderRegistry = alertingProviderRegistry;
        this.debug = debug;
        this.events = debug ? Collections.synchronizedList(new ArrayList()) : Collections.emptyList();
        this.paused = true;
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public void append(LogEvent event) {
        LOGGER.trace("Handling append of {} in {}.", (Object)event, (Object)this);
        if (this.isPaused()) {
            LOGGER.trace("Skipping append of {} because {} is paused.", (Object)event, (Object)this);
            return;
        }
        if (!AlertLevelConverter.hasAlertLevel(event.getLevel())) {
            LOGGER.trace("Skipping append of {} because level is {}.", (Object)event, (Object)event.getLevel());
            return;
        }
        if (AlertingAction.isThreadAlerting()) {
            LOGGER.trace("Skipping append of {} because {} is alerting.", (Object)event, (Object)Thread.currentThread());
            return;
        }
        AlertingAction.execute(() -> this.doAppend(event));
    }

    private void doAppend(LogEvent event) {
        this.sendAlertMessage(event);
        if (this.debug) {
            this.events.add(event);
        }
    }

    private void sendAlertMessage(LogEvent event) {
        AlertMessaging alertMessaging = this.alertMessagingRef.get();
        if (alertMessaging == null || this.listeners.isEmpty()) {
            LOGGER.trace("Skipping alert messaging for {} because listeners is empty.", (Object)event);
            return;
        }
        AlertLevel alertLevel = AlertLevelConverter.fromLevel(event.getLevel());
        Date date = new Date(event.getTimeMillis());
        String threadName = event.getThreadName();
        String formattedMessage = event.getMessage().getFormattedMessage();
        String stackTrace = this.getStackTrace(event);
        for (AlertListener listener : this.listeners) {
            if (event.getLevel().intLevel() > listener.getLevel().intLevel()) break;
            LOGGER.trace("Sending alert message for {} to {}.", (Object)event, (Object)listener.getMember());
            alertMessaging.sendAlert(listener.getMember(), alertLevel, date, threadName, formattedMessage, stackTrace);
        }
    }

    private String getStackTrace(LogEvent event) {
        return event.getThrown() == null ? null : ExceptionUtils.getStackTrace((Throwable)event.getThrown());
    }

    public void start() {
        LOGGER.info("Starting {}.", (Object)this);
        LOGGER.debug("Registering {} with AlertingProviderRegistry.", (Object)this);
        try {
            this.alertingProviderRegistry.registerAlertingProvider(this);
        }
        finally {
            super.start();
        }
    }

    public void stop() {
        LOGGER.info("Stopping {}.", (Object)this);
        super.stop();
        this.cleanUp(true);
        LOGGER.info("{} has stopped.", (Object)this);
    }

    @Override
    public void pause() {
        LOGGER.debug("Pausing {}.", (Object)this);
        this.paused = true;
    }

    @Override
    public void resume() {
        LOGGER.debug("Resuming {}.", (Object)this);
        this.paused = false;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void clearLogEvents() {
        this.events.clear();
    }

    @Override
    public List<LogEvent> getLogEvents() {
        return this.events;
    }

    @Override
    public synchronized void createSession(AlertMessaging alertMessaging) {
        LOGGER.info("Creating session in {} with {}.", (Object)this, (Object)alertMessaging);
        this.setAlertMessaging(alertMessaging);
    }

    @Override
    public synchronized void startSession() {
        LOGGER.info("Starting session in {}.", (Object)this);
        this.resume();
    }

    @Override
    public synchronized void stopSession() {
        LOGGER.info("Stopping session in {}.", (Object)this);
        this.cleanUp(false);
    }

    private synchronized void cleanUp(boolean unregister) {
        this.pause();
        if (unregister) {
            LOGGER.debug("Unregistering {} with AlertingProviderRegistry.", (Object)this);
            this.alertingProviderRegistry.unregisterAlertingProvider(this);
        }
        this.listeners.clear();
        this.setAlertMessaging(null);
    }

    void setAlertMessaging(AlertMessaging alertMessaging) {
        this.alertMessagingRef.set(alertMessaging);
    }

    AlertMessaging getAlertMessaging() {
        return this.alertMessagingRef.get();
    }

    @Override
    public synchronized void addAlertListener(DistributedMember member, AlertLevel alertLevel) {
        if (alertLevel == AlertLevel.NONE) {
            return;
        }
        Level level = AlertLevelConverter.toLevel(alertLevel);
        AlertListener listener = new AlertListener(level, member);
        this.listeners.remove(listener);
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (listener.getLevel().compareTo(this.listeners.get(i).getLevel()) < 0) continue;
            this.listeners.add(i, listener);
            return;
        }
        this.listeners.add(listener);
        LOGGER.debug("Added/Replaced alert listener for member {} at level {}.", (Object)member, (Object)level);
    }

    @Override
    public synchronized boolean removeAlertListener(DistributedMember member) {
        boolean memberWasFound = this.listeners.remove(new AlertListener(null, member));
        if (memberWasFound) {
            LOGGER.debug("Removed alert listener for member {}.", (Object)member);
        }
        return memberWasFound;
    }

    @Override
    public synchronized boolean hasAlertListener(DistributedMember member, AlertLevel alertLevel) {
        Level level = AlertLevelConverter.toLevel(alertLevel);
        for (AlertListener listener : this.listeners) {
            if (!listener.getMember().equals(member) || !listener.getLevel().equals((Object)level)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ":" + this.getName() + " {alertMessaging=" + this.alertMessagingRef.get() + ", listeners=" + this.listeners + ", paused=" + this.paused + ", debug=" + this.debug + "}";
    }

    public synchronized List<AlertListener> getAlertListeners() {
        return this.listeners;
    }

    @VisibleForTesting
    static AlertAppender getInstance() {
        return instanceRef.get();
    }

    @VisibleForTesting
    static void setInstance(AlertAppender alertAppender) {
        instanceRef.set(alertAppender);
    }

    public static void stopSessionIfRunning() {
        AlertAppender instance = instanceRef.get();
        if (instance != null) {
            instance.stopSession();
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<AlertAppender> {
        @PluginBuilderAttribute
        private boolean debug;
        @PluginBuilderAttribute
        private boolean startPaused = true;

        public B setStartPaused(boolean shouldStartPaused) {
            this.startPaused = shouldStartPaused;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public boolean isStartPaused() {
            return this.debug;
        }

        public B setDebug(boolean shouldDebug) {
            this.debug = shouldDebug;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public boolean isDebug() {
            return this.debug;
        }

        public AlertAppender build() {
            Layout layout = this.getOrCreateLayout();
            instanceRef.set(new AlertAppender(this.getName(), (Layout<? extends Serializable>)layout, this.getFilter(), AlertingProviderRegistry.get(), this.startPaused, this.debug));
            return (AlertAppender)instanceRef.get();
        }
    }
}

