/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import org.apache.geode.internal.logging.LogConfigSupplier;

public interface SessionContext {
    public State getState();

    public LogConfigSupplier getLogConfigSupplier();

    public static enum State {
        CREATED,
        STARTED,
        STOPPED;


        State changeTo(State newState) {
            switch (newState) {
                case CREATED: {
                    if (this != STOPPED) {
                        throw new IllegalStateException("Session must not exist before creating");
                    }
                    return CREATED;
                }
                case STARTED: {
                    if (this != CREATED) {
                        throw new IllegalStateException("Session must be created before starting");
                    }
                    return STARTED;
                }
                case STOPPED: {
                    if (this == STARTED) break;
                    throw new IllegalStateException("Session must be started before stopping");
                }
            }
            return STOPPED;
        }
    }
}

