/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.internal.logging.LoggingThread;

public class LoggingThreadFactory
implements ThreadFactory {
    private final String baseName;
    private final CommandWrapper commandWrapper;
    private final ThreadInitializer threadInitializer;
    private final boolean isDaemon;
    private final AtomicInteger threadCount = new AtomicInteger(1);

    public LoggingThreadFactory(String baseName, ThreadInitializer threadInitializer, CommandWrapper commandWrapper, boolean isDaemon) {
        this.baseName = baseName;
        this.threadInitializer = threadInitializer;
        this.commandWrapper = commandWrapper;
        this.isDaemon = isDaemon;
    }

    public LoggingThreadFactory(String baseName, ThreadInitializer threadInitializer, CommandWrapper commandWrapper) {
        this(baseName, threadInitializer, commandWrapper, true);
    }

    public LoggingThreadFactory(String baseName) {
        this(baseName, null, null, true);
    }

    public LoggingThreadFactory(String baseName, boolean isDaemon) {
        this(baseName, null, null, isDaemon);
    }

    public LoggingThreadFactory(String baseName, CommandWrapper commandWrapper) {
        this(baseName, null, commandWrapper, true);
    }

    private String getUniqueName() {
        return this.baseName + this.threadCount.getAndIncrement();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Runnable commandToRun = this.commandWrapper != null ? () -> this.commandWrapper.invoke(runnable) : runnable;
        LoggingThread thread = new LoggingThread(this.getUniqueName(), this.isDaemon, commandToRun);
        if (this.threadInitializer != null) {
            this.threadInitializer.initialize(thread);
        }
        return thread;
    }

    public static interface CommandWrapper {
        public void invoke(Runnable var1);
    }

    public static interface ThreadInitializer {
        public void initialize(Thread var1);
    }
}

