/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.util.Optional;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.logging.Banner;
import org.apache.geode.internal.logging.Configuration;
import org.apache.geode.internal.logging.LogConfigSupplier;
import org.apache.geode.internal.logging.LogFile;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingSessionListeners;
import org.apache.geode.internal.logging.SessionContext;
import org.apache.logging.log4j.Logger;

public class LoggingSession
implements SessionContext {
    private static final Logger logger = LogService.getLogger();
    private final Configuration configuration;
    private final LoggingSessionListeners loggingSessionListeners;
    private volatile boolean logBanner;
    private volatile boolean logConfiguration;
    private SessionContext.State state = SessionContext.State.STOPPED;

    public static LoggingSession create() {
        return LoggingSession.create(Configuration.create(), LoggingSessionListeners.get());
    }

    @VisibleForTesting
    static LoggingSession create(Configuration configuration, LoggingSessionListeners loggingSessionListeners) {
        return new LoggingSession(configuration, loggingSessionListeners);
    }

    LoggingSession(Configuration configuration, LoggingSessionListeners loggingSessionListeners) {
        this.configuration = configuration;
        this.loggingSessionListeners = loggingSessionListeners;
    }

    public synchronized void createSession(LogConfigSupplier logConfigSupplier) {
        this.createSession(logConfigSupplier, true, true);
    }

    public synchronized void createSession(LogConfigSupplier logConfigSupplier, boolean logBanner, boolean logConfiguration) {
        this.configuration.initialize(logConfigSupplier);
        this.state = this.state.changeTo(SessionContext.State.CREATED);
        this.loggingSessionListeners.createSession(this);
        this.logBanner = logBanner;
        this.logConfiguration = logConfiguration;
    }

    public synchronized void startSession() {
        this.state = this.state.changeTo(SessionContext.State.STARTED);
        this.loggingSessionListeners.startSession();
        this.configuration.disableLoggingToStandardOutputIfLoggingToFile();
        if (this.logBanner) {
            logger.info(new Banner(this.configuration.getConfigurationInfo()).getString());
        }
        if (this.logConfiguration) {
            String configInfo = this.configuration.getLogConfigSupplier().getLogConfig().toLoggerString();
            logger.info("Startup Configuration: " + configInfo);
        }
    }

    public synchronized void stopSession() {
        this.configuration.enableLoggingToStandardOutput();
        this.state = this.state.changeTo(SessionContext.State.STOPPED);
        this.loggingSessionListeners.stopSession();
    }

    public synchronized void shutdown() {
        this.configuration.shutdown();
    }

    public Optional<LogFile> getLogFile() {
        return this.loggingSessionListeners.getLogFile();
    }

    @Override
    public SessionContext.State getState() {
        return this.state;
    }

    @Override
    public LogConfigSupplier getLogConfigSupplier() {
        return this.configuration.getLogConfigSupplier();
    }

    @VisibleForTesting
    LoggingSessionListeners getLoggingSessionListeners() {
        return this.loggingSessionListeners;
    }
}

