/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geode.distributed.internal.FunctionExecutionPooledExecutor;
import org.apache.geode.distributed.internal.OverflowQueueWithDMStats;
import org.apache.geode.distributed.internal.PoolStatHelper;
import org.apache.geode.distributed.internal.PooledExecutorWithDMStats;
import org.apache.geode.distributed.internal.QueueStatHelper;
import org.apache.geode.distributed.internal.SerialQueuedExecutorWithDMStats;
import org.apache.geode.internal.ScheduledThreadPoolExecutorWithKeepAlive;
import org.apache.geode.internal.logging.LoggingThread;
import org.apache.geode.internal.logging.LoggingThreadFactory;
import org.apache.geode.internal.logging.LoggingUncaughtExceptionHandler;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;

public class LoggingExecutors {
    public static ExecutorService newSerialThreadPool(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, PoolStatHelper stats, ThreadsMonitoring threadsMonitoring, BlockingQueue<Runnable> feed) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new SerialQueuedExecutorWithDMStats(feed, stats, threadFactory, threadsMonitoring);
    }

    public static ExecutorService newSerialThreadPoolWithFeedStatistics(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, PoolStatHelper poolStats, ThreadsMonitoring threadsMonitoring, int feedSize, QueueStatHelper feedStats) {
        BlockingQueue<Runnable> feed = LoggingExecutors.createFeedWithStatistics(feedSize, feedStats);
        return LoggingExecutors.newSerialThreadPool(threadName, threadInitializer, commandWrapper, poolStats, threadsMonitoring, feed);
    }

    public static ExecutorService newSerialThreadPoolWithUnlimitedFeed(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, PoolStatHelper stats, ThreadsMonitoring threadsMonitoring) {
        LinkedBlockingQueue<Runnable> feed = new LinkedBlockingQueue<Runnable>();
        return LoggingExecutors.newSerialThreadPool(threadName, threadInitializer, commandWrapper, stats, threadsMonitoring, feed);
    }

    public static ExecutorService newThreadPoolWithUnlimitedFeed(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, int poolSize, PoolStatHelper poolStats, int msTimeout, ThreadsMonitoring threadsMonitoring) {
        LinkedBlockingQueue<Runnable> feed = new LinkedBlockingQueue<Runnable>();
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new PooledExecutorWithDMStats(feed, poolSize, poolStats, threadFactory, msTimeout, threadsMonitoring);
    }

    public static ExecutorService newThreadPoolWithFixedFeed(String threadName, LoggingThreadFactory.CommandWrapper commandWrapper, int poolSize, PoolStatHelper poolStats, int msTimeout, ThreadsMonitoring threadsMonitoring, int feedSize) {
        ArrayBlockingQueue<Runnable> feed = new ArrayBlockingQueue<Runnable>(feedSize);
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, commandWrapper);
        return new PooledExecutorWithDMStats(feed, poolSize, poolStats, threadFactory, msTimeout, threadsMonitoring);
    }

    public static ExecutorService newFunctionThreadPoolWithFeedStatistics(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, int poolSize, PoolStatHelper poolStats, ThreadsMonitoring threadsMonitoring, int feedSize, QueueStatHelper feedStats) {
        BlockingQueue<Runnable> feed = LoggingExecutors.createFeedWithStatistics(feedSize, feedStats);
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new FunctionExecutionPooledExecutor(feed, poolSize, poolStats, threadFactory, true, threadsMonitoring);
    }

    private static BlockingQueue<Runnable> createFeedWithStatistics(int feedSize, QueueStatHelper feedStats) {
        OverflowQueueWithDMStats<Runnable> feed = feedSize == 0 ? new OverflowQueueWithDMStats<Runnable>(feedStats) : new OverflowQueueWithDMStats(feedSize, feedStats);
        return feed;
    }

    public static ExecutorService newThreadPoolWithFeedStatistics(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, int poolSize, PoolStatHelper poolStats, ThreadsMonitoring threadsMonitoring, int feedSize, QueueStatHelper feedStats) {
        BlockingQueue<Runnable> feed = LoggingExecutors.createFeedWithStatistics(feedSize, feedStats);
        return LoggingExecutors.newThreadPool(threadName, threadInitializer, commandWrapper, poolSize, poolStats, threadsMonitoring, feed);
    }

    public static ExecutorService newThreadPool(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, int poolSize, PoolStatHelper poolStats, ThreadsMonitoring threadsMonitoring, BlockingQueue<Runnable> feed) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new PooledExecutorWithDMStats(feed, poolSize, poolStats, threadFactory, threadsMonitoring);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeed(String threadName, LoggingThreadFactory.CommandWrapper commandWrapper, int poolSize) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, commandWrapper);
        SynchronousQueue<Runnable> feed = new SynchronousQueue<Runnable>();
        return new PooledExecutorWithDMStats(feed, poolSize, threadFactory, null);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeed(String threadName, LoggingThreadFactory.CommandWrapper commandWrapper, int poolSize, PoolStatHelper poolStats, int msTimeout, ThreadsMonitoring threadsMonitoring) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, commandWrapper);
        SynchronousQueue<Runnable> feed = new SynchronousQueue<Runnable>();
        return new PooledExecutorWithDMStats(feed, poolSize, poolStats, threadFactory, msTimeout, threadsMonitoring);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeed(String threadName, int poolSize, PoolStatHelper stats, int msTimeout, RejectedExecutionHandler rejectionHandler) {
        SynchronousQueue<Runnable> feed = new SynchronousQueue<Runnable>();
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName);
        return new PooledExecutorWithDMStats(feed, poolSize, stats, threadFactory, msTimeout, rejectionHandler, null);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeed(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, int corePoolSize, int maximumPoolSize, long keepAliveSeconds) {
        SynchronousQueue<Runnable> blockingQueue = new SynchronousQueue<Runnable>();
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveSeconds, TimeUnit.SECONDS, blockingQueue, threadFactory);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeed(String threadName, int corePoolSize, int maximumPoolSize, long keepAliveSeconds) {
        return LoggingExecutors.newThreadPoolWithSynchronousFeed(threadName, null, null, corePoolSize, maximumPoolSize, keepAliveSeconds);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeedThatHandlesRejection(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, int corePoolSize, int maximumPoolSize, long keepAliveSeconds) {
        SynchronousQueue<Runnable> blockingQueue = new SynchronousQueue<Runnable>();
        RejectedExecutionHandler rejectedExecutionHandler = (r, pool) -> {
            try {
                blockingQueue.put(r);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("interrupted", ex);
            }
        };
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveSeconds, TimeUnit.SECONDS, blockingQueue, threadFactory, rejectedExecutionHandler);
    }

    private static ThreadPoolExecutor newFixedThreadPool(String threadName, boolean isDaemon, int poolSize, long keepAliveSeconds, BlockingQueue<Runnable> feed) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, isDaemon);
        return new ThreadPoolExecutor(poolSize, poolSize, keepAliveSeconds, TimeUnit.SECONDS, feed, threadFactory);
    }

    private static ThreadPoolExecutor newFixedThreadPool(String threadName, boolean isDaemon, long keepAliveSeconds, int poolSize) {
        LinkedBlockingQueue<Runnable> feed = new LinkedBlockingQueue<Runnable>();
        return LoggingExecutors.newFixedThreadPool(threadName, isDaemon, poolSize, keepAliveSeconds, feed);
    }

    public static ExecutorService newFixedThreadPool(String threadName, boolean isDaemon, int poolSize) {
        return LoggingExecutors.newFixedThreadPool(threadName, isDaemon, 0L, poolSize);
    }

    public static ExecutorService newFixedThreadPoolWithTimeout(String threadName, int poolSize, int keepAliveSeconds) {
        return LoggingExecutors.newFixedThreadPool(threadName, true, keepAliveSeconds, poolSize);
    }

    public static ExecutorService newFixedThreadPoolWithTimeout(String threadName, int poolSize, int keepAliveSeconds, QueueStatHelper feedStats) {
        BlockingQueue<Runnable> feed = LoggingExecutors.createFeedWithStatistics(0, feedStats);
        return LoggingExecutors.newFixedThreadPool(threadName, true, poolSize, keepAliveSeconds, feed);
    }

    public static ExecutorService newFixedThreadPoolWithFeedSize(String threadName, int poolSize, int feedSize) {
        LinkedBlockingQueue<Runnable> feed = new LinkedBlockingQueue<Runnable>(feedSize);
        ThreadPoolExecutor.CallerRunsPolicy rejectionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(poolSize, poolSize, 10L, TimeUnit.SECONDS, feed, threadFactory, rejectionHandler);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static ExecutorService newSingleThreadExecutor(String threadName, boolean isDaemon) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, isDaemon);
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newCachedThreadPool(String threadName, boolean isDaemon) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, isDaemon);
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newWorkStealingPool(String threadName, int maxParallelThreads) {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            LoggingUncaughtExceptionHandler.setOnThread(worker);
            worker.setName(threadName + worker.getPoolIndex());
            return worker;
        };
        return new ForkJoinPool(maxParallelThreads, factory, null, true);
    }

    public static Executor newThreadOnEachExecute(String threadName) {
        return command -> new LoggingThread(threadName, command).start();
    }

    public static ScheduledExecutorService newScheduledThreadPool(String threadName, int poolSize) {
        return LoggingExecutors.newScheduledThreadPool(threadName, poolSize, true);
    }

    public static ScheduledExecutorService newScheduledThreadPool(String threadName, int poolSize, boolean executeDelayedTasks) {
        ScheduledThreadPoolExecutor result = new ScheduledThreadPoolExecutor(poolSize, new LoggingThreadFactory(threadName));
        result.setExecuteExistingDelayedTasksAfterShutdownPolicy(executeDelayedTasks);
        return result;
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String threadName) {
        return LoggingExecutors.newScheduledThreadPool(threadName, 1);
    }

    public static ScheduledExecutorService newScheduledThreadPool(String threadName, int poolSize, int keepAliveMillis, ThreadsMonitoring threadsMonitoring) {
        ScheduledThreadPoolExecutorWithKeepAlive result = new ScheduledThreadPoolExecutorWithKeepAlive(poolSize, (long)keepAliveMillis, TimeUnit.MILLISECONDS, new LoggingThreadFactory(threadName), threadsMonitoring);
        result.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        result.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return result;
    }

    private LoggingExecutors() {
    }
}

