/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class GatewaySenderStats {
    public static final String typeName = "GatewaySenderStatistics";
    @Immutable
    private static final StatisticsType type;
    protected static final String EVENTS_RECEIVED = "eventsReceived";
    protected static final String EVENTS_QUEUED = "eventsQueued";
    protected static final String EVENTS_NOT_QUEUED_CONFLATED = "eventsNotQueuedConflated";
    protected static final String EVENTS_CONFLATED_FROM_BATCHES = "eventsConflatedFromBatches";
    protected static final String EVENT_QUEUE_TIME = "eventQueueTime";
    protected static final String EVENT_QUEUE_SIZE = "eventQueueSize";
    protected static final String SECONDARY_EVENT_QUEUE_SIZE = "secondaryEventQueueSize";
    protected static final String EVENTS_PROCESSED_BY_PQRM = "eventsProcessedByPQRM";
    protected static final String TMP_EVENT_QUEUE_SIZE = "tempQueueSize";
    protected static final String EVENTS_DISTRIBUTED = "eventsDistributed";
    protected static final String EVENTS_EXCEEDING_ALERT_THRESHOLD = "eventsExceedingAlertThreshold";
    protected static final String BATCH_DISTRIBUTION_TIME = "batchDistributionTime";
    protected static final String BATCHES_DISTRIBUTED = "batchesDistributed";
    protected static final String BATCHES_REDISTRIBUTED = "batchesRedistributed";
    protected static final String BATCHES_RESIZED = "batchesResized";
    protected static final String UNPROCESSED_TOKENS_ADDED_BY_PRIMARY = "unprocessedTokensAddedByPrimary";
    protected static final String UNPROCESSED_EVENTS_ADDED_BY_SECONDARY = "unprocessedEventsAddedBySecondary";
    protected static final String UNPROCESSED_EVENTS_REMOVED_BY_PRIMARY = "unprocessedEventsRemovedByPrimary";
    protected static final String UNPROCESSED_TOKENS_REMOVED_BY_SECONDARY = "unprocessedTokensRemovedBySecondary";
    protected static final String UNPROCESSED_EVENTS_REMOVED_BY_TIMEOUT = "unprocessedEventsRemovedByTimeout";
    protected static final String UNPROCESSED_TOKENS_REMOVED_BY_TIMEOUT = "unprocessedTokensRemovedByTimeout";
    protected static final String UNPROCESSED_EVENT_MAP_SIZE = "unprocessedEventMapSize";
    protected static final String UNPROCESSED_TOKEN_MAP_SIZE = "unprocessedTokenMapSize";
    protected static final String CONFLATION_INDEXES_MAP_SIZE = "conflationIndexesSize";
    protected static final String EVENTS_FILTERED = "eventsFiltered";
    protected static final String NOT_QUEUED_EVENTS = "notQueuedEvent";
    protected static final String EVENTS_DROPPED_DUE_TO_PRIMARY_SENDER_NOT_RUNNING = "eventsDroppedDueToPrimarySenderNotRunning";
    protected static final String LOAD_BALANCES_COMPLETED = "loadBalancesCompleted";
    protected static final String LOAD_BALANCES_IN_PROGRESS = "loadBalancesInProgress";
    protected static final String LOAD_BALANCE_TIME = "loadBalanceTime";
    protected static final String SYNCHRONIZATION_EVENTS_ENQUEUED = "synchronizationEventsEnqueued";
    protected static final String SYNCHRONIZATION_EVENTS_PROVIDED = "synchronizationEventsProvided";
    private static final int eventsReceivedId;
    private static final int eventsQueuedId;
    private static final int eventsNotQueuedConflatedId;
    private static final int eventQueueTimeId;
    private static final int eventQueueSizeId;
    private static final int secondaryEventQueueSizeId;
    private static final int eventsProcessedByPQRMId;
    private static final int eventTmpQueueSizeId;
    private static final int eventsDistributedId;
    private static final int eventsExceedingAlertThresholdId;
    private static final int batchDistributionTimeId;
    private static final int batchesDistributedId;
    private static final int batchesRedistributedId;
    private static final int batchesResizedId;
    private static final int unprocessedTokensAddedByPrimaryId;
    private static final int unprocessedEventsAddedBySecondaryId;
    private static final int unprocessedEventsRemovedByPrimaryId;
    private static final int unprocessedTokensRemovedBySecondaryId;
    private static final int unprocessedEventsRemovedByTimeoutId;
    private static final int unprocessedTokensRemovedByTimeoutId;
    private static final int unprocessedEventMapSizeId;
    private static final int unprocessedTokenMapSizeId;
    private static final int conflationIndexesMapSizeId;
    private static final int eventsFilteredId;
    private static final int notQueuedEventsId;
    private static final int eventsDroppedDueToPrimarySenderNotRunningId;
    private static final int eventsConflatedFromBatchesId;
    private static final int loadBalancesCompletedId;
    private static final int loadBalancesInProgressId;
    private static final int loadBalanceTimeId;
    private static final int synchronizationEventsEnqueuedId;
    private static final int synchronizationEventsProvidedId;
    private final Statistics stats;

    protected static StatisticsType createType(StatisticsTypeFactory f, String typeName, String description) {
        return f.createType(typeName, description, new StatisticDescriptor[]{f.createIntCounter(EVENTS_RECEIVED, "Number of events received by this queue.", "operations"), f.createIntCounter(EVENTS_QUEUED, "Number of events added to the event queue.", "operations"), f.createLongCounter(EVENT_QUEUE_TIME, "Total time spent queueing events.", "nanoseconds"), f.createIntGauge(EVENT_QUEUE_SIZE, "Size of the event queue.", "operations", false), f.createIntGauge(SECONDARY_EVENT_QUEUE_SIZE, "Size of the secondary event queue.", "operations", false), f.createIntGauge(EVENTS_PROCESSED_BY_PQRM, "Total number of events processed by Parallel Queue Removal Message(PQRM).", "operations", false), f.createIntGauge(TMP_EVENT_QUEUE_SIZE, "Size of the temporary events queue.", "operations", false), f.createIntCounter(EVENTS_NOT_QUEUED_CONFLATED, "Number of events received but not added to the event queue because the queue already contains an event with the event's key.", "operations"), f.createIntCounter(EVENTS_CONFLATED_FROM_BATCHES, "Number of events conflated from batches.", "operations"), f.createIntCounter(EVENTS_DISTRIBUTED, "Number of events removed from the event queue and sent.", "operations"), f.createIntCounter(EVENTS_EXCEEDING_ALERT_THRESHOLD, "Number of events exceeding the alert threshold.", "operations", false), f.createLongCounter(BATCH_DISTRIBUTION_TIME, "Total time spent distributing batches of events to receivers.", "nanoseconds"), f.createIntCounter(BATCHES_DISTRIBUTED, "Number of batches of events removed from the event queue and sent.", "operations"), f.createIntCounter(BATCHES_REDISTRIBUTED, "Number of batches of events removed from the event queue and resent.", "operations", false), f.createIntCounter(BATCHES_RESIZED, "Number of batches that were resized because they were too large", "operations", false), f.createIntCounter(UNPROCESSED_TOKENS_ADDED_BY_PRIMARY, "Number of tokens added to the secondary's unprocessed token map by the primary (though a listener).", "tokens"), f.createIntCounter(UNPROCESSED_EVENTS_ADDED_BY_SECONDARY, "Number of events added to the secondary's unprocessed event map by the secondary.", "events"), f.createIntCounter(UNPROCESSED_EVENTS_REMOVED_BY_PRIMARY, "Number of events removed from the secondary's unprocessed event map by the primary (though a listener).", "events"), f.createIntCounter(UNPROCESSED_TOKENS_REMOVED_BY_SECONDARY, "Number of tokens removed from the secondary's unprocessed token map by the secondary.", "tokens"), f.createIntCounter(UNPROCESSED_EVENTS_REMOVED_BY_TIMEOUT, "Number of events removed from the secondary's unprocessed event map by a timeout.", "events"), f.createIntCounter(UNPROCESSED_TOKENS_REMOVED_BY_TIMEOUT, "Number of tokens removed from the secondary's unprocessed token map by a timeout.", "tokens"), f.createIntGauge(UNPROCESSED_EVENT_MAP_SIZE, "Current number of entries in the secondary's unprocessed event map.", "events", false), f.createIntGauge(UNPROCESSED_TOKEN_MAP_SIZE, "Current number of entries in the secondary's unprocessed token map.", "tokens", false), f.createIntGauge(CONFLATION_INDEXES_MAP_SIZE, "Current number of entries in the conflation indexes map.", "events"), f.createIntCounter(NOT_QUEUED_EVENTS, "Number of events not added to queue.", "events"), f.createIntCounter(EVENTS_DROPPED_DUE_TO_PRIMARY_SENDER_NOT_RUNNING, "Number of events dropped because the primary gateway sender is not running.", "events"), f.createIntCounter(EVENTS_FILTERED, "Number of events filtered through GatewayEventFilter.", "events"), f.createIntCounter(LOAD_BALANCES_COMPLETED, "Number of load balances completed", "operations"), f.createIntGauge(LOAD_BALANCES_IN_PROGRESS, "Number of load balances in progress", "operations"), f.createLongCounter(LOAD_BALANCE_TIME, "Total time spent load balancing this sender", "nanoseconds"), f.createIntCounter(SYNCHRONIZATION_EVENTS_ENQUEUED, "Number of synchronization events added to the event queue.", "operations"), f.createIntCounter(SYNCHRONIZATION_EVENTS_PROVIDED, "Number of synchronization events provided to other members.", "operations")});
    }

    public GatewaySenderStats(StatisticsFactory f, String gatewaySenderId) {
        this.stats = f.createAtomicStatistics(type, "gatewaySenderStats-" + gatewaySenderId);
    }

    public GatewaySenderStats(StatisticsFactory f, String asyncQueueId, StatisticsType statType) {
        this.stats = f.createAtomicStatistics(statType, "asyncEventQueueStats-" + asyncQueueId);
    }

    public void close() {
        this.stats.close();
    }

    public int getEventsReceived() {
        return this.stats.getInt(eventsReceivedId);
    }

    public void incEventsReceived() {
        this.stats.incInt(eventsReceivedId, 1);
    }

    public int getEventsQueued() {
        return this.stats.getInt(eventsQueuedId);
    }

    public int getEventsNotQueuedConflated() {
        return this.stats.getInt(eventsNotQueuedConflatedId);
    }

    public int getEventsConflatedFromBatches() {
        return this.stats.getInt(eventsConflatedFromBatchesId);
    }

    public int getEventQueueSize() {
        return this.stats.getInt(eventQueueSizeId);
    }

    public int getSecondaryEventQueueSize() {
        return this.stats.getInt(secondaryEventQueueSizeId);
    }

    public int getEventsProcessedByPQRM() {
        return this.stats.getInt(eventsProcessedByPQRMId);
    }

    public int getTempEventQueueSize() {
        return this.stats.getInt(eventTmpQueueSizeId);
    }

    public static String getEventQueueSizeId() {
        return EVENT_QUEUE_SIZE;
    }

    public static String getEventTempQueueSizeId() {
        return TMP_EVENT_QUEUE_SIZE;
    }

    public int getEventsDistributed() {
        return this.stats.getInt(eventsDistributedId);
    }

    public int getEventsExceedingAlertThreshold() {
        return this.stats.getInt(eventsExceedingAlertThresholdId);
    }

    public void incEventsExceedingAlertThreshold() {
        this.stats.incInt(eventsExceedingAlertThresholdId, 1);
    }

    public long getBatchDistributionTime() {
        return this.stats.getLong(batchDistributionTimeId);
    }

    public int getBatchesDistributed() {
        return this.stats.getInt(batchesDistributedId);
    }

    public int getBatchesRedistributed() {
        return this.stats.getInt(batchesRedistributedId);
    }

    public int getBatchesResized() {
        return this.stats.getInt(batchesResizedId);
    }

    public void incBatchesRedistributed() {
        this.stats.incInt(batchesRedistributedId, 1);
    }

    public void incBatchesResized() {
        this.stats.incInt(batchesResizedId, 1);
    }

    public void setQueueSize(int size) {
        this.stats.setInt(eventQueueSizeId, size);
    }

    public void setSecondaryQueueSize(int size) {
        this.stats.setInt(secondaryEventQueueSizeId, size);
    }

    public void setEventsProcessedByPQRM(int size) {
        this.stats.setInt(eventsProcessedByPQRMId, size);
    }

    public void setTempQueueSize(int size) {
        this.stats.setInt(eventTmpQueueSizeId, size);
    }

    public void incQueueSize() {
        this.stats.incInt(eventQueueSizeId, 1);
    }

    public void incSecondaryQueueSize() {
        this.stats.incInt(secondaryEventQueueSizeId, 1);
    }

    public void incTempQueueSize() {
        this.stats.incInt(eventTmpQueueSizeId, 1);
    }

    public void incQueueSize(int delta) {
        this.stats.incInt(eventQueueSizeId, delta);
    }

    public void incSecondaryQueueSize(int delta) {
        this.stats.incInt(secondaryEventQueueSizeId, delta);
    }

    public void incEventsProcessedByPQRM(int delta) {
        this.stats.incInt(eventsProcessedByPQRMId, delta);
    }

    public void incTempQueueSize(int delta) {
        this.stats.incInt(eventTmpQueueSizeId, delta);
    }

    public void decQueueSize() {
        this.stats.incInt(eventQueueSizeId, -1);
    }

    public void decSecondaryQueueSize() {
        this.stats.incInt(secondaryEventQueueSizeId, -1);
    }

    public void decTempQueueSize() {
        this.stats.incInt(eventTmpQueueSizeId, -1);
    }

    public void decQueueSize(int delta) {
        this.stats.incInt(eventQueueSizeId, -delta);
    }

    public void decSecondaryQueueSize(int delta) {
        this.stats.incInt(secondaryEventQueueSizeId, -delta);
    }

    public void decTempQueueSize(int delta) {
        this.stats.incInt(eventTmpQueueSizeId, -delta);
    }

    public void incEventsNotQueuedConflated() {
        this.stats.incInt(eventsNotQueuedConflatedId, 1);
    }

    public void incEventsConflatedFromBatches(int numEvents) {
        this.stats.incInt(eventsConflatedFromBatchesId, numEvents);
    }

    public int getUnprocessedTokensAddedByPrimary() {
        return this.stats.getInt(unprocessedTokensAddedByPrimaryId);
    }

    public int getUnprocessedEventsAddedBySecondary() {
        return this.stats.getInt(unprocessedEventsAddedBySecondaryId);
    }

    public int getUnprocessedEventsRemovedByPrimary() {
        return this.stats.getInt(unprocessedEventsRemovedByPrimaryId);
    }

    public int getUnprocessedTokensRemovedBySecondary() {
        return this.stats.getInt(unprocessedTokensRemovedBySecondaryId);
    }

    public int getUnprocessedEventMapSize() {
        return this.stats.getInt(unprocessedEventMapSizeId);
    }

    public int getUnprocessedTokenMapSize() {
        return this.stats.getInt(unprocessedTokenMapSizeId);
    }

    public void incEventsNotQueued() {
        this.stats.incInt(notQueuedEventsId, 1);
    }

    public int getEventsNotQueued() {
        return this.stats.getInt(notQueuedEventsId);
    }

    public void incEventsDroppedDueToPrimarySenderNotRunning() {
        this.stats.incInt(eventsDroppedDueToPrimarySenderNotRunningId, 1);
    }

    public int getEventsDroppedDueToPrimarySenderNotRunning() {
        return this.stats.getInt(eventsDroppedDueToPrimarySenderNotRunningId);
    }

    public void incEventsFiltered() {
        this.stats.incInt(eventsFilteredId, 1);
    }

    public int getEventsFiltered() {
        return this.stats.getInt(eventsFilteredId);
    }

    public void incUnprocessedTokensAddedByPrimary() {
        this.stats.incInt(unprocessedTokensAddedByPrimaryId, 1);
        this.incUnprocessedTokenMapSize();
    }

    public void incUnprocessedEventsAddedBySecondary() {
        this.stats.incInt(unprocessedEventsAddedBySecondaryId, 1);
        this.incUnprocessedEventMapSize();
    }

    public void incUnprocessedEventsRemovedByPrimary() {
        this.stats.incInt(unprocessedEventsRemovedByPrimaryId, 1);
        this.decUnprocessedEventMapSize();
    }

    public void incUnprocessedTokensRemovedBySecondary() {
        this.stats.incInt(unprocessedTokensRemovedBySecondaryId, 1);
        this.decUnprocessedTokenMapSize();
    }

    public void incUnprocessedEventsRemovedByTimeout(int count) {
        this.stats.incInt(unprocessedEventsRemovedByTimeoutId, count);
        this.decUnprocessedEventMapSize(count);
    }

    public void incUnprocessedTokensRemovedByTimeout(int count) {
        this.stats.incInt(unprocessedTokensRemovedByTimeoutId, count);
        this.decUnprocessedTokenMapSize(count);
    }

    public void clearUnprocessedMaps() {
        this.stats.setInt(unprocessedEventMapSizeId, 0);
        this.stats.setInt(unprocessedTokenMapSizeId, 0);
    }

    private void incUnprocessedEventMapSize() {
        this.stats.incInt(unprocessedEventMapSizeId, 1);
    }

    private void decUnprocessedEventMapSize() {
        this.stats.incInt(unprocessedEventMapSizeId, -1);
    }

    private void decUnprocessedEventMapSize(int decCount) {
        this.stats.incInt(unprocessedEventMapSizeId, -decCount);
    }

    private void incUnprocessedTokenMapSize() {
        this.stats.incInt(unprocessedTokenMapSizeId, 1);
    }

    private void decUnprocessedTokenMapSize() {
        this.stats.incInt(unprocessedTokenMapSizeId, -1);
    }

    private void decUnprocessedTokenMapSize(int decCount) {
        this.stats.incInt(unprocessedTokenMapSizeId, -decCount);
    }

    public void incConflationIndexesMapSize() {
        this.stats.incInt(conflationIndexesMapSizeId, 1);
    }

    public void decConflationIndexesMapSize() {
        this.stats.incInt(conflationIndexesMapSizeId, -1);
    }

    public int getConflationIndexesMapSize() {
        return this.stats.getInt(conflationIndexesMapSizeId);
    }

    public long startTime() {
        return DistributionStats.getStatTime();
    }

    public void endBatch(long start, int numberOfEvents) {
        long ts = DistributionStats.getStatTime();
        this.stats.incInt(batchesDistributedId, 1);
        this.stats.incInt(eventsDistributedId, numberOfEvents);
        long elapsed = ts - start;
        this.stats.incLong(batchDistributionTimeId, elapsed);
    }

    public void endPut(long start) {
        long ts = DistributionStats.getStatTime();
        this.stats.incInt(eventsQueuedId, 1);
        long elapsed = ts - start;
        this.stats.incLong(eventQueueTimeId, elapsed);
    }

    public long startLoadBalance() {
        this.stats.incInt(loadBalancesInProgressId, 1);
        return CachePerfStats.getStatTime();
    }

    public void endLoadBalance(long start) {
        long delta = CachePerfStats.getStatTime() - start;
        this.stats.incInt(loadBalancesInProgressId, -1);
        this.stats.incInt(loadBalancesCompletedId, 1);
        this.stats.incLong(loadBalanceTimeId, delta);
    }

    public void incSynchronizationEventsEnqueued() {
        this.stats.incInt(synchronizationEventsEnqueuedId, 1);
    }

    public void incSynchronizationEventsProvided() {
        this.stats.incInt(synchronizationEventsProvidedId, 1);
    }

    public Statistics getStats() {
        return this.stats;
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        type = GatewaySenderStats.createType(f, typeName, "Stats for activity in the GatewaySender");
        eventsReceivedId = type.nameToId(EVENTS_RECEIVED);
        eventsQueuedId = type.nameToId(EVENTS_QUEUED);
        eventsNotQueuedConflatedId = type.nameToId(EVENTS_NOT_QUEUED_CONFLATED);
        eventQueueTimeId = type.nameToId(EVENT_QUEUE_TIME);
        eventQueueSizeId = type.nameToId(EVENT_QUEUE_SIZE);
        secondaryEventQueueSizeId = type.nameToId(SECONDARY_EVENT_QUEUE_SIZE);
        eventsProcessedByPQRMId = type.nameToId(EVENTS_PROCESSED_BY_PQRM);
        eventTmpQueueSizeId = type.nameToId(TMP_EVENT_QUEUE_SIZE);
        eventsDistributedId = type.nameToId(EVENTS_DISTRIBUTED);
        eventsExceedingAlertThresholdId = type.nameToId(EVENTS_EXCEEDING_ALERT_THRESHOLD);
        batchDistributionTimeId = type.nameToId(BATCH_DISTRIBUTION_TIME);
        batchesDistributedId = type.nameToId(BATCHES_DISTRIBUTED);
        batchesRedistributedId = type.nameToId(BATCHES_REDISTRIBUTED);
        batchesResizedId = type.nameToId(BATCHES_RESIZED);
        unprocessedTokensAddedByPrimaryId = type.nameToId(UNPROCESSED_TOKENS_ADDED_BY_PRIMARY);
        unprocessedEventsAddedBySecondaryId = type.nameToId(UNPROCESSED_EVENTS_ADDED_BY_SECONDARY);
        unprocessedEventsRemovedByPrimaryId = type.nameToId(UNPROCESSED_EVENTS_REMOVED_BY_PRIMARY);
        unprocessedTokensRemovedBySecondaryId = type.nameToId(UNPROCESSED_TOKENS_REMOVED_BY_SECONDARY);
        unprocessedEventsRemovedByTimeoutId = type.nameToId(UNPROCESSED_EVENTS_REMOVED_BY_TIMEOUT);
        unprocessedTokensRemovedByTimeoutId = type.nameToId(UNPROCESSED_TOKENS_REMOVED_BY_TIMEOUT);
        unprocessedEventMapSizeId = type.nameToId(UNPROCESSED_EVENT_MAP_SIZE);
        unprocessedTokenMapSizeId = type.nameToId(UNPROCESSED_TOKEN_MAP_SIZE);
        conflationIndexesMapSizeId = type.nameToId(CONFLATION_INDEXES_MAP_SIZE);
        notQueuedEventsId = type.nameToId(NOT_QUEUED_EVENTS);
        eventsDroppedDueToPrimarySenderNotRunningId = type.nameToId(EVENTS_DROPPED_DUE_TO_PRIMARY_SENDER_NOT_RUNNING);
        eventsFilteredId = type.nameToId(EVENTS_FILTERED);
        eventsConflatedFromBatchesId = type.nameToId(EVENTS_CONFLATED_FROM_BATCHES);
        loadBalancesCompletedId = type.nameToId(LOAD_BALANCES_COMPLETED);
        loadBalancesInProgressId = type.nameToId(LOAD_BALANCES_IN_PROGRESS);
        loadBalanceTimeId = type.nameToId(LOAD_BALANCE_TIME);
        synchronizationEventsEnqueuedId = type.nameToId(SYNCHRONIZATION_EVENTS_ENQUEUED);
        synchronizationEventsProvidedId = type.nameToId(SYNCHRONIZATION_EVENTS_PROVIDED);
    }
}

