/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.tx.RemoteOperationMessage;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class RemoteFetchVersionMessage
extends RemoteOperationMessage {
    private static final Logger logger = LogService.getLogger();
    private Object key;

    public RemoteFetchVersionMessage() {
    }

    public static FetchVersionResponse send(InternalDistributedMember recipient, LocalRegion r, Object key) throws RemoteOperationException {
        FetchVersionResponse response = new FetchVersionResponse(r.getSystem(), recipient);
        RemoteFetchVersionMessage msg = new RemoteFetchVersionMessage(recipient, r.getFullPath(), response, key);
        Set<InternalDistributedMember> failures = r.getDistributionManager().putOutgoing(msg);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(String.format("Failed sending < %s >", msg));
        }
        return response;
    }

    private RemoteFetchVersionMessage(InternalDistributedMember recipient, String regionPath, ReplyProcessor21 processor, Object key) {
        super(recipient, regionPath, processor);
        this.key = key;
    }

    @Override
    public int getDSFID() {
        return 155;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.key = DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.key, out);
    }

    @Override
    protected boolean operateOnRegion(ClusterDistributionManager dm, LocalRegion r, long startTime) throws RemoteOperationException {
        r.waitOnInitialization();
        try {
            RegionEntry re = r.getRegionEntry(this.key);
            if (re == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "RemoteFetchVersionMessage did not find entry for key:{}", this.key);
                }
                r.checkEntryNotFound(this.key);
            }
            VersionTag tag = re.getVersionStamp().asVersionTag();
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace("RemoteFetchVersionMessage for key:{} returning tag:{}", this.key, tag);
            }
            FetchVersionReplyMessage.send(this.getSender(), this.processorId, tag, dm);
        }
        catch (EntryNotFoundException e) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(e), r, startTime);
        }
        return false;
    }

    public static class FetchVersionResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private volatile VersionTag<?> tag;

        public FetchVersionResponse(InternalDistributedSystem dm, InternalDistributedMember member) {
            super(dm, member, true);
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof FetchVersionReplyMessage) {
                    FetchVersionReplyMessage reply = (FetchVersionReplyMessage)msg;
                    this.tag = reply.tag;
                    if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "FetchVersionResponse return tag is {}", this.tag);
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        public VersionTag<?> waitForResponse() throws RemoteOperationException {
            try {
                this.waitForRemoteResponse();
            }
            catch (RemoteOperationException e) {
                logger.debug("RemoteFetchVersionMessage threw", (Throwable)e);
                throw e;
            }
            catch (EntryNotFoundException e) {
                logger.debug("RemoteFetchVersionMessage threw", (Throwable)e);
                throw e;
            }
            catch (CacheException e) {
                logger.debug("RemoteFetchVersionMessage threw", (Throwable)e);
                throw new RemoteOperationException("RemoteFetchVersionMessage threw exception", e);
            }
            return this.tag;
        }
    }

    public static class FetchVersionReplyMessage
    extends ReplyMessage {
        private VersionTag<?> tag;

        public FetchVersionReplyMessage() {
        }

        private FetchVersionReplyMessage(int processorId, VersionTag<?> tag) {
            this.setProcessorId(processorId);
            this.tag = tag;
        }

        public static void send(InternalDistributedMember recipient, int processorId, VersionTag<?> tag, DistributionManager dm) {
            FetchVersionReplyMessage reply = new FetchVersionReplyMessage(processorId, tag);
            reply.setRecipient(recipient);
            dm.putOutgoing(reply);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.DM_VERBOSE);
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM_VERBOSE, "FetchVersionReplyMessage process invoking reply processor with processorId:{}", (Object)this.processorId);
            }
            if (processor == null) {
                if (isDebugEnabled) {
                    logger.debug("FetchVersionReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM_VERBOSE, "{}  Processed  {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return 156;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.tag, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.tag = (VersionTag)DataSerializer.readObject(in);
        }
    }
}

