/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.operations.UnregisterInterestOperationContext;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.ResourcePermission;

public class UnregisterInterest
extends BaseCommand {
    @Immutable
    private static final UnregisterInterest singleton = new UnregisterInterest();

    public static Command getCommand() {
        return singleton;
    }

    UnregisterInterest() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws ClassNotFoundException, IOException {
        Part regionNamePart = null;
        Part keyPart = null;
        String regionName = null;
        Object key = null;
        int interestType2 = 0;
        String errMessage = null;
        serverConnection.setAsTrue(2);
        regionNamePart = clientMessage.getPart(0);
        interestType2 = clientMessage.getPart(1).getInt();
        keyPart = clientMessage.getPart(2);
        Part isClosingPart = clientMessage.getPart(3);
        byte[] isClosingPartBytes = (byte[])isClosingPart.getObject();
        boolean isClosing = isClosingPartBytes[0] == 1;
        regionName = regionNamePart.getString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            UnregisterInterest.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        boolean keepalive = false;
        try {
            Part keepalivePart = clientMessage.getPart(4);
            byte[] keepaliveBytes = (byte[])keepalivePart.getObject();
            keepalive = keepaliveBytes[0] != 0;
        }
        catch (Exception e) {
            UnregisterInterest.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received unregister interest request ({} bytes) from {} for region {} key {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)regionName, key);
        }
        if (key == null && regionName == null) {
            errMessage = "The input region name and key for the unregister interest request are null.";
        } else if (key == null) {
            errMessage = "The input key for the unregister interest request is null.";
        } else if (regionName == null) {
            String s = errMessage = "The input region name for the unregister interest request is null.";
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)s);
            UnregisterInterest.writeErrorResponse(clientMessage, 23, s, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        try {
            if (interestType2 == 1) {
                securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName);
            } else {
                securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, key.toString());
            }
        }
        catch (NotAuthorizedException ex) {
            UnregisterInterest.writeException(clientMessage, ex, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
        if (authzRequest != null && !DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
            try {
                UnregisterInterestOperationContext unregisterContext = authzRequest.unregisterInterestAuthorize(regionName, key, interestType2);
                key = unregisterContext.getKey();
            }
            catch (NotAuthorizedException ex) {
                UnregisterInterest.writeException(clientMessage, ex, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        serverConnection.getAcceptor().getCacheClientNotifier().unregisterClientInterest(regionName, key, interestType2, isClosing, serverConnection.getProxyID(), keepalive);
        this.writeReply(clientMessage, serverConnection);
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent unregister interest response for region {} key {}", (Object)serverConnection.getName(), (Object)regionName, key);
        }
    }
}

