/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.operations.RegisterInterestOperationContext;
import org.apache.geode.distributed.internal.LonerDistributionManager;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.ResourcePermission;

public class RegisterInterest61
extends BaseCommand {
    @Immutable
    private static final RegisterInterest61 singleton = new RegisterInterest61();
    public static final boolean VMOTION_DURING_REGISTER_INTEREST_FLAG = false;

    public static Command getCommand() {
        return singleton;
    }

    RegisterInterest61() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, InterruptedException {
        byte[] regionDataPolicyPartBytes;
        Part regionNamePart = null;
        Part keyPart = null;
        String regionName = null;
        Object key = null;
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        regionNamePart = clientMessage.getPart(0);
        regionName = regionNamePart.getString();
        InterestResultPolicy policy = null;
        int interestType2 = clientMessage.getPart(1).getInt();
        try {
            policy = (InterestResultPolicy)clientMessage.getPart(2).getObject();
        }
        catch (Exception e) {
            RegisterInterest61.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        boolean isDurable = false;
        try {
            Part durablePart = clientMessage.getPart(3);
            byte[] durablePartBytes = (byte[])durablePart.getObject();
            isDurable = durablePartBytes[0] == 1;
        }
        catch (Exception e) {
            RegisterInterest61.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        boolean serializeValues = false;
        try {
            Part regionDataPolicyPart = clientMessage.getPart(clientMessage.getNumberOfParts() - 1);
            regionDataPolicyPartBytes = (byte[])regionDataPolicyPart.getObject();
            if (serverConnection.getClientVersion().compareTo(Version.GFE_80) >= 0) {
                serializeValues = regionDataPolicyPartBytes[1] == 1;
            }
        }
        catch (Exception e) {
            RegisterInterest61.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        keyPart = clientMessage.getPart(4);
        regionName = regionNamePart.getString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            RegisterInterest61.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        boolean sendUpdatesAsInvalidates = false;
        if (clientMessage.getNumberOfParts() > 5) {
            try {
                Part notifyPart = clientMessage.getPart(5);
                byte[] notifyPartBytes = (byte[])notifyPart.getObject();
                sendUpdatesAsInvalidates = notifyPartBytes[0] == 1;
            }
            catch (Exception e) {
                RegisterInterest61.writeChunkedException(clientMessage, e, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received register interest 61 request ({} bytes) from {} for region {} key {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)regionName, key);
        }
        if (key == null || regionName == null) {
            String message = null;
            if (key == null) {
                message = "The input key for the register interest request is null";
            }
            if (regionName == null) {
                message = "The input region name for the register interest request is null.";
            }
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
            RegisterInterest61.writeChunkedErrorResponse(clientMessage, 21, message, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
        if (region == null) {
            logger.info("{}: Region named {} was not found during register interest request.", new Object[]{serverConnection.getName(), regionName});
        }
        try {
            if (interestType2 == 1) {
                securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName);
            } else {
                securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, key.toString());
            }
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null && !DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                RegisterInterestOperationContext registerContext = authzRequest.registerInterestAuthorize(regionName, key, interestType2, policy);
                key = registerContext.getKey();
            }
            serverConnection.getAcceptor().getCacheClientNotifier().registerClientInterest(regionName, key, serverConnection.getProxyID(), interestType2, isDurable, sendUpdatesAsInvalidates, true, regionDataPolicyPartBytes[0], true);
        }
        catch (Exception e) {
            RegisterInterest61.checkForInterrupt(serverConnection, e);
            RegisterInterest61.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        CacheClientProxy ccp = serverConnection.getAcceptor().getCacheClientNotifier().getClientProxy(serverConnection.getProxyID());
        if (ccp == null) {
            IOException ioex = new IOException("CacheClientProxy for this client is no longer on the server , so registerInterest operation is unsuccessful");
            RegisterInterest61.writeChunkedException(clientMessage, ioex, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        boolean isPrimary = ccp.isPrimary();
        ChunkedMessage chunkedResponseMsg = serverConnection.getRegisterInterestResponseMessage();
        if (!isPrimary) {
            chunkedResponseMsg.setMessageType(33);
            chunkedResponseMsg.setTransactionId(clientMessage.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.setLastChunk(true);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending register interest response chunk from secondary for region: {} for key: {} chunk=<{}>", (Object)serverConnection.getName(), (Object)regionName, key, (Object)chunkedResponseMsg);
            }
            chunkedResponseMsg.sendChunk(serverConnection);
        } else {
            chunkedResponseMsg.setMessageType(32);
            chunkedResponseMsg.setTransactionId(clientMessage.getTransactionId());
            chunkedResponseMsg.sendHeader();
            try {
                if (region.getDistributionManager() instanceof LonerDistributionManager && region instanceof PartitionedRegion) {
                    throw new IllegalStateException("Should not register interest for a partitioned region when mcast-port is 0 and no locator is present");
                }
                RegisterInterest61.fillAndSendRegisterInterestResponseChunks(region, key, interestType2, serializeValues, policy, serverConnection);
                serverConnection.setAsTrue(1);
            }
            catch (Exception e) {
                RegisterInterest61.writeChunkedException(clientMessage, e, serverConnection, chunkedResponseMsg);
                serverConnection.setAsTrue(1);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sent register interest response for region {} key {}", (Object)serverConnection.getName(), (Object)regionName, key);
            }
        }
    }
}

